//cv-last-month-stats-directive.js
import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';
import 'modules/reports/js/constants/reports.constants.js';

var app = reportsDashboardModule;

app.directive('cvReportsLastMonthJobsStats', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/LastMonthStats.jsp',
		require: [],
		bindToController: {
			dashboardId: '='
		},
		controller: 'LastMonthJobsStatsController',
		controllerAs: 'lastMonthJobsStatsCtrl'
	};
});
app.controller('LastMonthJobsStatsController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	'cvToaster',
	function LastMonthJobsStatsController(
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		PaneEntityTypes,
		cvToaster
	) {
		//
		var self = this;
		this.$onInit = function() {
			self.paneData = {
				title: cvLoc('label.lastDayJobs'),
				titletooltip: cvLoc('label.lastDayJobs'),
				contentClass: 'overview-lastNjobs'
			};

			var drjobs = {
				complete:
					'#/jobs?jobType=126&view=finishedJobs30&status=Completed,Completed%20w%2F%20one%20or%20more%20errors&showAdminJobs=true',
				failed: '#/jobs?jobType=126&view=finishedJobs30&status=Failed&showAdminJobs=true'
			};

			self.entityMetaInfo = {
				testfailover: getEntityObj(cvLoc('label.testFailovers'), true, cvLoc('label.testFailovers'), null, null),
				failover: getEntityObj(cvLoc('label.failovers'), true, cvLoc('label.failovers'), null, null),
				failback: getEntityObj(cvLoc('label.failback'), false, cvLoc('label.failback'), null, null)
			};

			getLastMonthStats();

			function getEntityObj(title, addSeperator, tooltip, dataValue, filterUrl) {
				return {
					title: {
						value: typeof title === 'number' ? title : title.toUpperCase(),
						placement: 'top'
					},
					type: PaneEntityTypes.OVERVIEW,
					addSeperator: addSeperator,
					entityClass:
						typeof title !== 'number'
							? title.toUpperCase() === cvLoc('entity.label.success') || title === cvLoc('entity.label.failed')
								? 'lastMonthjobs-entity'
								: 'lastMonthjobs-border-entity'
							: 'lastMonthjobs-entity',

					tooltip: title,
					value: { valueCount: dataValue },
					filterUrl: {
						url: filterUrl
					}
				};
			}

			function getLastMonthStats() {
				reportsDashboardService
					.getNewLastMonthStats(self.dashboardId)
					.success(function(data) {
						self.errorMsgExists = false;
						if (_.get(data, 'errorMessage')) {
							self.errorMsgExists = true;
							self.noData = true;
							self.paneData.paneClass = 'overview-jobs';
							self.paneData.noData = { text: data.errorMessage };
						}
						processData(reportsDashboardFactory.getJsonFromDSResult(data));
					})
					.error(function(err) {
						console.log(err);
						self.noData = true;
						reportsDashboardFactory.showErrorMessage(err, self.paneData.title);
						self.paneData.paneClass = 'overview-jobs';
						self.paneData.noData = { text: cvLoc('dashboard.error.server') };
					});
			}

			function processData(data) {
				angular.forEach(data, function(row, i) {
					var entity = self.entityMetaInfo[row.type.replace(/ /g, '').toLowerCase()];
					entity.dataObject = [];
					if (row.Success || row.Success === 0) {
						entity.dataObject.push(
							getEntityObj(
								cvLoc('entity.label.success'),
								true,
								cvLoc('entity.label.success'),
								row.Success,
								drjobs.complete
							)
						);
					}
					if (row.Failed || row.Failed === 0) {
						entity.dataObject.push(
							getEntityObj(cvLoc('entity.label.failed'), false, cvLoc('entity.label.failed'), row.Failed, drjobs.failed)
						);
					}
					entity.value = row.CurrentCount ? reportsDashboardFactory.getFormattedNumberNA(row.CurrentCount) : 0;
				});

				var entities = [];
				entities.push(self.entityMetaInfo.testfailover);
				entities.push(self.entityMetaInfo.failover);
				entities.push(self.entityMetaInfo.failback);
				self.paneData.showLoader = false;
				self.paneData.entities = entities;

				if (data.length) {
					self.noData = false;
				} else if (!self.errorMsgExists && !data.length) {
					self.noData = true;
					reportsDashboardFactory.showErrorMessage(cvLoc('dashboard.msg.noDataAvailable'), self.paneData.title);
					self.paneData.paneClass = 'overview-jobs';
					self.paneData.noData = { text: cvLoc('dashboard.error.server') };
				}
			}
		};
	}
]);
