import { reportsDashboardModule } from 'common/js/modules';

import 'modules/reports/js/controllers/newDashboardModal.ctrl.js';
import 'modules/navigation/js/factories/navigation.factory.js';

var app = reportsDashboardModule;

app.directive('cvDashboardTitleDropdown', function() {
	return {
		restrict: 'E',
		scope: {},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/directives/cvDashboardTitleDropdown.jsp',
		require: [],
		bindToController: {
			dashboardType: '=',
			dashboardName: '=',
			dashboardOverrides: '=',
			dashboardNameChanged: '='
		},
		controller: 'DashboardDropdownController',
		controllerAs: 'ddCtrl'
	};
});

app.controller('DashboardDropdownController', [
	'$stateParams',
	'$location',
	'$scope',
	'$timeout',
	'$uibModal',
	'cvLoc',
	'userPrefService',
	'reportsDashboardService',
	'DashboardSettings',
	'ReportsConstants',
	'REGEX',
	'cvNavigationFactory',
	function DashboardDropdownController(
		$stateParams,
		$location,
		$scope,
		$timeout,
		$uibModal,
		cvLoc,
		userPrefService,
		reportsDashboardService,
		DashboardSettings,
		ReportsConstants,
		REGEX,
		cvNavigationFactory
	) {
		var self = this;
		self.dashboardEditor = !cvConfig.hideDashboardEdit && cv.isAdminOnCommcellLevel;
		self.newDashboardText = cvLoc('dashboard.newCustomDashboard');
		self.showInfoIcon = false;
		self.infoText = '';
		var serverTitle =
			cv.userRole == 'Role_MSP_User' || cv.userRole == 'Role_Restricted_User'
				? cvLoc('label.dashboard.overview')
				: cvLoc('label.dashboard.tenant');

		const _commcell = 'commcell';
		const _hyperscalecommcell = 'hyperscalecommcell';
		const _hyperscale = 'hyperscale';
		const _virtualization = 'virtualization';
		const _orchestration = 'disasterRecovery';
		const _tenant = 'tenant';
		const _endpoint = 'endpoint';
		const _activate = 'activate';

		self.dashMeta = {
			commcell: {
				title: cvLoc('label.dashboard.overview'),
				route: '#dashboard/commcell',
				dashboardId: _commcell,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.COMMCELL,
				dashboardTypeName: cvLoc('label.dashboard.overview'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			hyperscalecommcell: {
				title: cvLoc('dashboard.appliance2.title'),
				route: '#dashboard/hyperscalecommcell',
				dashboardId: _hyperscalecommcell,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.APPLIANCE_COMMCELL,
				dashbaordTypeName: cvLoc('dashboard.appliance2.title'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			hyperscale: {
				title: cvLoc('label.dashboard.appliance'),
				route: '#dashboard/hyperscale',
				dashboardId: _hyperscale,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.APPLIANCE,
				dashboardTypeName: cvLoc('label.dashboard.appliance'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			virtualization: {
				title: cvLoc('label.dashboard.virtualization'),
				route: '#dashboard/virtualization',
				dashboardId: _virtualization,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.VIRTUALIZATION,
				dashboardTypeName: cvLoc('label.dashboard.virtualization'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			tenant: {
				title: serverTitle,
				route: '#dashboard/tenant',
				dashboardId: _tenant,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.SERVER,
				dashboardTypeName: serverTitle,
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			endpoint: {
				title: cvLoc('label.dashboard.endpoint'),
				route: '#dashboard/endpoint',
				dashboardId: _endpoint,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.ENDPOINT,
				dashboardTypeName: cvLoc('label.dashboard.endpoint'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			activate: {
				title: cvLoc('label.dashboard.activate'),
				route: '#dashboard/activate',
				dashboardId: _activate,
				dashboardType: ReportsConstants.DASHBOARD_TYPES.ACTIVATE,
				dashboardTypeName: cvLoc('label.dashboard.activate'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			},
			disasterRecovery: {
				title: cvLoc('label.dashboard.disasterrecovery'),
				route: '#dashboard/disasterRecovery',
				dashboardId: _orchestration, //todo: we need to change the  orchestration to disaster recovery in sp21
				dashboardType: ReportsConstants.DASHBOARD_TYPES.DISASTER_RECOVERY,
				dashboardTypeName: cvLoc('label.dashboard.disasterrecovery'),
				category: ReportsConstants.DASHBOARD_CATEGORIES.BUILT_IN
			}
		};

		self.showDropdown = false;
		self.userDashboards = [];
		self.builtInDashboards = [];
		self.allItemsMap = {};
		self.origName = '';
		const numberOnlyPattern = REGEX.NUMBER_ONLY;
		const alphaNumericPattern = REGEX.ALPHANUMERIC;

		function showDropdown(shown = true) {
			if (!cv.isCometApp) {
				self.showDropdown = shown;
			}
		}

		$scope.$on('editDashboard', function(evt, editData) {
			self.dashboardEditMode = editData.isEdit;
		});

		self.$onInit = function() {
			let builtIn = [];
			//fix for delayed display of title in customized built-in
			if (self.dashboardName) {
				self.activeMenu = { title: self.dashboardName };
				if (self.dashMeta[$stateParams.dashboardId]) {
					self.dashMeta[$stateParams.dashboardId].title = self.dashboardName;
				}
			}
			//end fix for delayed display of title

			if ((cv.userRole == 'Role_Msp_Admin' || cv.isTenantAdmin) && !cv.isCometApp) {
				if (cv.isTenantAdmin) {
					builtIn.push(self.dashMeta[_virtualization]);
					builtIn.push(self.dashMeta[_tenant]);
					builtIn.push(self.dashMeta[_endpoint]);
					builtIn.push(self.dashMeta[_orchestration]);
				} else if (cv.userRole == 'Role_Msp_Admin') {
					var showHyperscale = false;
					if (cv.csEnvironmentInfo) {
						if (
							cv.csEnvironmentInfo.isRefArchitecture &&
							!(cv.csEnvironmentInfo.isApplianceCS || cv.csEnvironmentInfo.isCSWithApplianceNode)
						) {
							builtIn.push(self.dashMeta[_hyperscalecommcell]);
						} else {
							builtIn.push(self.dashMeta[_commcell]);
						}
						showHyperscale =
							cv.csEnvironmentInfo.isApplianceCS ||
							cv.csEnvironmentInfo.isRefArchitecture ||
							cv.csEnvironmentInfo.isCSWithApplianceNode;
					}

					if (showHyperscale) {
						builtIn.push(self.dashMeta[_hyperscale]);
					}
					builtIn.push(self.dashMeta[_virtualization]);
					builtIn.push(self.dashMeta[_orchestration]);
					builtIn.push(self.dashMeta[_endpoint]);

					builtIn.push(self.dashMeta[_tenant]);
				}
			} else {
				builtIn.push(self.dashMeta[_tenant]);
			}

			// Only add the activate dashboard if activate is enabled in navigation menu
			if (cvNavigationFactory.isStateAvailable('ediscovery')) {
				builtIn.push(self.dashMeta[_activate]);
			}

			if (builtIn.length > 0) {
				showDropdown();
			}

			self.builtInDashboards = builtIn;
			self.updateAllItemsMap(self.builtInDashboards);

			reportsDashboardService
				.getDataset(ReportsConstants.DASHBOARD_DATASET)
				.then(function(dashboards) {
					if (dashboards) {
						dashboards = dashboards.data;
					}

					if (dashboards && dashboards.records) {
						let userDashboards = [];
						let BUILT_IN_MASK = 128;
						angular.forEach(dashboards.records, function(dData) {
							let flag = dData[ReportsConstants.FLAGS_INDEX];
							if ((flag & BUILT_IN_MASK) != 0) {
								let userReportId = dData[ReportsConstants.USER_REPORT_ID_INDEX];
								let dashID = self.getBuiltinID(userReportId);
								if (dashID) {
									self.dashMeta[dashID].title = dData[ReportsConstants.REPORT_NAME_INDEX];
									self.dashMeta[dashID].category = ReportsConstants.DASHBOARD_CATEGORIES.CUSTOM_BUILT_IN;
								}
								return;
							}
							let dashboard = {
								title: dData[ReportsConstants.REPORT_NAME_INDEX],
								route: '#dashboard/' + dData[ReportsConstants.USER_REPORT_ID_INDEX],
								dashboardId: dData[ReportsConstants.USER_REPORT_ID_INDEX],
								category: ReportsConstants.DASHBOARD_CATEGORIES.CUSTOM
							};
							let props = dData[ReportsConstants.PROPS_INDEX];
							if (props) {
								props = props.split('&quot;').join('"');
								props = JSON.parse(props);
								if (props.dashboardType) {
									let dType = props.dashboardType;
									dashboard.dashboardType = props.dashboardType;
								}
							}
							userDashboards.push(dashboard);
						});
						console.log('Total custom dashboards: ' + userDashboards.length);
						self.userDashboards = userDashboards;
						self.updateAllItemsMap(self.userDashboards);

						if (userDashboards.length > 0) {
							showDropdown();
						}
					}
					self.setActiveMenu($stateParams.dashboardId);
					$timeout(function() {
						$scope.$apply();
					}, 100);
				})
				.catch(function(err) {
					if (err.xhrStatus !== 'abort') {
						console.log('Error fetching custom dashboards');
					}
				});

			if (cv.userRole == 'Role_Msp_Admin' || cv.isTenantAdmin) {
				showDropdown();
			}

			let dashboardId = $stateParams.dashboardId;
			if (!dashboardId) {
				let path = $location.path();
				path = path.replace('/', '');
				dashboardId = self.getMetaDashId(path);
			}
			self.setActiveMenu(dashboardId);
		};

		self.getBuiltinID = function(userReportId) {
			let id = '';
			const keys = Object.keys(self.dashboardOverrides);
			angular.forEach(keys, function(key) {
				if (self.dashboardOverrides[key] === userReportId) {
					id = key;
					return false;
				}
			});
			return id;
		};

		self.getMetaDashId = function(dashId) {
			switch (dashId) {
				case ReportsConstants.DASHBOARD_TYPES.SERVER:
					return _tenant;
				case ReportsConstants.DASHBOARD_TYPES.APPLIANCE:
					return _hyperscale;
				case ReportsConstants.DASHBOARD_TYPES.APPLIANCE_COMMCELL:
					return _hyperscalecommcell;
				case ReportsConstants.DASHBOARD_TYPES.DISASTER_RECOVERY:
					return _orchestration;
				default:
					return dashId;
			}
		};

		self.setActiveMenu = function(dashboardId) {
			if (!dashboardId) {
				return;
			}

			dashboardId = self.getMetaDashId(dashboardId);
			let newActive = null;
			let dashId = undefined;
			self.showInfoIcon = false;
			self.infoText = '';
			if (self.allItemsMap[dashboardId]) {
				newActive = self.allItemsMap[dashboardId];
			} else if (self.dashMeta[dashboardId]) {
				newActive = self.dashMeta[dashboardId];
			}

			if (newActive) {
				if (self.activeMenu) {
					self.activeMenu.active = false;
				}
				newActive.active = true;
				self.activeMenu = newActive;
				self.dashboardName = newActive.title;
				self.origName = newActive.title;

				if (cv.isAdminOnCommcellLevel) {
					dashId = self.getMetaDashId(newActive.dashboardType);
					if (newActive.category === ReportsConstants.DASHBOARD_CATEGORIES.CUSTOM) {
						self.showInfoIcon = true;
						if (self.dashMeta[dashId]) {
							self.infoText = cvLoc('dashboard.infoText', self.dashMeta[dashId].dashboardTypeName);
						} else {
							self.infoText = cvLoc('dashboard.infoText3');
						}
					} else if (newActive.category === ReportsConstants.DASHBOARD_CATEGORIES.CUSTOM_BUILT_IN) {
						self.showInfoIcon = true;
						self.infoText = cvLoc('dashboard.infoText2', self.dashMeta[dashId].dashboardTypeName);
					}
				}
			}
		};

		self.updateAllItemsMap = function(items) {
			angular.forEach(items, function(item) {
				self.allItemsMap[item.dashboardId] = item;
			});
		};

		self.validateNameInput = function(event) {
			let charCode = event.charCode || event.which;
			//space
			if (charCode == 32) {
				return;
			}

			let key = String.fromCharCode(charCode);

			if (!alphaNumericPattern.test(key)) {
				event.preventDefault();
			}
			self.dashboardNameChanged = self.dashboardName !== self.origName;
		};

		self.openNewDashboardModal = function() {
			let dashboards = [];

			dashboards.push(self.dashMeta[_commcell]);
			dashboards.push(self.dashMeta[_tenant]);
			dashboards.push(self.dashMeta[_virtualization]);

			let showHyperscale = false;
			if (cv.csEnvironmentInfo) {
				if (
					cv.csEnvironmentInfo.isRefArchitecture &&
					!(cv.csEnvironmentInfo.isApplianceCS || cv.csEnvironmentInfo.isCSWithApplianceNode)
				) {
					dashboards.push(self.dashMeta[_hyperscalecommcell]);
				}

				showHyperscale =
					cv.csEnvironmentInfo.isApplianceCS ||
					cv.csEnvironmentInfo.isRefArchitecture ||
					cv.csEnvironmentInfo.isCSWithApplianceNode;
			}

			if (showHyperscale) {
				dashboards.push(self.dashMeta[_hyperscale]);
			}

			dashboards.push(self.dashMeta[_endpoint]);
			dashboards.push(self.dashMeta[_activate]);

			var data = {
				modalTitle: cvLoc('dashboard.newCustomDashboard'),
				defaultDashboard: dashboards
			};

			$uibModal.open({
				templateUrl: appUtil.appRoot + 'modules/reports/partials/newDashboardModal.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				controller: 'NewDashboardModalController',
				resolve: {
					data: function() {
						return data;
					}
				}
			});
		};
	}
]);
