(function() {
	var reportsDashboardModule = angular.module('acApp.dashboard');

	reportsDashboardModule.directive('dashboardTilePanel', function() {
		return {
			restrict: 'AEC',
			scope: true,
			bindToController: {},
			templateUrl: appUtil.appRoot + 'modules/reports/partials/dashboardTilePanel.jsp',
			controllerAs: 'tilePanelCtrl',
			controller: 'DashboardTilePanelController'
		};
	});

	reportsDashboardModule.controller('DashboardTilePanelController', [
		'$rootScope',
		'$scope',
		'ReportsConstants',
		'DashboardSettings',
		'reportsDashboardFactory',
		'cvLoc',
		function DashboardTilePanelController(
			$rootScope,
			$scope,
			ReportsConstants,
			DashboardSettings,
			reportsDashboardFactory,
			cvLoc
		) {
			var self = this;
			self.dashboardEditMode = false;
			self.tiles = [];

			self.$onInit = function() {
				$scope.$on('editDashboard', function(evt, editData) {
					self.dashboardEditMode = editData.isEdit;
					self.dashboardType = editData.dashboardType;
					if (editData.isEdit) {
						setTileVisibility(editData.activeTiles);
					}
				});

				$scope.$on('activeTilesChanged', function(evt, tiles) {
					setTileVisibility(tiles);
				});

				angular.copy(Object.values(DashboardSettings.allTiles), self.tiles);

				angular.forEach(self.tiles, function(tile) {
					tile.displayName = getDisplayName(tile.tileType);
					tile.visible = true;
				});

				self.tiles.sort(function(a, b) {
					if (a.displayName === '') {
						return -1;
					}
					return a.displayName.localeCompare(b.displayName);
				});
			};

			function setTileVisibility(activeTiles) {
				if (!activeTiles) {
					return;
				}

				angular.forEach(self.tiles, function(tile) {
					let tileType = tile.tileType;
					if (activeTiles.indexOf(tileType) === -1) {
						tile.visible = true;
						if (
							(tileType === 'CURRENT_CAPACITY' || tileType === 'HEALTH') &&
							self.dashboardType !== ReportsConstants.DASHBOARD_TYPES.COMMCELL
						) {
							tile.visible = false;
						}
					} else {
						tile.visible = false;
					}
				});
			}

			function getDisplayName(tileType) {
				switch (tileType) {
					case 'ENVIRONMENT':
						return cvLoc('dashboard.environment');
					case 'NEED_ATTENTION':
						return cvLoc('dashboard.needAttention');
					case 'SLA':
						return cvLoc('dashboard.sla');
					case 'JOB_STATUS':
						return cvLoc('dashboard.jobStatus');
					case 'HEALTH':
						return cvLoc('dashboard.health');
					case 'CURRENT_CAPACITY':
						return cvLoc('capacity.title');
					case 'DISK_SPACE':
						return cvLoc('dashboard.diskspace.title');
					case 'LARGEST_SERVERS':
						return cvLoc('dashboard.largestServers');
					case 'STORAGE':
						return cvLoc('storageUsage.title');
					case 'HYPERVISORS':
						return cvLoc('pane.hypervisors.title');
					case 'VMS':
						return cvLoc('pane.vms.title');
					case 'JOB_SUMMARY':
						return cvLoc('dashboard.jobSummary');
					case 'LARGEST_HYPERVISORS':
						return cvLoc('dashboard.largestHypervisors');
					case 'LAPTOP_COUNT':
						return cvLoc('dashboard.laptops');
					case 'USER_COUNT':
						return cvLoc('dashboard.endpointUsers');
					case 'ALERT_COUNT':
						return cvLoc('dashboard.endpointAlerts');
					case 'LAPTOP_LOCATION':
						return cvLoc('dashboard.laptopLocation');
					case 'HYPERSCALE_HARDWARE':
						return cvLoc('appliance.appliance.hardware.title');
					case 'ACTIVATE_SDA':
						return cvLoc('sdaOverview.title');
					case 'ACTIVATE_REQ_MANAGER':
						return cvLoc('reqManagerOverview.title');
					case 'ACTIVATE_FSO':
						return cvLoc('fsoOverview.title');
					case 'ACTIVATE_CASE_MANAGER':
						return cvLoc('caseManagerOverview.title');
					case 'SYSTEM':
						return cvLoc('appliance.system');
					case 'DRENVIRONMENT':
						return cvLoc('usageOverview.title');
					case 'LAST_MONTH_STATS':
						return cvLoc('label.lastDayJobs');
					case 'SITE_REPLICATION':
						return cvLoc('label.siteReplication');
					default:
						return '';
				}
			}
		}
	]);
})();
