import { reportsDashboardModule } from 'common/js/modules';

import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/directives/cv-reports-pane-directive.js';
import 'modules/reports/js/directives/cv-reports-disk-space-directive.js';
import 'modules/reports/js/directives/cv-reports-sla-directive.js';
import 'modules/reports/js/directives/cv-reports-lastn-jobs-stats.directive.js';
import 'modules/reports/js/directives/cv-reports-largest-servers-directive.js';
import 'modules/reports/js/directives/cv-reports-usage-overview-directive.js';
import 'modules/reports/js/directives/cv-reports-need-attention-directive.js';
import 'modules/reports/js/directives/cv-reports-system-directive.js';
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';
import 'modules/reports/js/directives/cv-reports-commcell-info-directive.js';
import 'modules/reports/js/directives/cv-reports-health-summary-directive.js';
import 'modules/reports/js/directives/cv-reports-storage-usage-directive.js';
import 'modules/reports/js/directives/cv-reports-hypervisors-vms-directive.js';
import 'modules/reports/js/directives/cv-reports-largest-x-directive.js';
import 'modules/reports/js/directives/cv-reports-single-entity-directive.js';
import 'modules/reports/js/directives/cv-reports-laptop-location-directive.js';
import 'modules/reports/js/directives/cv-reports-current-capacity-directive.js';
import 'modules/reports/js/directives/cv-reports-hyperscale-hardware-directive.js';
import 'modules/reports/js/directives/cv-reports-system-directive.js';
import 'modules/reports/js/directives/cv-reports-disk-space-directive.js';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/constants/reports.constants.js';
import 'modules/reports/js/directives/cv-dashboard-title-dropdown.js';
import 'modules/reports/js/directives/cv-reports-sda-overview-directive.js';
import 'modules/reports/js/directives/cv-reports-req-manager-overview-directive.js';
import 'modules/reports/js/directives/cv-reports-fso-overview-directive.js';
import 'modules/reports/js/directives/cv-reports-case-manager-overview-directive.js';
import 'modules/reports/js/directives/cv-last-month-stats-directive.js';
import 'modules/reports/js/directives/cv-reports-site-replication-directive.js';
import 'modules/reports/js/directives/cv-reports-dr-environement-directive.js';

reportsDashboardModule.directive('cvDashboardTile', function() {
	return {
		restrict: 'AEC',
		scope: true,
		bindToController: {
			tileType: '=',
			data: '=',
			dashboardType: '=',
			customClass: '=',
			fsoLastCollectionTime: '=?',
			sdaLastCollectionTime: '=?'
		},
		templateUrl: appUtil.appRoot + 'modules/reports/partials/dashboardTile.jsp',
		controllerAs: 'dashboardTileCtrl',
		controller: 'CVDashboardTileController'
	};
});

reportsDashboardModule.controller('CVDashboardTileController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvToaster',
	function CVDashboardController(cvLoc, reportsDashboardService, reportsDashboardFactory, cvToaster) {
		var self = this;

		self.$onInit = function() {
			self.tileData = {};
			self.tileDashboardType = '';

			if (self.tileType === 'SLA') {
				self.tileData = self.data.slaData;
			} else if (self.tileType === 'LAPTOP_COUNT') {
				self.tileData = self.data.entities.laptops;
			} else if (self.tileType === 'USER_COUNT') {
				self.tileData = self.data.entities.users;
			} else if (self.tileType === 'ALERT_COUNT') {
				self.tileData = self.data.entities.alerts;
			}

			if (self.tileType === 'ENVIRONMENT' && self.dashboardType === 'server') {
				self.tileDashboardType = 'tenant';
			} else {
				self.tileDashboardType = self.dashboardType;
			}
		};
	}
]);

export default reportsDashboardModule;
