import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

var app = reportsDashboardModule;

app.controller('DataRetentionController', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvToaster',
	'$log',
	function DataRetentionController(cvLoc, reportsDashboardService, reportsDashboardFactory, cvToaster, $log) {
		var self = this;
		self.data = {
			title: cvLoc('dataretention.title'),
			titletooltip: cvLoc('data.retention.title.tooltip')
		};

		self.data.showLoader = true;
		reportsDashboardService
			.getMetricsCommUniqId()
			.success(function(data) {
				self.data.showLoader = false;
				if (!data['records']) {
					$log.error('API format is incorrect.');
					return 0;
				}
				if (data.totalRecordCount <= 0) {
					$log.error('Records does not have .');
					return 0;
				}
				var records = data['records'];
				var commUniId = records[0][2];
				self.data.titleDetailsLink =
					'/webconsole/survey/reports/indcommcellsurvey.jsp?surveyId=141&commUniId=' + commUniId;
				self.data.detailsLinkNewPage = true;
				getDataRetentionData(commUniId);
			})
			.error(function(err) {
				self.data.showLoader = false;
				console.log(err);
				cvToaster.showErrorMessage({
					message: self.data.title + ': ' + err.errorMessage
				});
				self.data.paneClass = 'overview-retention';
				self.data.noData = { text: cvLoc('dashboard.error.server') };
			});

		function getDataRetentionData(commUniId) {
			self.data.showLoader = true;
			reportsDashboardService
				.getDataRetentionData(commUniId)
				.success(function(data) {
					data = reportsDashboardFactory.getJsonFromDSResult(data);
					//console.log(data);
					var naStr = cvLoc('not.applicable.short');
					var days30 = {
						name: cvLoc('dataretention.label.30Days').toUpperCase(),
						size: naStr
					};
					var days90 = {
						name: cvLoc('dataretention.label.90Days').toUpperCase(),
						size: naStr
					};
					var oneyear = {
						name: cvLoc('dataretention.label.oneYear').toUpperCase(),
						size: naStr
					};
					var yearabove = {
						name: cvLoc('dataretention.label.yearAbove').toUpperCase(),
						size: naStr
					};
					if (data.length > 0) {
						var row = data[0];
						if (!isNaN(row['30 Days<SIZEMB>'])) {
							var size = reportsDashboardFactory.getSizeAndUnits(
								reportsDashboardFactory.autoConvertFromMB(row['30 Days<SIZEMB>'])
							);
							days30.size = size.value;
							days30.unit = size.unit;
						}
						if (!isNaN(row['30 To 90 Days<SIZEMB>'])) {
							var size = reportsDashboardFactory.getSizeAndUnits(
								reportsDashboardFactory.autoConvertFromMB(row['30 To 90 Days<SIZEMB>'])
							);
							days90.size = size.value;
							days90.unit = size.unit;
						}
						if (!isNaN(row['90 To 365 Days<SIZEMB>'])) {
							var size = reportsDashboardFactory.getSizeAndUnits(
								reportsDashboardFactory.autoConvertFromMB(row['90 To 365 Days<SIZEMB>'])
							);
							oneyear.size = size.value;
							oneyear.unit = size.unit;
						}
						if (!isNaN(row['Above 365 Days<SIZEMB>'])) {
							var size = reportsDashboardFactory.getSizeAndUnits(
								reportsDashboardFactory.autoConvertFromMB(row['Above 365 Days<SIZEMB>'])
							);
							yearabove.size = size.value;
							yearabove.unit = size.unit;
						}
					}
					var entities = [];
					entities.push(days30);
					entities.push(days90);
					entities.push(oneyear);
					entities.push(yearabove);

					self.data.showLoader = false;
					self.data.entities = entities;
				})
				.error(function(err) {
					self.data.showLoader = false;
					console.log(err);
					cvToaster.showErrorMessage({
						message: self.data.title + ': ' + err.errorMessage
					});
					self.data.noData = { text: cvLoc('dashboard.error.server') };
				});
		}
	}
]);
