import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/directives/cv-reports-pane-entity-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';
import 'modules/reports/js/factory/reports.factory.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Shows the Replication Status pane used for Orchestration Dashboard
 */

reportsDashboardModule.controller('orchestrationReplicationStatsController', [
	'cvLoc',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	function(cvLoc, reportsDashboardFactory, PaneEntityTypes) {
		var self = this;

		// contains the input data for the rpo
		var rpoData = [];
		var slaPercent = '';
		// used to display the legend
		self.rpoLegend = {
			rpomet: '',
			rponotmet: ''
		};

		// contains the data for the last 24 hours pane
		self.replicationStats = {
			paneData: {
				title: cvLoc('pane.replicationStats.title'),
				entities: [],
				showLoader: true
			},
			// Contains the list of all the possible values for the Compute pane
			expectedColumnsEntities: {
				replicationgroups: {
					imgSrc: 'common/img/ReplicationGroups.svg',
					href: '#/replicationGroups',
					entityClass: 'repStatsEntity'
				},
				failoverruns: {
					imgSrc: 'common/img/Info.svg',
					entityClass: 'repStatsEntity'
				},
				replicatedvms: {
					imgSrc: 'common/img/ReplicatedVMs.svg',
					href: '#/replicationMonitor/',
					entityClass: 'repStatsEntity'
				},
				failedreplicationjobs: {
					imgSrc: 'common/img/warning.svg',
					entityClass: 'repStatsEntity'
				}
			},
			expectedColumnsRPO: {
				rpomet: {
					index: -1,
					title: cvLoc('sla.label.met'),
					value: 0
				},
				rponotmet: {
					index: -1,
					title: cvLoc('sla.label.missed'),
					value: 0
				}
			},
			type: PaneEntityTypes.EVENT,
			titlePlacement: 'bottom',
			includeZeros: true,
			datasetName: 'RPOStats',
			noData: {
				text: cvLoc('noData.replicationGroups'),
				href: {
					href: '#/replicationGroups',
					text: cvLoc('dashboard.configure')
				}
			},
			error: cvLoc('error.replicationStats')
		};

		self.rpo = {
			showRPO: false,
			config: {
				options: {
					chart: {
						type: 'pie',
						margin: [0, 0, 0, 0],
						spacingTop: 0,
						spacingBottom: 10,
						spacingLeft: 0,
						spacingRight: 0
					},
					plotOptions: {
						pie: {
							startAngle: 90,
							allowPointSelect: true,
							cursor: 'pointer',
							dataLabels: {
								enabled: false
							},
							showInLegend: true
						},
						series: {
							states: {
								hover: {
									enabled: false
								}
							}
						}
					},
					legend: {
						enabled: false
					},
					exporting: {
						enabled: false
					},
					colors: ['#03C04A', '#F1453D']
				},
				title: {
					text: ''
				},
				subtitle: {
					text: '<div class="dial-center-wrapper"><div class="dial-center-percent">' + slaPercent + '%</div></div>',
					x: 0,
					y: 52,
					floating: true,
					useHTML: true
				},
				credits: {
					enabled: false
				},
				series: [
					{
						name: 'RPO',
						colorByPoint: true,
						animation: true,
						innerSize: '85%',
						data: rpoData
					}
				],
				size: {
					width: 130,
					height: 130
				}
			}
		};

		// Functions that are called when the page loads
		createPaneEntitiesInput(self.replicationStats);

		function createPaneEntitiesInput(entityObject) {
			if (entityObject && entityObject.expectedColumnsEntities && entityObject.datasetName) {
				reportsDashboardFactory
					.getDataset(entityObject.datasetName)
					.success(function(data) {
						entityObject.paneData.showLoader = false;
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							var ReplicationGroupZeroExecption = {};
							try {
								data.columns.forEach(function(column, index) {
									var trimmedColumnName = column.name.toLowerCase().replace(/ /g, '');
									if (entityObject.expectedColumnsEntities[trimmedColumnName]) {
										var columnValue = data.records[0][index] ? data.records[0][index] : 0;

										// If the count of replication groups is zero, do not show the entities.
										// Instead show the link to configure a new replication group
										if (trimmedColumnName === 'replicationgroups' && columnValue === 0) {
											throw ReplicationGroupZeroExecption;
										}
										if (columnValue > 0 || entityObject.includeZeros) {
											var entity = createPaneEntityInputs(trimmedColumnName, columnValue, entityObject);
											entityObject.paneData.entities ? '' : (entityObject.paneData.entities = []);
											entityObject.paneData.entities.push(entity);
										}
									} else if (entityObject.expectedColumnsRPO[trimmedColumnName]) {
										var columnValue = data.records[0][index] ? data.records[0][index] : 0;
										var rpo = [entityObject.expectedColumnsRPO[trimmedColumnName].title, columnValue];
										rpoData.push(rpo);
										entityObject.expectedColumnsRPO[trimmedColumnName].value = columnValue; // used for calculating RPO legend values
									}
								});

								// Remove the seperator of the last entity
								if (entityObject.paneData.entities.length > 0) {
									entityObject.paneData.entities[entityObject.paneData.entities.length - 1].addSeperator = false;
								}

								// Calculation of the RPO legend values
								var totalRPO =
									entityObject.expectedColumnsRPO['rpomet'].value + entityObject.expectedColumnsRPO['rponotmet'].value;
								self.rpoLegend.rpomet = getRPOLegend(entityObject.expectedColumnsRPO['rpomet'].value, totalRPO);
								self.rpoLegend.rponotmet = getRPOLegend(entityObject.expectedColumnsRPO['rponotmet'].value, totalRPO);
								slaPercent =
									totalRPO > 0 ? Math.round((entityObject.expectedColumnsRPO['rpomet'].value / totalRPO) * 100) : 0;
								self.rpo.config.subtitle.text =
									'<div class="dial-center-wrapper"><div class="dial-center-percent">' + slaPercent + '%</div></div>';
								self.rpo.showRPO = true;
							} catch (e) {
								entityObject.paneData.noData = entityObject.noData;
								entityObject.paneData.entities = [];
								self.rpo.showRPO = false;
							}
						} else {
							entityObject.paneData.noData = entityObject.noData;
						}
					})
					.error(function(e) {
						entityObject.paneData.showLoader = false;
						reportsDashboardFactory.showErrorMessage(e ? e.errorMessage : cvLoc('generic_error'));
						entityObject.paneData.noData = {
							text: entityObject.error
						};
					});
			}
		}

		/*
		 * Creates the input entity required for the entityObject.paneData.entities
		 */
		function createPaneEntityInputs(columnName, entityValue, entityObject) {
			return {
				value: entityValue,
				title: {
					value: cvLoc('entity.' + columnName + '.title'),
					placement: entityObject.titlePlacement
				},
				type: entityObject.type,
				imgSrc: !!entityObject.expectedColumnsEntities[columnName].getImgSrc
					? entityObject.expectedColumnsEntities[columnName].getImgSrc(entityValue)
					: entityObject.expectedColumnsEntities[columnName].imgSrc,
				detailsLink: entityObject.expectedColumnsEntities[columnName].href,
				addSeperator: true,
				entityClass: entityObject.expectedColumnsEntities[columnName].entityClass
			};
		}

		function getRPOLegend(value, totalRPO) {
			var percent = totalRPO > 0 ? Math.round((value / totalRPO) * 100) : 0;
			return value + ' (' + percent + '%)';
		}
	}
]);

export default reportsDashboardModule;
