import 'modules/reports/js/constants/paneEntityTypes.constants.js';
import 'modules/reports/js/controllers/orchestration/cloudBackupThroughputPane.ctrl.js';
import 'modules/reports/js/controllers/orchestration/replicationStats.ctrl.js';
import 'modules/reports/js/controllers/orchestration/storagePane.ctrl.js';
import 'modules/reports/js/directives/cv-reports-pane-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';
import 'modules/reports/js/factory/reports.factory.js';

import { reportsDashboardModule } from 'common/js/modules';

/**
 * Shows the Dashboard for Orchestration
 */

reportsDashboardModule.controller('orchestrationDashboard', [
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'PaneEntityTypes',
	function(cvLoc, reportsDashboardService, reportsDashboardFactory, PaneEntityTypes) {
		var self = this;

		// contains the data for the compute pane
		self.compute = {
			paneData: {
				title: cvLoc('pane.compute.title'),
				paneClass: 'row1 compute',
				entities: [],
				titleDetailsLink: '#/uservms',
				showLoader: true
			},
			// Contains the list of all the possible values for the Compute pane
			expectedColumns: {
				'on-premises': {
					imgSrc: 'common/img/OnPremises.svg',
					includeZeros: true
				},
				amazon: {
					imgSrc: 'common/img/Amazon.svg'
				},
				azure: {
					imgSrc: 'common/img/Azure.svg'
				},
				googlecloud: {
					imgSrc: 'common/img/GoogleCloud.svg'
				}
			},
			type: PaneEntityTypes.EVENT,
			titlePlacement: 'top',
			datasetName: 'VMCountByHypervisor',
			entitiesToShow: 3,
			noData: {
				text: cvLoc('noData.cloudVMs'),
				href: {
					href: '#/servers',
					text: cvLoc('dashboard.configure')
				}
			},
			error: cvLoc('error.compute')
		};

		// contains the data for the last 24 hours pane
		self.last24Hrs = {
			paneData: {
				title: cvLoc('pane.last24Hrs.title'),
				entities: [],
				paneClass: 'row1',
				showLoader: true
			},
			// Contains the list of all the possible values for the Compute pane
			expectedColumns: {
				cloudmigrations: {},
				'on-premisesmigrations': {}
			},
			type: PaneEntityTypes.EVENT,
			titlePlacement: 'bottom',
			includeZeros: true,
			datasetName: 'RPOStats',
			error: cvLoc('error.last24Hrs')
		};

		// Functions that are called when the page loads
		createComputePaneEntitiesInput(self.compute);
		reportsDashboardFactory.createPaneEntitiesInput(self.last24Hrs);

		function createComputePaneEntitiesInput(entityObject) {
			if (entityObject && entityObject.expectedColumns && entityObject.datasetName) {
				reportsDashboardService
					.getDataset(entityObject.datasetName)
					.success(function(data) {
						entityObject.paneData.showLoader = false;
						var cloudEntityFound = false;
						if (data && data.columns && data.columns.length > 0 && data.records && data.records.length > 0) {
							data.columns.forEach(function(column, index) {
								var trimmedColumnName = column.name.toLowerCase().replace(/ /g, '');
								var found = entityObject.expectedColumns[trimmedColumnName];
								if (found) {
									var columnValue = data.records[0][index] ? data.records[0][index] : 0;
									if (columnValue > 0 || !!entityObject.includeZeros || !!found.includeZeros) {
										var entity = createPaneEntityInputs(trimmedColumnName, columnValue, entityObject);
										entityObject.paneData.entities ? '' : (entityObject.paneData.entities = []);
										entityObject.paneData.entities.push(entity);

										// Any entity apart from the on-premises is a cloud entity
										cloudEntityFound = trimmedColumnName !== 'on-premises';
									}
								}
							});

							/*
							 * If only On Premises value is available, add an info message showing the link to configure Cloud VMs
							 */
							if (!cloudEntityFound) {
								var noDataEntity = {
									noData: entityObject.noData
								};
								entityObject.paneData.entities.push(noDataEntity);
							}

							// Remove the seperator of the last entity
							if (entityObject.paneData.entities.length > 0) {
								entityObject.paneData.entities[entityObject.paneData.entities.length - 1].addSeperator = false;
							}
						} else {
							entityObject.paneData.noData = entityObject.noData;
						}
					})
					.error(function(e) {
						entityObject.paneData.showLoader = false;
						entityObject.paneData.noData = {
							text: entityObject.error
						};
						reportsDashboardFactory.showErrorMessage(e.errorMessage);
					});
			}
		}

		/*
		 * Creates the input entity required for the entityObject.paneData.entities
		 */
		function createPaneEntityInputs(columnName, entityValue, entityObject) {
			return {
				value: entityValue,
				title: {
					value: cvLoc('entity.' + columnName + '.title'),
					placement: entityObject.titlePlacement
				},
				type: entityObject.type,
				imgSrc: !!entityObject.expectedColumns[columnName].getImgSrc
					? entityObject.expectedColumns[columnName].getImgSrc(entityValue)
					: entityObject.expectedColumns[columnName].imgSrc,
				detailsLink: entityObject.expectedColumns[columnName].href,
				addSeperator: true,
				entityClass: entityObject.expectedColumns[columnName].entityClass
			};
		}
	}
]);

export default reportsDashboardModule;
