import { reportsDashboardModule } from 'common/js/modules';

import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/constants/reports.constants.js';
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';

var app = reportsDashboardModule;

app.controller('NeedsAttentionJobsController', [
	'$state',
	'$stateParams',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvBreadcrumbsTabsFactory',
	'tabService',
	'cvToaster',
	function NeedsAttentionJobsController(
		$state,
		$stateParams,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		cvBreadcrumbsTabsFactory,
		tabService,
		cvToaster
	) {
		var self = this;
		self.data = {};

		self.jobImg = appUtil.appRoot + 'common/img/jobs.svg';

		var tabs = reportsDashboardFactory.getNeedsAttentionTabs();

		tabService.init({
			tabs: [tabs.SERVERS, tabs.INFRASTRUCTURES, tabs.JOBS],
			actions: [],
			onActionItemSelect: function() {},
			activeTab: tabs.JOBS.tabIndex
		});

		angular.element('.content-page').addClass('need-attention-detail');
		var navSource = $stateParams['nav'];
		tabService.setParam('nav', navSource);

		var navs = [];
		if (navSource) {
			navs = navSource.split(',');
		}

		//add breadcrumb
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('title.' + navs[0]),
				link: '#/' + navs[0]
			}
		]);

		//secondary page
		if (navs.length > 1) {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('title.' + navs[1]),
					link: '#/' + navs[1] + '/?nav=' + navs[0]
				}
			]);
		}

		processData();

		function processData() {
			self.data.showLoader = true;
			reportsDashboardService
				.getJobsNeedsAttentionData()
				.success(function(data) {
					if (!data) {
						console.log('No records found for servers.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					if (!data.jobs || data.jobs.length <= 0) {
						console.log('Records has no rows. Returning false.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					self.data.showLoader = false;
					formatData(data);
				})
				.error(function(err) {
					console.log(err);
					self.data.showLoader = false;
					self.data.noData = { text: cvLoc('dashboard.error.server') };
					cvToaster.showErrorMessage({
						message: 'Needs Attention - Jobs: ' + err.errorMessage
					});
				});
		}

		function formatData(rawData) {
			var jobs = [];
			angular.forEach(rawData.jobs, function(data) {
				var jobData = data.jobSummary;
				var job = {};
				job.jobId = jobData.jobId;
				job.reason = jobData.pendingReason;
				job.percentComplete = jobData.percentComplete;
				job.clientName = jobData.subclient.clientName;
				job.appName = jobData.subclient.appName;
				job.subclientName = jobData.subclient.subclientName;
				job.commCellName = jobData.subclient.commCellName;
				job.status = jobData.localizedStatus;
				if (jobData.jobStartTime > 0 && jobData.jobEndTime > 0) {
					var time = getElapsedTime(jobData.jobStartTime, jobData.jobEndTime);
					job.elapseTime = cvLoc('jobs.detail.elapse', time.hours, time.mins, time.secs);
				} else if (jobData.jobStartTime > 0) {
					var time = getElapsedTime(jobData.jobStartTime, new Date().getTime() / 1000);
					job.elapseTime = cvLoc('jobs.detail.elapse', time.hours, time.mins, time.secs);
				} else {
					job.elapseTime = cvLoc('jobs.detail.na');
				}

				if (jobData.thresholdTime && jobData.thresholdTime > 0) {
					var hours = Math.floor(jobData.thresholdTime / 60);
					var mins = Math.floor(jobData.thresholdTime % 60);
					if (hours > 0) {
						job.threshold = cvLoc('servers.detail.timeHrsMins', hours, mins);
					} else {
						job.threshold = cvLoc('servers.detail.timeMins', mins);
					}
				}

				jobs.push(job);
			});
			self.data.jobs = jobs;
		}

		function getElapsedTime(startTime, endTime) {
			var time = {};
			var elapse = endTime - startTime; //in seconds
			var totalMins = elapse / 60;
			var elapseSeconds = Math.floor(elapse % 60);
			var elapseHour = Math.floor(totalMins / 60);
			var elapseMins = Math.floor(totalMins % 60);
			time.hours = elapseHour;
			time.mins = elapseMins;
			time.secs = elapseSeconds;

			return time;
		}
	}
]);

export default app;
