import { reportsDashboardModule } from 'common/js/modules';

import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/constants/reports.constants.js';
import 'modules/reports/js/directives/cv-reports-no-data-directive.js';
import 'modules/reports/js/directives/cv-reports-show-loader-directive.js';

var app = reportsDashboardModule;

app.controller('NeedsAttentionInfrastructureController', [
	'$state',
	'$stateParams',
	'cvLoc',
	'reportsDashboardService',
	'reportsDashboardFactory',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'tabService',
	function NeedsAttentionInfrastructureController(
		$state,
		$stateParams,
		cvLoc,
		reportsDashboardService,
		reportsDashboardFactory,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		tabService
	) {
		var self = this;
		self.data = {};
		self.serverImg = appUtil.appRoot + 'common/img/infrastructures.svg';
		var tabs = reportsDashboardFactory.getNeedsAttentionTabs();

		tabService.init({
			tabs: [tabs.SERVERS, tabs.INFRASTRUCTURES],
			actions: [],
			onActionItemSelect: function() {},
			activeTab: tabs.INFRASTRUCTURES.tabIndex
		});

		angular.element('.content-page').addClass('need-attention-detail');
		var navSource = $stateParams['nav'];

		var navs = [];
		if (navSource) {
			navs = navSource.split(',');
		}

		//add breadcrumb
		let title = 'title.' + navs[0];
		if (navs[0].indexOf('dashboard') != -1) {
			title = 'title.dashboard';
		}
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc(title),
				link: '#/' + navs[0]
			}
		]);

		//secondary page
		if (navs.length > 1) {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('title.' + navs[1]),
					link: '#/' + navs[1] + '/?nav=' + navs[0]
				}
			]);
		}

		var AnomalyTypesToReason = {
			0: cvLoc('servers.detail.allBad'),
			1: cvLoc('servers.detail.failedJob'),
			2: cvLoc('servers.detail.missedSLA'),
			4: cvLoc('servers.detail.highCPUUsage'),
			8: cvLoc('servers.detail.highMemoryUsage'),
			16: cvLoc('servers.detail.memoryLeak'),
			32: cvLoc('servers.detail.unreachable')
		};

		var InfrastructureType = {
			1: 'MediaAgent',
			2: 'WebServer',
			3: 'WebConsole'
		};

		processData();

		function processData() {
			self.data.showLoader = true;
			reportsDashboardService
				.getInfrastructureNeedsAttentionData()
				.success(function(data) {
					if (!data) {
						console.log('No records found for infrastructures.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					if (!data.anomalousClients || data.anomalousClients.length <= 0) {
						console.log('Records has no rows. Returning false.');
						self.data.showLoader = false;
						self.data.noData = { text: cvLoc('dashboard.msg.noDataAvailable') };
						return;
					}

					self.data.showLoader = false;
					formatData(data);
				})
				.error(function(err) {
					console.log(err);
					self.data.showLoader = false;
					self.data.noData = { text: cvLoc('dashboard.error.server') };
					cvToaster.showErrorMessage({
						message: 'Needs Attention - infrastructures: ' + err.errorMessage
					});
				});
		}

		function formatData(rawData) {
			var clients = [];
			var anomalyClients = [];
			angular.forEach(rawData.anomalousClients, function(anomaly) {
				var index = clients.indexOf(anomaly.entity.clientId);
				var detailData = {};
				if (index != -1) {
					detailData = anomalyClients[index];
					if (detailData.type == anomaly.anomalyDetails[0].type) {
						detailData.formattedType += '/' + InfrastructureType[anomaly.infrastructureType];
						return false;
					}
				}

				var detail = anomaly.anomalyDetails[0];
				detailData.type = detail.type;
				detailData.infrastructureType = anomaly.infrastructureType;
				detailData.clientName = anomaly.entity.clientName;
				detailData.reason = AnomalyTypesToReason[detail.type];
				detailData.formattedType = InfrastructureType[anomaly.infrastructureType];
				if (detail.type == 4 || detail.type == 8) {
					detailData.countLabel = cvLoc('servers.detail.duration') + ':';
					var hours = parseInt(detail.currentCount / 60);
					var mins = detail.currentCount % 60;
					if (hours > 0) {
						detailData.formattedCount = cvLoc('servers.detail.timeHrsMins', hours, mins);
					} else {
						detailData.formattedCount = cvLoc('servers.detail.timeMins', mins);
					}
					detailData.drillURL =
						'#/reportDetails?name=Infrastructure%20Load&app=ADMIN_CONSOLE&Facet1538075812282.filter.name=["' +
						anomaly.entity.clientName +
						'"]';
				} else if (detail.type == 1) {
					detailData.countLabel = cvLoc('servers.detail.jobsAffected') + ':';
					detailData.formattedCount = detail.currentCount;
					//				disable drill until filter on media agent is supported
					//				var serverIdParam = "";
					//				if (anomaly.entity.clientId) {
					//					serverIdParam = "&serverId=" + anomaly.entity.clientId;
					//				}
					//				detailData.drillURL = "#/jobs?view=finishedJobs1" + serverIdParam;
				} else if (detail.type == 32) {
					detailData.countLabel = '';
					detailData.formattedCount = '';
				}

				detailData.detailsLink = '#/clientDetails/' + anomaly.entity.clientId;
				if (anomaly.infrastructureType == 1) {
					detailData.detailsLink = '#/mediaAgent/' + anomaly.entity.clientId;
				}

				clients.push(anomaly.entity.clientId);
				anomalyClients.push(detailData);
			});
			self.data.servers = anomalyClients;
		}
	}
]);

export default app;
