import { reportsDashboardModule } from 'common/js/modules';
import 'modules/reports/js/services/reports.svc';
import 'modules/reports/js/factory/reports.factory.js';

var app = reportsDashboardModule;

app.controller('NeedAttentionController', [
	'cvLoc',
	'reportsService',
	'reportsFactory',
	function NeedAttentionController(cvLoc, reportsService, reportsFactory) {
		var self = this;

		var needAttentionEntities = [
			{
				value: 3,
				title: cvLoc('entity.label.servers').toUpperCase(),
				type: 'overview',
				imgSrc: appUtil.appRoot + 'common/img/servers.svg',
				addSeperator: true
			},
			{
				value: 10,
				title: cvLoc('entity.label.infrastructures').toUpperCase(),
				type: 'overview',
				imgSrc: appUtil.appRoot + 'common/img/infrastructures.svg',
				addSeperator: true
			},
			{
				value: 5,
				title: cvLoc('entity.label.jobs').toUpperCase(),
				type: 'overview',
				imgSrc: appUtil.appRoot + 'common/img/jobs.svg'
			}
		];

		self.needAttentionPane = {
			title: cvLoc('appliance.needAttention'),
			entities: needAttentionEntities
		};
	}
]);
