import { reportsDashboardModule } from 'common/js/modules';

import 'adminConsole/js/directives/cv-select2.directive.js';

reportsDashboardModule.controller('DashboardSecurityController', [
	'$uibModalInstance',
	'data',
	'reportsDashboardFactory',
	'cvLoc',
	'cvToaster',
	'reportService',
	'userService',
	'ReportsConstants',
	function(
		$modalInstance,
		data,
		reportsDashboardFactory,
		cvLoc,
		cvToaster,
		reportService,
		userService,
		ReportsConstants
	) {
		var self = this;
		self.data = data;
		const PERMISSIONS = {
			View: {
				permissionId: ReportsConstants.REPORT_EXECUTE_CAPABILITY_ID,
				permissionName: 'Execute Report',
				permissionDesc: 'Can view the data of the report',
				categoryId: ReportsConstants.REPORT_PERMISSION_CATEGORY_ID,
				_type_: ReportsConstants.ENTITY_TYPES_ID.PERMISSION_ENTITY
			}
		};

		self.serverMessage = {};

		self.securityAssociations = [];

		self.$onInit = function() {
			setTimeout(function() {
				$('#userList').select2({
					placeholder: cvLoc('dashboard.placeholder.enterUserOrGroup'),
					width: '100%',
					createSearchChoice: function(term, data) {},
					selectOnBlur: true,
					closeOnSelect: false,
					multiple: false,
					minimumInputLength: 0,
					formatResult: self.format,
					formatSelection: self.format,
					resetOnSelected: true,
					ajax: {
						url: 'getUserSuggestionsListPlan.do',
						dataType: 'json',
						type: 'GET',
						quietMillis: 50,
						data: function(term) {
							return {
								term: term,
								serviceCommcellName: cv.commcellName
							};
						},
						transport: function(params) {
							params.beforeSend = function(request) {
								$('#addButton').addClass('disabled');
								request.setRequestHeader('csrf', cvUtil.readCookie('csrf'));
							};
							return $.ajax(params);
						},
						results: function(data) {
							$('#addButton').removeClass('disabled');
							return {
								results: $.map(data, function(item) {
									return {
										text: item.name + ' (' + item.loginName + ')',
										loginName: item.loginName,
										name: item.name,
										id: item.userInfo.id,
										type: item.userInfo.userType
									};
								})
							};
						}
					}
				});
			}, 1);

			reportService
				.getDataForDataSetViaProxy(
					'Security/' +
						ReportsConstants.ENTITY_TYPES_ID.REPORT_PLUS_ENTITY +
						'/' +
						self.data.dashboardReportId +
						'?processHiddenPermission=1',
					'/api/'
				)
				.then(function(resultData) {
					if (
						resultData.data &&
						resultData.data.securityAssociations &&
						resultData.data.securityAssociations.length > 0
					) {
						if (
							resultData.data.securityAssociations[0].securityAssociations &&
							resultData.data.securityAssociations[0].securityAssociations.associations
						) {
							_.each(resultData.data.securityAssociations[0].securityAssociations.associations, function(assoc) {
								let userOrGroup = assoc.userOrGroup[0];
								let prop = assoc.properties;
								let entity = {};

								entity.entityType = userOrGroup._type_;
								if (userOrGroup._type_ === ReportsConstants.ENTITY_TYPES_ID.USER_ENTITY) {
									entity.entityId = userOrGroup.userId;
									entity.entityName = userOrGroup.userName;
									entity.cssName = 'user-type';
								} else if (userOrGroup._type_ === ReportsConstants.ENTITY_TYPES_ID.USERGROUP_ENTITY) {
									entity.entityId = userOrGroup.userGroupId;
									entity.entityName = userOrGroup.userGroupName;
									entity.cssName = 'group-type';
								} else if (userOrGroup._type_ === ReportsConstants.ENTITY_TYPES_ID.EXTERNAL_GROUP_ENTITY) {
									entity.entityId = userOrGroup.groupId;
									entity.entityName = userOrGroup.providerDomainName + '\\' + userOrGroup.externalGroupName;
									entity.cssName = 'group-type';
									entity.entityType = ReportsConstants.ENTITY_TYPES_ID.USERGROUP_ENTITY;
								}

								entity.isCreator = prop.isCreatorAssociation;
								entity.permissions = prop.categoryPermission ? prop.categoryPermission.categoriesPermissionList : [];
								self.securityAssociations.push(entity);
							});
						}
					}
					self.loaded = true;
				})
				.catch(function(err) {
					console.log('Error fetching security associations. ' + err);
					cvToaster.showErrorMessage({
						message: cvLoc('dashboard.security.assocError')
					});
					self.loaded = true;
				});

			self.updateSecurityRequest = {
				entityAssociated: {
					entity: [
						{
							entityType: 131,
							entityId: self.data.dashboardReportId,
							entityName: self.data.dashboardName,
							_type_: ReportsConstants.ENTITY_TYPES_ID.CUSTOM_ENTITY,
							entityTypeName: 'Report'
						}
					]
				},
				securityAssociations: {
					associations: [],
					associationsOperationType: 'OVERWRITE',
					processHiddenPermission: 1
				}
			};
		};

		self.isUserSelected = function() {
			let selectedItem = $('#userList').select2('data');
			if (selectedItem && selectedItem.loginName && selectedItem.loginName.length > 0) {
				return true;
			}
			return false;
		};

		self.addNewUserOrGroup = function() {
			let selectedItem = $('#userList').select2('data');
			let userItem = {
				entityName: selectedItem.loginName,
				entityId: selectedItem.id
			};

			switch (selectedItem.type) {
				case 'USER':
					userItem.entityType = ReportsConstants.ENTITY_TYPES_ID.USER_ENTITY;
					userItem.cssName = 'user-type';
					break;
				case 'COMMCELL_GROUP':
					userItem.entityType = ReportsConstants.ENTITY_TYPES_ID.USERGROUP_ENTITY;
					userItem.cssName = 'group-type';
					break;
				case 'EXTERNAL_GROUP':
					userItem.entityType = ReportsConstants.ENTITY_TYPES_ID.USERGROUP_ENTITY;
					userItem.cssName = 'group-type';
					break;
			}

			for (let i in self.securityAssociations) {
				let user = self.securityAssociations[i];
				if (userItem.entityName == user.entityName && userItem.entityType == user.entityType) {
					self.serverMessage.message = cvLoc('error.duplicateAssociation');
					self.serverMessage.type = 'error';
					return;
				}
			}
			self.securityAssociations.push(userItem);
			$('#userList').select2('data', null);
		};

		self.userSelectionChanged = function() {
			self.clearErrorMessage();
		};

		self.removeUser = function(user) {
			self.clearErrorMessage();
			var index = self.securityAssociations.indexOf(user);
			if (index > -1) {
				self.securityAssociations.splice(index, 1);
			}
		};

		self.clearErrorMessage = function() {
			self.serverMessage = {
				message: '',
				type: ''
			};
		};

		self.modalClose = function() {
			$modalInstance.dismiss();
		};

		self.updateRequestObject = function(user, index) {
			if (self.securityAssociations.length > 0) {
				_.each(self.securityAssociations, function(user) {
					if (user.isCreator) {
						return;
					}

					let userItem = {
						_type_: user.entityType
					};

					if (user.entityType == ReportsConstants.ENTITY_TYPES_ID.USER_ENTITY) {
						userItem.userName = user.entityName;
						userItem.userId = user.entityId;
					} else {
						userItem.userGroupName = user.entityName;
						if (user.entityId) {
							userItem.userGroupId = user.entityId;
						}
					}

					let permissions = [];
					if (user.permissions && user.permissions.length > 0) {
						permissions = user.permissions;
					} else {
						permissions.push(PERMISSIONS.View);
					}

					self.updateSecurityRequest.securityAssociations.associations.push({
						userOrGroup: [userItem],
						properties: {
							categoryPermission: {
								categoriesPermissionList: permissions
							},
							isCreatorAssociation: user.isCreator
						}
					});
				});
			}
		};

		self.updateSecurityAssociations = function() {
			self.updateSecurityRequest.securityAssociations.associations = [];
			self.updateRequestObject();
			return reportService
				.postDataForDataSetViaProxy('Security', self.updateSecurityRequest, '/api/')
				.then(function(resultData) {
					if (resultData.data.response[0]['errorString']) {
						customReportSvc.errorToast(resultData.data.response[0]['errorString']);
					} else {
						cvToaster.showSuccessMessage({
							message: cvLoc('dashboard.security.updateSuccess')
						});

						$modalInstance.close();
					}
				})
				.catch(function(err) {
					console.log('Error updating security associations. ' + err);
					cvToaster.showErrorMessage({
						message: cvLoc('dashboard.security.updateError')
					});
				});
		};

		self.format = function(state) {
			if (state.type === 'USER') {
				return "<span class='user-type plan-user-suggestion' title='" + state.text + "'>" + state.text + '</span>';
			} else if (state.type === 'COMMCELL_GROUP' || state.type === 'EXTERNAL_GROUP') {
				return "<span class='group-type plan-user-suggestion' title='" + state.text + "'>" + state.text + '</span>';
			}
		};
	}
]);

export default reportsDashboardModule;
