import 'modules/policies/subclientPolicy/js/services/subclientPolicies.svc.js';

import { policyModule } from 'common/js/modules';

var subclientPolicyFact = policyModule;

subclientPolicyFact.factory('subclientPolicyFactory', [
	'cvLoc',
	'$log',
	'$rootScope',
	'$uibModal',
	'$state',
	'$stateParams',
	'cvToaster',
	'subclientPolicyService',
	'$dialogs',
	function(cvLoc, $log, $rootScope, $modal, $state, $stateParams, cvToaster, subclientPolicyService, $dialogs) {
		var factory = {};

		factory.deleteSubclientPolicy = function(subclientPolicyEntity) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					subclientPolicyService
						.deleteSubclientPolicy({
							genericEntity: angular.toJson(subclientPolicyEntity)
						})
						.success(function(data) {
							cvToaster.showSuccessMessage({
								message: cvLoc('label.deletePolicySuccess')
							});
							$state.transitionTo('subclientPolicies', $stateParams, {
								reload: true,
								inherit: false,
								notify: true
							});
						})
						.error(function(e) {
							cvToaster.showErrorMessage({
								ttl: '10000',
								message: e ? e : cvLoc('generic_error')
							});
						});
				}
			};

			$dialogs.confirm(
				cvLoc('label.confirmDeleteSubclientPolicy'),
				cvLoc('label.confirmMessagePolicy', '<b>' + subclientPolicyEntity.subclientPolicyName + '</b>'),
				callBackFunctions
			);
		};

		factory.addNewSubclient = function(params, subclientPolicyId, subclientPolicyName) {
			if (
				params == undefined ||
				params.idaEntity == undefined ||
				params.idaEntity.applicationId == undefined ||
				params.idaEntity.applicationId < 1
			) {
				$log.error('createSubclient:Invalid inputs for subclient creation');
				cvToaster.showErrorMessage({
					ttl: '5000',
					message: cvLoc('generic_error')
				});
				return;
			}
			var jspFileRelativePath = 'adminConsole/partials/createFsSubclient.jsp';
			var controllerName = 'createSubclientController';
			var inputParamsToController = function() {
				return params;
			};
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + jspFileRelativePath,
				controller: controllerName,
				backdrop: 'static',
				resolve: {
					createSubclientParams: inputParamsToController
				}
			});
			modalInstance.result.then(
				function(subclientDetail) {
					if (subclientDetail) {
						subclientPolicyService
							.addSubclient(subclientPolicyId, subclientPolicyName, JSON.stringify(subclientDetail))
							.success(function(data) {
								cvToaster.showSuccessMessage({
									message: cvLoc('label.subclientAdded')
								});
								$state.transitionTo('subclientPolicyDetail', $stateParams, {
									reload: true,
									inherit: false,
									notify: true
								});
							})
							.error(function(e) {
								cvToaster.showErrorMessage({
									ttl: '10000',
									message: e ? e : cvLoc('generic_error')
								});
							});
					}
				},
				function() {}
			);
		};

		factory.editAssociation = function(associationItems, subclientPolicyId, subclientPolicyName, dissociateBackupsets) {
			subclientPolicyService
				.editAssociation(associationItems, subclientPolicyId, subclientPolicyName, dissociateBackupsets)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: cvLoc('label.associationSaved')
					});
					$state.transitionTo('subclientPolicyDetail', $stateParams, {
						reload: true,
						inherit: false,
						notify: true
					});
				})
				.error(function(e) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e ? e : cvLoc('generic_error')
					});
				});
		};

		factory.sortAssociationNodes = function(node) {
			return _.sortBy(node, function(i) {
				return i.label.toLowerCase();
			});
		};

		return factory;
	}
]);

export default subclientPolicyFact;
