import 'adminConsole/js/directives/acDirectives.js';
import 'modules/policies/subclientPolicy/js/services/subclientPolicies.svc.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicy.factory.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'adminConsole/js/controllers/subclients.ctrl.js';
import 'modules/policies/subclientPolicy/js/controllers/subclientPolicyAssociation.ctrl.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/services/subclients.svc.js';
import 'adminConsole/js/controllers/createSubclient.ctrl.js';

import { policyModule } from 'common/js/modules';

var app = policyModule;

app.controller('subclientPolicyDetailController', [
	'$scope',
	'ENTITY_TYPES',
	'subclientService',
	'$dialogs',
	'subclientPolicyFactory',
	'subclientPolicyService',
	'$stateParams',
	'cvLoc',
	'cvUtil',
	'$state',
	'cvTableOptions',
	'$uibModal',
	'$rootScope',
	'$log',
	'createSubclientFactory',
	'AppTypes',
	'cvToaster',
	'subclientFactory',
	'$location',
	'AppTypesUtil',
	'securityFactory',
	'cvBreadcrumbsTabsFactory',
	'cvEntitySelectionTreeComponent',
	function(
		$scope,
		ENTITY_TYPES,
		subclientService,
		$dialogs,
		subclientPolicyFactory,
		subclientPolicyService,
		$stateParams,
		cvLoc,
		cvUtil,
		$state,
		cvTableOptions,
		$modal,
		$rootScope,
		$log,
		createSubclientFactory,
		AppTypes,
		cvToaster,
		subclientFactory,
		$location,
		AppTypesUtil,
		securityFactory,
		cvBreadcrumbsTabsFactory,
		cvEntitySelectionTreeComponent
	) {
		$scope.serverMessage = {
			message: cvUtil.infoMsgLoc('Loading').message,
			type: 'loader'
		};

		$scope.onDemandBackupset = false;
		$scope.generalTileEditModeEnabled = false;
		cvBreadcrumbsTabsFactory.addBreadCrumbs({
			title: cvLoc('label.subclientPolicies'),
			link: '#/subclientPolicies'
		});

		$scope.changeNameSuccess = function(id, name) {
			if (id === null) {
				$scope.genericEntity.subclientPolicyName = name;
			}
		};

		$scope.model = {};

		$scope.showPlan = false;
		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.securityAssociationsLoaded = false;
		$scope.associationsLoaded = false;
		subclientPolicyService.getSubclientPolicyDetails($stateParams.subclientPolicyId).success(function(data) {
			var securityAssociations = data.subclientPolicy.securityAssociations;
			$scope.entityType = ENTITY_TYPES.SUBCLIENT_POLICY_ENTITY;
			$scope.genericEntity = {
				subclientPolicyId: data.subclientPolicy.subclientPolicyEntity.subclientPolicyId,
				subclientPolicyName: data.subclientPolicy.subclientPolicyEntity.subclientPolicyName,
				idaType: data.subclientPolicy.idaType,
				applicatioId:
					data.subclientPolicy.idaType == 'WINDOWS' ? AppTypes.WINDOWS_FILESYSTEM : AppTypes.APPTYPE_LINUX_FS
			};
			$scope.changeNameObj = {
				id: $scope.genericEntity.subclientPolicyId,
				name: $scope.genericEntity.subclientPolicyName
			};
			$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(securityAssociations);
			$scope.securityAssociationsLoaded = true;
			$scope.subclientPolicyDetail = data.subclientPolicy.subclientPolicyEntity;
			$scope.dissociateBackupsets = data.subclientPolicy.dissociateBackupsets;
			$scope.subclientList = data.subClientPoliciesInfo.subClientPolicy.subClientList;
			$scope.serverMessage = cvUtil.emptyMsg();
			$scope.associationArray = data.subClientPoliciesInfo.assocBackupSet;
			$scope.showPlan = true;
			loadAssociationsListForTree();
		});

		$scope.editSubclientAssociation = function() {
			$modal.open({
				templateUrl: appUtil.appRoot + 'modules/policies/subclientPolicy/partials/editSCPolicyAssociation.jsp',
				backdrop: 'static',
				controller: 'editAssociationController',
				resolve: {
					associationParams: function() {
						return {
							associationArray: $scope.associationArray,
							subclientPolicyId: $scope.genericEntity.subclientPolicyId,
							subclientPolicyName: $scope.genericEntity.subclientPolicyName,
							dissociateBackupsets: $scope.dissociateBackupsets
						};
					}
				}
			});
		};

		function loadAssociationsListForTree() {
			if ($scope.associationArray) {
				$scope.model.associationsTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(
					$scope.associationArray,
					'summary',
					true
				);
			}
			$scope.associationsLoaded = true;
		}

		function fomratAssociationForTreeView() {
			if ($scope.associationArray) {
				$scope.associations = [];
				var clientGroupNodeHead = {
					label: cvLoc('heading.clientsGroup'),
					type: ENTITY_TYPES.ALL_CLIENT_GROUPS_ENTITY,
					children: [],
					hideCheckbox: true
				};
				var clientsNodeHead = {
					label: cvLoc('heading.Clients'),
					type: ENTITY_TYPES.ALL_CLIENT_COMPUTERS,
					children: [],
					hideCheckbox: true
				};

				$scope.associations.push(clientGroupNodeHead);
				$scope.associations.push(clientsNodeHead);

				$scope.associationArray.forEach(associationItem => {
					if (associationItem.clientGroupName) {
						clientGroupNodeHead.children.push({
							label: associationItem.clientGroupName,
							type: ENTITY_TYPES.CLIENT_GROUP_ENTITY,
							children: [],
							hideCheckbox: true
						});
					} else if (associationItem.backupsetName) {
						var index = getIndexForClientNode(associationItem.clientId);
						if (index == -1) {
							var node = {
								label: _.get(associationItem, 'displayName', associationItem.clientName),
								value: associationItem.clientId,
								type: ENTITY_TYPES.CLIENT_ENTITY,
								children: [],
								hideCheckbox: true
							};
							node.children.push({
								label: associationItem.backupsetName,
								value: associationItem.backupsetId,
								type: ENTITY_TYPES.BACKUPSET_ENTITY,
								children: [],
								hideCheckbox: true
							});
							clientsNodeHead.children.push(node);
						} else {
							clientsNodeHead.children[index].children.push({
								label: associationItem.backupsetName,
								value: associationItem.backupsetId,
								type: ENTITY_TYPES.BACKUPSET_ENTITY,
								children: [],
								hideCheckbox: true
							});
						}
					}
				});

				if (!clientsNodeHead.children.length) {
					$scope.associations.splice(1, 1);
				} else {
					clientsNodeHead.children = subclientPolicyFactory.sortAssociationNodes(clientsNodeHead.children);
					_.each(clientsNodeHead.children, clientNode => {
						clientNode.children = subclientPolicyFactory.sortAssociationNodes(clientNode.children);
					});
				}

				if (!clientGroupNodeHead.children.length) {
					$scope.associations.splice(0, 1);
				} else {
					clientGroupNodeHead.children = subclientPolicyFactory.sortAssociationNodes(clientGroupNodeHead.children);
				}
			}
			$scope.associationsLoaded = true;
		}

		function getIndexForClientNode(clientId) {
			var clientsNodeHead = _.find($scope.associations, { type: ENTITY_TYPES.ALL_CLIENT_COMPUTERS });
			var index = -1;
			if (clientsNodeHead) index = _.findIndex(clientsNodeHead.children, { value: clientId });
			return index;
		}

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'subclientList',
			showGridFooter: true,
			columnDefs: [
				{
					field: 'subClientEntity.subclientName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('column.name'),
					cellTemplate:
						'<a class="crop" href="#subclientDetails/{{row.entity.subClientEntity.subclientId}}">{{row.entity.subClientEntity.subclientName}}</a>',
					enableHiding: false
				},
				{
					field: 'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName',
					displayName: cvLoc('header.storagePolicy'),

					minWidth: 150,
					width: '25%',
					cellTemplate: ''
				},
				{
					field: 'action',
					displayName: cvLoc('header.actions'),
					cellTemplate:
						'<a class="crop" ng-if="!row.entity.commonProperties.isDefaultSubclient" data-ng-click="grid.appScope.deleteSubclient(row.entity.subClientEntity)">' +
						cvLoc('action.delete') +
						'</a>',
					width: '9%',
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false
				}
			]
		});
		$scope.allowSubclientCreation = true;
		$scope.gridOptions = {
			cvGridTitle: cvLoc('label.subclient'),
			cvIsPageTitle: false,
			cvPageLinks: [
				{
					label: cvLoc('action.add'),
					onclick: function() {
						subclientPolicyFactory.addNewSubclient(
							{
								idaEntity: { appName: 'File System', applicationId: $scope.genericEntity.applicatioId, backupsetId: 0 },
								isForSubclientPolicy: true
							},
							$scope.genericEntity.subclientPolicyId,
							$scope.genericEntity.subclientPolicyName
						);
					}
				}
			],
			cvTableName: 'subclientsForPolicyTable',
			cvCanSaveViews: false,
			cvHasColumnFilter: false,
			cvSearchFields: [
				'subClientEntity.subclientName',
				'commonProperties.storageDevice.dataBackupStoragePolicy.storagePolicyName'
			],
			gridOptions: globalGridOptions
		};

		$scope.deleteSubclient = function(subclientEntity) {
			var successCallBack = function() {
				cvToaster.showSuccessMessage({
					message: cvLoc('label.subclientDeletedSuccess')
				});
				for (var i = 0; i < $scope.subclientList.length; i++) {
					if ($scope.subclientList[i].subClientEntity.subclientName == subclientEntity.subclientName) {
						$scope.subclientList.splice(i, 1);
						return;
					}
				}
			};
			subclientFactory.deleteSubclient(subclientEntity, successCallBack);
		};

		$scope.deleteSubclientPolicy = function() {
			var subclientPolicyEntity = {
				subclientPolicyId: $scope.genericEntity.subclientPolicyId,
				subclientPolicyName: $scope.genericEntity.subclientPolicyName
			};
			subclientPolicyFactory.deleteSubclientPolicy(subclientPolicyEntity);
		};
	}
]);

export default app;
