import 'modules/policies/subclientPolicy/js/services/subclientPolicies.svc.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicy.factory.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicyAssociations.factory.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'adminConsole/js/factories/cvEntitySelectionTreeComponent.factory.js';

import { policyModule } from 'common/js/modules';

var editSPAssociationModule = policyModule;
editSPAssociationModule.controller('editAssociationController', [
	'$scope',
	'$uibModalInstance',
	'ENTITY_TYPES',
	'subclientPolicyFactory',
	'subclientPolicyService',
	'cvLoc',
	'$uibModal',
	'ivhTreeviewMgr',
	'cvUtil',
	'associationParams',
	'cvEntitySelectionTreeComponent',
	'subclientPolicyAssocFactory',
	function(
		$scope,
		$modalInstance,
		ENTITY_TYPES,
		subclientPolicyFactory,
		subclientPolicyService,
		cvLoc,
		$modal,
		ivhTreeviewMgr,
		cvUtil,
		associationParams,
		cvEntitySelectionTreeComponent,
		subclientPolicyAssocFactory
	) {
		$scope.associationArray = associationParams.associationArray != undefined ? associationParams.associationArray : [];
		$scope.selectedAssociations = [];
		$scope.associations = [];
		$scope.model = {};
		$scope.dissociateBackupsets = associationParams.dissociateBackupsets || false;

		$scope.filterTree = function(ivhTreeNode) {
			if ($scope.model.isShowOnlySelected) {
				if (ivhTreeNode.id === 0) {
					return true;
				}
				return (
					(ivhTreeNode.selected || ivhTreeNode.__ivhTreeviewIndeterminate) &&
					($scope.model.searchField
						? filterTreeBySearchInput($scope.associations, ivhTreeNode, $scope.model.searchField)
						: true)
				);
			} else {
				return $scope.model.searchField
					? filterTreeBySearchInput($scope.associations, ivhTreeNode, $scope.model.searchField)
					: true;
			}
		};

		function hasChildNodesMatched(childNodes, searchInput) {
			if (angular.isArray(childNodes)) {
				for (var i = 0, length = childNodes.length; i < length; i++) {
					if (hasNodeMatched(childNodes[i], searchInput) || hasChildNodesMatched(childNodes[i].children, searchInput))
						return true;
				}
			}
			return false;
		}

		function filterTreeBySearchInput(ivhTree, ivhTreeNode, searchInput) {
			if (searchInput && angular.isString(searchInput)) {
				if (ivhTreeNode.id != 0)
					if (hasChildNodesMatched(ivhTreeNode.children, searchInput)) {
						ivhTreeviewMgr.expand(ivhTree, ivhTreeNode);
					} else ivhTreeNode.__ivhTreeviewExpanded = false;
				return hasNodeMatched(ivhTreeNode, searchInput);
			}
			return false;
		}

		function hasNodeMatched(treeNode, searchInput) {
			return treeNode && treeNode.label && treeNode.label.toLowerCase().indexOf(searchInput.toLowerCase()) !== -1;
		}

		function isBackupSetAlreadyPopulated(node) {
			var backupSetNode = $scope.selectedAssociations.filter(function(obj) {
				return obj.backupsetId == node.backupsetId;
			});

			if (!backupSetNode.length) {
				return false;
			} else {
				return true;
			}
		}

		function saveSelectedNode(type, item) {
			if (type == ENTITY_TYPES.BACKUPSET_ENTITY) {
				$scope.selectedAssociations.push({
					backupsetId: item.value,
					clientId: item.clientId,
					applicationId: item.applicationId,
					entityTypeName: ENTITY_TYPES.BACKUPSET_ENTITY
				});
			} else if (type == ENTITY_TYPES.CLIENT_GROUP_ENTITY) {
				$scope.selectedAssociations.push({
					clientGroupId: item.value,
					entityTypeName: ENTITY_TYPES.CLIENT_GROUP_ENTITY,
					clientGroupName: item.clientGroupName
				});
			}
		}

		function getChildNodes(ivhNode) {
			var rootEntityType = ivhNode.type;
			subclientPolicyService
				.getSubclientPolicyAssociation(associationParams.subclientPolicyId, rootEntityType, ivhNode.value, '')
				.success(function(data) {
					if (ivhNode.type == ENTITY_TYPES.CLIENT_ENTITY && data.backupSets) {
						var isNodeSelectable = ivhNode.isChildSelectable || false;
						data.backupSets.forEach(backupSet => {
							if (!isNodeSelectable || !isBackupSetAlreadyPopulated(backupSet)) {
								ivhNode.children.push({
									label: backupSet.backupsetName,
									applicationId: backupSet.applicationId,
									clientId: backupSet.clientId,
									value: backupSet.backupsetId,
									type: ENTITY_TYPES.BACKUPSET_ENTITY,
									selected: false,
									children: [],
									isSelectable: isNodeSelectable
								});
							}
						}); //end of loop
						ivhNode.children = subclientPolicyFactory.sortAssociationNodes(ivhNode.children);
					} //end of if
					else if (data.clients) {
						data.clients.forEach(client => {
							ivhNode.children.push({
								label: client.clientName,
								value: client.clientId,
								type: ENTITY_TYPES.CLIENT_ENTITY,
								children: [{ value: cvLoc('Loading').toLocaleLowerCase() }],
								isSelectable: false,
								isChildSelectable: false
							});
						}); //end of loop
						ivhNode.children = subclientPolicyFactory.sortAssociationNodes(ivhNode.children);
					} //end of else if
				}); // end of service call
		}

		$scope.selectionChanged = function(ivhNode, ivhIsExpanded, ivhTree) {
			if (ivhNode.type == ENTITY_TYPES.BACKUPSET_ENTITY && ivhNode.selected == true) {
				$scope.selectedAssociations.push({
					backupsetId: ivhNode.value,
					clientId: ivhNode.clientId,
					applicationId: ivhNode.applicationId,
					entityTypeName: ENTITY_TYPES.BACKUPSET_ENTITY
				});
			} else if (ivhNode.type == ENTITY_TYPES.BACKUPSET_ENTITY && ivhNode.selected == false) {
				for (var i = 0; i < $scope.selectedAssociations.length; i++) {
					if ($scope.selectedAssociations[i].backupsetId == ivhNode.value) {
						$scope.selectedAssociations.splice(i, 1);
						return;
					}
				}
			}

			if (ivhNode.type == ENTITY_TYPES.CLIENT_GROUP_ENTITY && ivhNode.selected == true) {
				$scope.selectedAssociations.push({
					clientGroupId: ivhNode.value,
					entityTypeName: ENTITY_TYPES.CLIENT_GROUP_ENTITY,
					clientGroupName: ivhNode.label
				});
			} else if (ivhNode.type == ENTITY_TYPES.CLIENT_GROUP_ENTITY && ivhNode.selected == false) {
				for (var i = 0; i < $scope.selectedAssociations.length; i++) {
					if ($scope.selectedAssociations[i].clientGroupId == ivhNode.value) {
						$scope.selectedAssociations.splice(i, 1);
						return;
					}
				}
			}
		};

		$scope.populateChildren = function(ivhNode, ivhIsExpanded, ivhTree) {
			if (
				ivhNode.type != ENTITY_TYPES.BACKUPSET_ENTITY &&
				(ivhNode.children[0].value === cvLoc('Loading').toLocaleLowerCase() || ivhNode.partialExpanded)
			) {
				if (ivhNode.partialExpanded) {
					delete ivhNode.partialExpanded;
				} else {
					ivhNode.children = [];
				}
				getChildNodes(ivhNode);
			}
		};

		function loadSubClientAssociations(parent) {
			var entityType = _.get(parent, 'entity.entityTypeName');
			var entityValue = _.get(parent, 'entity.entityId');

			if (entityType === 'ALL_CLIENT_GROUPS_ENTITY' || entityType === 'ALL_CLIENTS') {
				return subclientPolicyService.getSubclientPolicyAssociation(
					associationParams.subclientPolicyId,
					ENTITY_TYPES.COMMCELL_ENTITY,
					2,
					''
				); //level one
			} else {
				return subclientPolicyService.getSubclientPolicyAssociation(
					associationParams.subclientPolicyId,
					entityType,
					entityValue,
					''
				); //child levels
			}
		}

		function loadAssociations() {
			$scope.associationsTreeParams = cvEntitySelectionTreeComponent.populateTreeParams(
				$scope.associationArray,
				'edit',
				true
			);

			$scope.associationsTreeParams.loadChildren = loadSubClientAssociations;
			$scope.associationsTreeParams.processChildren = subclientPolicyAssocFactory.processSubClientAssociations;
			$scope.associationsTreeParams.isSelectable = subclientPolicyAssocFactory.isSelectable;
		}

		function getTreeNodeById(headNodeType, type, id) {
			var filterNodes = [];
			var associationNode = getAssociationNodeByEntityType(headNodeType);
			if (associationNode) {
				filterNodes = associationNode.children.filter(function(obj) {
					return obj.value == id;
				});
			}
			return filterNodes[0] || undefined;
		}

		function preSelectAssociation() {
			$scope.associationArray.forEach(preSelectedItem => {
				var node = {};
				if (preSelectedItem.clientGroupName) {
					node = getTreeNodeById(
						ENTITY_TYPES.ALL_CLIENT_GROUPS_ENTITY,
						ENTITY_TYPES.CLIENT_GROUP_ENTITY,
						preSelectedItem.clientGroupId
					);
					if (node != undefined) {
						node.selected = true;
						saveSelectedNode(ENTITY_TYPES.CLIENT_GROUP_ENTITY, node);
					}
				} else if (preSelectedItem.clientId) {
					node = getTreeNodeById(
						ENTITY_TYPES.ALL_CLIENT_COMPUTERS,
						ENTITY_TYPES.CLIENT_ENTITY,
						preSelectedItem.clientId
					);
					if (node != undefined) {
						if (!node.partialExpanded) {
							node.partialExpanded = true;
							node.children = [];
						}
						var backupSetNode = {
							label: preSelectedItem.backupsetName,
							applicationId: preSelectedItem.applicationId,
							clientId: preSelectedItem.clientId,
							value: preSelectedItem.backupsetId,
							type: ENTITY_TYPES.BACKUPSET_ENTITY,
							selected: true,
							children: [],
							isSelectable: true
						};
						node.children.push(backupSetNode);
						saveSelectedNode(ENTITY_TYPES.BACKUPSET_ENTITY, backupSetNode);
					}
				}
			});
			$scope.associationsLoaded = true;
		}

		loadAssociations();

		$scope.saveAssociation = function() {
			$scope.selectedAssociations = cvEntitySelectionTreeComponent.getAssociations($scope.associationsTreeParams);
			subclientPolicyFactory.editAssociation(
				JSON.stringify($scope.selectedAssociations),
				associationParams.subclientPolicyId,
				associationParams.subclientPolicyName,
				$scope.dissociateBackupsets
			);
			$modalInstance.dismiss();
		};

		$scope.cancel = function() {
			$modalInstance.dismiss();
		};

		function getAssociationNodeByEntityType(entityType) {
			return _.find($scope.associations, { type: entityType });
		}
	}
]);

export default editSPAssociationModule;
