import 'modules/policies/subclientPolicy/js/services/subclientPolicies.svc.js';
import 'adminConsole/js/controllers/createSubclient.ctrl.js';
import 'adminConsole/js/controllers/activityControl.ctrl.js';
import 'storage/js/services/storage.svc.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicy.factory.js';
import 'modules/policies/subclientPolicy/js/factory/subclientPolicyAssociations.factory.js';
import 'adminConsole/js/factories/cvEntitySelectionTreeComponent.factory.js';

import { policyModule } from 'common/js/modules';

var createSubclientPolicyMod = policyModule;

var controllers = {};
controllers.createSubClientPolicyController = [
	'storageService',
	'ivhTreeviewMgr',
	'$scope',
	'$rootScope',
	'createSubclientFactory',
	'$state',
	'AppTypes',
	'SCPIdaType',
	'ENTITY_TYPES',
	'$http',
	'subclientPolicyService',
	'cvTableOptions',
	'cvLoc',
	'subclientPolicyFactory',
	'cvUtil',
	'$uibModal',
	'$log',
	'cvToaster',
	'cvEntitySelectionTreeComponent',
	'subclientPolicyAssocFactory',
	function(
		storageService,
		ivhTreeviewMgr,
		$scope,
		$rootScope,
		createSubclientFactory,
		$state,
		AppTypes,
		SCPIdaType,
		ENTITY_TYPES,
		$http,
		subclientPolicyService,
		cvTableOptions,
		cvLoc,
		subclientPolicyFactory,
		cvUtil,
		$modal,
		$log,
		cvToaster,
		cvEntitySelectionTreeComponent,
		subclientPolicyAssocFactory
	) {
		var self = this,
			scaIdaType;
		self.associationFilterConfig = {};
		self.policyData = {
			name: '',
			iDataAgent: undefined,
			dissociateBackupsets: false
		};
		self.accordionStatus = {
			subclients: false,
			associations: false
		};
		self.subclients = [];
		self.associations = [];
		self.storagePoliciesList = [];
		self.iDataAgentOptions = [
			{
				id: AppTypes.WINDOWS_FILESYSTEM,
				name: cvLoc('label.windowsFileSystem')
			},
			{
				id: AppTypes.APPTYPE_LINUX_FS,
				name: cvLoc('label.unixFileSystem')
			}
		];
		self.modal = {
			associationsTreeParams: {
				initialSelections: [],
				initialExclusions: [],
				result: {},
				mode: 'edit',
				loadChildren: loadSubClientAssociations,
				processChildren: subclientPolicyAssocFactory.processSubClientAssociations,
				isSelectable: subclientPolicyAssocFactory.isSelectable,
				enableSearch: false
			}
		};

		self.filterTree = function(ivhTreeNode) {
			if (self.associationFilterConfig.isShowOnlySelected) {
				if (ivhTreeNode.id === 0) {
					return true;
				}
				return (
					(ivhTreeNode.selected || ivhTreeNode.__ivhTreeviewIndeterminate) &&
					(self.associationFilterConfig.searchField
						? filterTreeBySearchInput(self.associations, ivhTreeNode, self.associationFilterConfig.searchField)
						: true)
				);
			} else {
				return self.associationFilterConfig.searchField
					? filterTreeBySearchInput(self.associations, ivhTreeNode, self.associationFilterConfig.searchField)
					: true;
			}
		};

		function hasChildNodesMatched(childNodes, searchInput) {
			if (angular.isArray(childNodes)) {
				childNodes.forEach(childNode => {
					if (hasNodeMatched(childNode, searchInput) || hasChildNodesMatched(childNode.children, searchInput))
						return true;
				});
			}
			return false;
		}

		function filterTreeBySearchInput(ivhTree, ivhTreeNode, searchInput) {
			if (searchInput && angular.isString(searchInput)) {
				if (ivhTreeNode.id != 0)
					if (hasChildNodesMatched(ivhTreeNode.children, searchInput)) {
						ivhTreeviewMgr.expand(ivhTree, ivhTreeNode);
					} else ivhTreeNode.__ivhTreeviewExpanded = false;
				return hasNodeMatched(ivhTreeNode, searchInput);
			}
			return false;
		}

		function hasNodeMatched(treeNode, searchInput) {
			return treeNode && treeNode.label && treeNode.label.toLowerCase().indexOf(searchInput.toLowerCase()) !== -1;
		}

		function getSelectedNodes(ivhTree) {
			var selected = [];
			if (ivhTree && ivhTree.length) {
				ivhTree.forEach(node => {
					if (node.selected || node.__ivhTreeviewIndeterminate) {
						if (node.selected && !node.__ivhTreeviewIndeterminate && node.isSelectable) {
							var selectedNode = {};
							if (node.type === ENTITY_TYPES.BACKUPSET_ENTITY)
								selected.push({
									backupsetId: node.value,
									clientId: node.clientId,
									applicationId: node.applicationId,
									entityTypeName: ENTITY_TYPES.BACKUPSET_ENTITY
								});
							else if (node.type === ENTITY_TYPES.CLIENT_GROUP_ENTITY)
								selected.push({
									clientGroupId: node.value,
									entityTypeName: ENTITY_TYPES.CLIENT_GROUP_ENTITY,
									clientGroupName: node.label
								});
						} else {
							Array.prototype.push.apply(selected, getSelectedNodes(node.children));
						}
					}
				});
			}
			return selected;
		}

		function getChildNodes(ivhNode) {
			var rootEntityType = ivhNode.type;
			subclientPolicyService
				.getSubclientPolicyAssociation(0, rootEntityType, ivhNode.value, scaIdaType)
				.success(function(data) {
					ivhNode.children = [];

					if (ivhNode.type == ENTITY_TYPES.CLIENT_ENTITY && data.backupSets) {
						var isNodeSelectable = ivhNode.isChildSelectable || false;
						data.backupSets.forEach(backupSet => {
							ivhNode.children.push({
								label: backupSet.backupsetName,
								applicationId: backupSet.applicationId,
								clientId: backupSet.clientId,
								value: backupSet.backupsetId,
								type: ENTITY_TYPES.BACKUPSET_ENTITY,
								selected: false,
								children: [],
								isSelectable: isNodeSelectable
							});
						}); //end of loop
					} //end of if
					else if (data.clients) {
						data.clients.forEach(client => {
							ivhNode.children.push({
								label: _.get(client, 'displayName', clientNameclient.clientName),
								value: client.clientId,
								type: ENTITY_TYPES.CLIENT_ENTITY,
								children: [{ value: cvLoc('Loading').toLocaleLowerCase() }],
								isSelectable: false,
								isChildSelectable: false
							});
						}); //end of loop
					} //end of else if

					ivhNode.children = subclientPolicyFactory.sortAssociationNodes(ivhNode.children);
				}); // end of service call
		}

		self.populateChildren = function(ivhNode, ivhIsExpanded, ivhTree) {
			if (
				ivhNode.type != ENTITY_TYPES.BACKUPSET_ENTITY &&
				ivhNode.children[0].value === cvLoc('Loading').toLocaleLowerCase()
			) {
				getChildNodes(ivhNode);
			}
		};

		function loadSubClientAssociations(parent) {
			if (self.policyData.iDataAgent.id == AppTypes.WINDOWS_FILESYSTEM) scaIdaType = SCPIdaType.WINDOWS;
			else scaIdaType = SCPIdaType.UNIX;

			var entityType = _.get(parent, 'entity.entityTypeName');
			var entityValue = _.get(parent, 'entity.entityId');

			if (entityType === 'ALL_CLIENT_GROUPS_ENTITY' || entityType === 'ALL_CLIENTS') {
				return subclientPolicyService.getSubclientPolicyAssociation(0, ENTITY_TYPES.COMMCELL_ENTITY, 2, scaIdaType); //level one
			} else {
				return subclientPolicyService.getSubclientPolicyAssociation(0, entityType, entityValue, scaIdaType); //child levels
			}
		}

		function loadAssociations() {
			if (self.policyData.iDataAgent.id == AppTypes.WINDOWS_FILESYSTEM) scaIdaType = SCPIdaType.WINDOWS;
			else scaIdaType = SCPIdaType.UNIX;

			subclientPolicyService
				.getSubclientPolicyAssociation(0, ENTITY_TYPES.COMMCELL_ENTITY, 2, scaIdaType)
				.success(function(data) {
					self.associations.push({
						label: cvLoc('heading.clientsGroup'),
						id: 0,
						type: ENTITY_TYPES.ALL_CLIENT_GROUPS_ENTITY,
						children: [],
						isSelectable: false,
						isChildSelectable: true
					});

					self.associations.push({
						label: cvLoc('heading.Clients'),
						id: 0,
						type: ENTITY_TYPES.ALL_CLIENT_COMPUTERS,
						children: [],
						isSelectable: false,
						isChildSelectable: false
					});

					if (data.clientGroups) {
						var clientGroupNodeHead = getAssociationNodeByEntityType(ENTITY_TYPES.ALL_CLIENT_GROUPS_ENTITY);
						data.clientGroups.forEach(associationItemCG => {
							clientGroupNodeHead.children.push({
								label: associationItemCG.clientGroupName,
								value: associationItemCG.clientGroupId,
								type: ENTITY_TYPES.CLIENT_GROUP_ENTITY,
								selected: false,
								isSelectable: true,
								children: [{ value: cvLoc('Loading').toLocaleLowerCase() }],
								isChildSelectable: false
							});
						});
						clientGroupNodeHead.children = subclientPolicyFactory.sortAssociationNodes(clientGroupNodeHead.children);
					}

					if (data.clients) {
						var clientsNodeHead = getAssociationNodeByEntityType(ENTITY_TYPES.ALL_CLIENT_COMPUTERS);
						data.clients.forEach(associationItemC => {
							clientsNodeHead.children.push({
								label: _.get(associationItemC, 'displayName', associationItemC.clientName),
								value: associationItemC.clientId,
								type: ENTITY_TYPES.CLIENT_ENTITY,
								children: [{ value: cvLoc('Loading').toLocaleLowerCase() }],
								isSelectable: false,
								isChildSelectable: true
							});
						});
						clientsNodeHead.children = subclientPolicyFactory.sortAssociationNodes(clientsNodeHead.children);
					}
				});
		}

		loadStoragePolicy();

		function loadStoragePolicy() {
			storageService
				.getStoragePoliciesList()
				.success(function(storagePolicies) {
					self.storagePoliciesList = storagePolicies;
				})
				.error(function(errorReason) {
					$log.error(errorReason);
					self.policyServerMessage = {
						message: cvLoc('generic_error'),
						type: 'error'
					};
				});
		}

		self.createSubclient = function() {
			addSubclient({
				idaEntity: {
					appName: cvLoc('FSServer'),
					applicationId: self.policyData.iDataAgent.id,
					backupsetId: 0
				},
				isForSubclientPolicy: true
			});
		};

		var isIDataAgentSelected = false;

		self.selectIDataAgent = function(iDataAgent) {
			if (isIDataAgentSelected == false) addDefaultSubclient();
			isIDataAgentSelected = true;
		};

		function addDefaultSubclient() {
			self.subclients = [];
			var contentPath = '';
			if (self.policyData.iDataAgent.id == AppTypes.APPTYPE_LINUX_FS) contentPath = '/';
			else contentPath = '\\';

			var defaultSubclient = {
				content: [[contentPath], [], []],
				planId: undefined,
				planName: undefined,
				subclientDetail: {
					backupSystemState: true,
					content: {
						contentEntities: [{ type: '0', path: contentPath }],
						ibmiContent: {
							customSubclientContentFlags: 0,
							customSubclientFlag: true
						},
						typeWiseCounterArray: [
							{
								counter: 1
							},
							{
								counter: 0
							},
							{
								counter: 0
							}
						]
					},
					storagePoliciesList: self.storagePoliciesList,
					storagePolicy: undefined,
					subclientName: 'default'
				},
				subclientEntity: {
					applicationId: self.policyData.iDataAgent.id,
					backupsetId: undefined,
					backupsetName: undefined,
					clientId: undefined,
					clientName: undefined,
					instanceId: undefined,
					instanceName: undefined,
					subclientName: 'default'
				},
				subclientInfo: {
					commonProperties: {
						description: undefined,
						enableBackup: undefined,
						isDefaultSubclient: true,
						storageDevice: {
							dataBackupStoragePolicy: {
								storagePolicyId: 0
							},
							logBackupStoragePolicy: {
								storagePolicyId: 0
							}
						}
					}
				}
			};
			self.subclients.push(defaultSubclient);
		}

		function hasStoragePolicyForDefaultSC() {
			if (
				self.subclients[0] &&
				self.subclients[0].subclientDetail.storagePolicy &&
				self.subclients[0].subclientDetail.storagePolicy.storagePolicyName
			) {
				return true;
			}
			return false;
		}

		/* GRID CONTSTRUCTION */
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'createSCPCtrl.subclients',
			showGridFooter: true,
			columnDefs: [
				{
					field: 'subclientEntity.subclientName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('column.name'),
					width: '25%',
					minWidth: 50,
					cellTemplate: ''
				},
				{
					field: 'subclientType',
					displayName: cvLoc('column.type'),
					width: '20%',
					cellTemplate:
						'<span class="crop" ng-if="row.entity.subclientInfo.commonProperties.isDefaultSubclient">' +
						cvLoc('label.default') +
						'</span><span class="crop" ng-if="!row.entity.subclientInfo.commonProperties.isDefaultSubclient">' +
						cvLoc('label.regular') +
						'</span>'
				},
				{
					field: 'subclientDetail.storagePolicy.storagePolicyName',
					displayName: cvLoc('column.storagePolicy'),
					width: '30%',
					cellTemplate:
						'<span class="form-panel-holder"><select class="select-with-border-below" data-ng-change="grid.appScope.createSCPCtrl.selectStoragePolicy(row.entity.subclientInfo.commonProperties, row.entity.subclientDetail.storagePolicy.storagePolicyId)"  data-ng-model="row.entity.subclientDetail.storagePolicy" data-ng-options="storagePolicy as storagePolicy.storagePolicyName for storagePolicy in row.entity.subclientDetail.storagePoliciesList" ><option value="" selected hidden>' +
						cvLoc('placeholder.selectStoragePolicy') +
						'</option></select></span>'
				},

				{
					name: 'action',
					displayName: cvLoc('header.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					width: '25%',
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.createSCPCtrl.editSubclient(row.entity)">' +
						cvLoc('action.edit') +
						'</a></li><li><a href="" ng-if="!row.entity.subclientInfo.commonProperties.isDefaultSubclient" class="ui-grid-action-items" ng-click="grid.appScope.createSCPCtrl.deleteSubclient(row.entity.subclientEntity.subclientName)">' +
						cvLoc('action.delete') +
						'</a></li></ul></div>'
				}
			]
		});

		self.selectStoragePolicy = function(scCommonProperties, storagePolicyId) {
			if (
				scCommonProperties &&
				scCommonProperties.storageDevice &&
				scCommonProperties.storageDevice.dataBackupStoragePolicy
			) {
				var dataBackupStoragePolicy = scCommonProperties.storageDevice.dataBackupStoragePolicy;
				dataBackupStoragePolicy.storagePolicyId = storagePolicyId;
				// Remove validation message if default subclient has storage policy
				if (hasStoragePolicyForDefaultSC()) {
					self.inputAlertFlags.storagePolicyForDefault = false;
				}
			}
		};

		self.deleteSubclient = function(subclientName) {
			for (var i = 0; i < self.subclients.length; i++) {
				if (self.subclients[i].subclientEntity.subclientName == subclientName) {
					self.subclients.splice(i, 1);
					return;
				}
			}
		};

		self.editSubclient = function(subclientInfo) {
			var subclientName = subclientInfo.subclientEntity.subclientName,
				params = {
					idaEntity: {
						appName: cvLoc('FSServer'),
						applicationId: self.policyData.iDataAgent.id,
						backupsetId: 0
					},
					subclientDetail: angular.copy(subclientInfo),
					isForSubclientPolicy: true
				};

			var jspFileRelativePath = 'adminConsole/partials/createFsSubclient.jsp',
				controllerName = 'createSubclientController',
				inputParamsToController = function() {
					return params;
				};

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + jspFileRelativePath,
				controller: controllerName,
				backdrop: 'static',
				resolve: {
					createSubclientParams: inputParamsToController
				}
			});
			modalInstance.result.then(
				function(result) {
					if (!result) return;
					result.oldSubclient = subclientName;
					self.subclients.forEach((subclient, index) => {
						if (subclient.subclientEntity.subclientName == result.oldSubclient) {
							delete result.oldSubclient;
							self.subclients[index] = result;
							return;
						}
					});
					// Remove validation message if default subclient has storage policy
					if (hasStoragePolicyForDefaultSC()) {
						self.inputAlertFlags.storagePolicyForDefault = false;
					}
				},
				function() {}
			);
		};

		self.gridOptions = {
			cvTableName: 'subclientsForPolicyTable',
			cvOnGridEmpty: {
				message: cvLoc('label.noSubclient')
			},
			cvHasColumnFilter: false,
			cvCanSaveViews: false,
			cvIsSearchable: false,
			gridOptions: globalGridOptions
		};

		self.inputAlertFlags = {
			subclientPolicyName: false,
			iDataAgent: false,
			storagePolicyForDefault: false
		};

		self.createPolicy = function() {
			if (self.policyData.name == '' || !self.policyData.iDataAgent || !hasStoragePolicyForDefaultSC()) {
				if (self.policyData.name == '') self.inputAlertFlags.subclientPolicyName = true;
				if (!self.policyData.iDataAgent) self.inputAlertFlags.iDataAgent = true;
				if (self.subclients[0] && !hasStoragePolicyForDefaultSC()) {
					self.inputAlertFlags.storagePolicyForDefault = true;
					self.accordionStatus.subclients = true;
				}
				return;
			}

			var selectedAssociation = [];
			var selectedNodes = _.get(self, 'modal.associationsTreeParams.result.selected', []),
				excludedNodes = _.get(self, 'modal.associationsTreeParams.result.excluded', []);
			selectedNodes.forEach(function(selectedNode) {
				return selectedAssociation.push(selectedNode.entity);
			});
			excludedNodes.forEach(function(excludedNode) {
				_.set(excludedNode, 'entity.flags.exclude', true);
				selectedAssociation.push(excludedNode.entity);
			});
			subclientPolicyService
				.createSubclientPolicy(
					self.policyData.name,
					self.policyData.iDataAgent.id,
					JSON.stringify(self.subclients),
					JSON.stringify(selectedAssociation),
					self.policyData.dissociateBackupsets
				)
				.success(function(data) {
					cvToaster.showSuccessMessage({
						message: cvLoc('label.subclientPolicyCreated')
					});
					$state.reload();
					$scope.close();
				})
				.error(function(errorMessage) {
					if (errorMessage != null) {
						$log.error(errorMessage);
						//TODO. is it advisable to show this error message?? Please change this later.
						self.policyServerMessage = {
							message: errorMessage,
							type: 'error'
						};
					} else {
						self.policyServerMessage = {
							message: cvLoc('generic_error'),
							type: 'error'
						};
					}
				});
		};

		function addSubclient(params) {
			//ApplicationId must be present in the params.
			if (
				params == undefined ||
				params.idaEntity == undefined ||
				params.idaEntity.applicationId == undefined ||
				params.idaEntity.applicationId < 1
			) {
				$log.error('createSubclient:Invalid inputs for subclient creation');
				cvToaster.showErrorMessage({
					ttl: '5000',
					message: cvLoc('generic_error')
				});
				return;
			}

			var jspFileRelativePath = 'adminConsole/partials/createFsSubclient.jsp',
				controllerName = 'createSubclientController',
				inputParamsToController = function() {
					return params;
				};

			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + jspFileRelativePath,
				controller: controllerName,
				backdrop: 'static',
				resolve: {
					createSubclientParams: inputParamsToController
				}
			});
			modalInstance.result.then(
				function(result) {
					self.subclients.push(result);
				},
				function() {}
			);
		}

		function getAssociationNodeByEntityType(entityType) {
			return _.find(self.associations, { type: entityType });
		}
	}
];
createSubclientPolicyMod.controller(controllers);
export default createSubclientPolicyMod;
