<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<span data-ng-if="::spdCtrl.schedulePolicyDetails"><cv-changename obj='spdCtrl.changeNameObj' service-method="renameSchedulePolicy.do" class="float-left"></cv-changename></span>
		<span class="server-message" data-ng-class="spdCtrl.serverMessage.type" data-ng-bind="spdCtrl.serverMessage.message" ></span>
		<span data-ng-if="::spdCtrl.schedulePolicyDetails" data-ng-click="spdCtrl.deleteSchedulePolicy()"><a class="page-action-item" ><cv:msg key="label.delete" bundle="alerts" /></a></span>
	</div>
</div>
<div class="row" data-ng-if="::spdCtrl.schedulePolicyDetails">
	<div class="col-md-6">
		<cv-tile-component data-title='<cv:msg key="label.general" bundle="profiles"/>' loader="::spdCtrl.schedulePolicyDetails">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="gridHeader.type" bundle="alertsJs" /></span>
					<span class="pageDetailColumn" data-ng-bind="::spdCtrl.schedulePolicyDetails | scheduleType"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.associatedObjects" bundle="schedule" /></span>
					<span class="pageDetailColumn" data-ng-bind="::spdCtrl.schedulePolicyDetails.task.associatedObjects"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.enabled" bundle="users" /></span>
					<span class="pageDetailColumn">
						<toggle-control
							status="spdCtrl.model.status?'disabled-activity':'enabled-activity'"
							data-ng-click="spdCtrl.toggleSchedulePolicyStatus()" >
						</toggle-control>
					</span>
				</li>
				<li class="group" data-ng-if="spdCtrl.isAgentTypeSupported()">
					<span class="pageDetailColumn"><cv:msg key="agentType" bundle="job" /></span>
					<span class="pageDetailColumn" data-uib-tooltip="{{::spdCtrl.schedulePolicyDetails | showAllAgentsAsString}}">
						<label data-ng-bind="::spdCtrl.schedulePolicyDetails | schedulePolicyAgentType" ></label>						
						<a class="edit-link-float-right"
							data-ng-click="spdCtrl.editAgentType()"
							title='<cv:msg key="label.edit" bundle="clients" />'>
								<cv:msg key="label.edit" bundle="clients" />
						</a>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<cv-security-component entity-type="::spdCtrl.model.entityType" generic-entity="::spdCtrl.model.genericEntity"
				associations="::spdCtrl.model.formattedSecurityAssociations" associations-loaded="::spdCtrl.model.formattedSecurityAssociations">
		</cv-security-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component  data-title='<cv:msg key="label.associations" bundle="users"/>' loader="::spdCtrl.schedulePolicyDetails" data-min-height="true">
			<span  data-ng-click="spdCtrl.editAssociation()"><a class="page-details-box-links ng-scope" href=""><cv:msg key="label.edit" bundle="alerts"/></a></span>
			<p data-ng-if='!spdCtrl.schedulePolicyDetails.associations.length' class="info-place-holder center"><cv:msg  key="label.noAssociationsDefined" bundle="collections"/></p>
			
			<div data-ng-if="spdCtrl.policyType=='DATA_VERIFICATION' && spdCtrl.schedulePolicyDetails.associations.length > 0">
				<div class="margin-bottom-10">&nbsp;</div>
				<cv-entity-selection-tree-component
					data-tree-options="spdCtrl.model.ddbAssociationsTreeParams">
				</cv-entity-selection-tree-component>
			</div>
			<div data-ng-if="spdCtrl.isEntitySelectionTreeVisible()">
				<div class="margin-bottom-10">&nbsp;</div>
				<cv-entity-selection-tree-component
					data-tree-options="spdCtrl.model.associationsTreeParams">
				</cv-entity-selection-tree-component>
			</div>
			<div data-ng-if="spdCtrl.isStoragePolicySelectionTreeVisible()" >
				<div class="margin-bottom-10">&nbsp;</div>
				<cv-storage-policy-selection-tree-component
					data-tree-options="spdCtrl.model.associationsTreeParams">
				</cv-storage-policy-selection-tree-component>
			</div>
		</cv-tile-component>
	</div>
</div>
<cv-grid data-ng-if="::spdCtrl.gridOptions" data-cv-grid-options="::spdCtrl.gridOptions"></cv-grid>
