<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="panel">
	<div class="panel-body">
		<h4 class="modal-underline"><cv:msg key="label.dataVerificationOptions" bundle="schedule"/></h4>
		<div class="schedule-select-group setup-content">
			<div class="global-options remove-border-padding">
				<label for="mediaAgent"><cv:msg key="label.sourceMediaAgent" bundle="schedule"/>
				 	<select id="mediaAgent" name="mediaAgent" data-ng-model="astpCtrl.scheduleModel.mediaAgentId"
						data-ng-options="agent.id as agent.displayName for agent in astpCtrl.model.mediaAgentList" >
						<option value=""><cv:msg key="placeholder.anyMediaAgent" bundle="schedule"/></option>
					</select>
				</label>
			</div>
		</div>
		<div class="form-group"> <!-- RUN INCREMENTAL VERIFICATION -->
		    <div class="col-sm-12">
		        <input type="checkbox" id="runIncrementalVerification" name="runIncrementalVerification" data-ng-model="astpCtrl.scheduleModel.runIncrementalVerification" data-ng-change="astpCtrl.scheduleModel.deduplicationLevel = 'DDB_VERIFICATION'">
		    	<label for="runIncrementalVerification"><cv:msg key="label.runIncrementalVerification" bundle="schedule"/></label>
		    </div>
		</div>
		<div class="form-group">			
		<!-- VERIFICATION OF DEDUPLICATION DATABASE -->
		    <div class="col-sm-12">
		        <input type="radio" data-ng-value="'DDB_VERIFICATION'" id="verifyDDB" name="DDBOptions" data-ng-model="astpCtrl.scheduleModel.deduplicationLevel">
		    	<label for="verifyDDB"><cv:msg key="label.verifyDDB" bundle="schedule"/></label>
		    </div>
		<!-- QUICK VERIFICATION OF DEDUPLICATION DATABASE -->
		    <div class="col-sm-12" data-ng-disabled="astpCtrl.scheduleModel.runIncrementalVerification">
		        <input type="radio" data-ng-value="'QUICK_DDB_VERIFICATION'" id="quickVerifyDDB" name="DDBOptions" data-ng-model="astpCtrl.scheduleModel.deduplicationLevel">
		    	<label for="quickVerifyDDB"><cv:msg key="label.quickVerifyDDB" bundle="schedule"/></label>
		    </div>
		 <!-- VERIFICATION OF EXISTING JOBS AND DEDUPLICATION DATABASE -->
		    <div class="col-sm-12">
		        <input type="radio" data-ng-value="'DDB_AND_DATA_VERIFICATION'" id="verifyJobsAndDDB" name="DDBOptions" data-ng-model="astpCtrl.scheduleModel.deduplicationLevel">
		    	<label for="verifyJobsAndDDB"><cv:msg key="label.verifyJobsAndDDB" bundle="schedule"/></label>
		    </div>
		<!-- RECLAIM IDLE SPACE ON MOUNTPATH WITH NO DRILL HOLE CAPABILITY -->
		    <div class="col-sm-12" data-ng-disabled="astpCtrl.scheduleModel.runIncrementalVerification">
		        <input type="radio" data-ng-value="'DDB_DEFRAGMENTATION'" id="reclaimSpace" name="DDBOptions" data-ng-model="astpCtrl.scheduleModel.deduplicationLevel">
		    	<label for="reclaimSpace"><cv:msg key="label.reclaimSpace" bundle="schedule"/></label>
		    </div>
		    <div class="col-sm-offset-5 col-sm-7" data-ng-disabled="astpCtrl.scheduleModel.deduplicationLevel != 'DDB_DEFRAGMENTATION'">
		    	<label for="reclaimLevel"><cv:msg key="label.reclaimLevel" bundle="schedule"/></label>
				<input type="number" id="reclaimLevel" name="reclaimLevel" min="1" max="4" required
								data-ng-model="astpCtrl.scheduleModel.reclaimLevel">
		    </div>
		    <div class="col-sm-12">
		    	<label><cv:msg key="label.reclaimSpaceNote" bundle="schedule" /></label>
		    </div>
		</div>
		<div class="form-group">
			<div class="col-sm-5">
				<label><cv:msg key="label.noOfStreams" bundle="schedule" /></label>
			</div>
			<div class="col-sm-7">
				<input type="radio" id="noOfStreams" name="noOfStreams" data-ng-value="false" data-ng-model="astpCtrl.scheduleModel.useMaximumStreams">
				<label for="noOfStreams"><cv:msg key="label.noOfStreams" bundle="oracle"/></label>
				<input type="number" id="streams" name="streams" min="1" max="1000" required
								data-ng-model="astpCtrl.scheduleModel.maxNumberOfStreams">
			</div>
			<div class="col-sm-offset-5 col-sm-7">
				<input type="radio" id="allowMaximum" name="allowMaximum" data-ng-value="true" data-ng-model="astpCtrl.scheduleModel.useMaximumStreams">
				<label for="allowMaximum"><cv:msg key="label.allowMaximum" bundle="schedule" /></label>
			</div>
		</div>
	</div>
</div>