<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.addSchedulePolicy" bundle="schedule" /></h1>
</div>
<form name="addSchedulePolicyForm" data-cv-submit="aspCtrl.saveSchedulePolicy()" novalidate autocomplete="off">
	<div class="bootstrap-wrapper">
		<div class="text-center {{aspCtrl.model.serverMessage.type}}" data-ng-if="aspCtrl.model.serverMessage.message"
				data-ng-bind="aspCtrl.model.serverMessage.message"></div><br>
		<div class="panel-body">
			<div class="form-group row">
				<div class="col-sm-4">
					<label for="policyName"><cv:msg key="gridHeader.name" bundle="alertsJs"/></label>
				</div>
				<div class="col-sm-8">
						<input type="text" data-ng-model="aspCtrl.model.task.taskName" id="policyName" name="policyName"
								autofocus novalidate data-ng-change="aspCtrl.clearErrorMessage()" />
					</div>
				</div>
			<div class="form-group row">
				<div class="col-sm-4">
					<label for="policyType"><cv:msg key="gridHeader.type" bundle="alertsJs"/></label>
				</div>
				<div class="col-sm-8">
						<select id="policyType" name="policyType"
							data-ng-model="aspCtrl.model.task.policyType"
							data-ng-options="type.value as type.label for type in aspCtrl.model.schedulePolicyTypes"
							data-ng-change="aspCtrl.clearErrorMessage(); aspCtrl.updateAssociationsTreeForPolicyType()">
							<option value=""><cv:msg key="label.selectAType"
									bundle="alerts" /></option>
						</select>
					</div>
				</div>
			<div class="form-group row" data-ng-show="aspCtrl.isDataProtectionSelected()">
				<div class="col-sm-4">
					<label for="SchedulePolicyAgents"><cv:msg key="agentType" bundle="job" /></label>
				</div>
				<div class="col-sm-8">
						<cv-agent-dropdown-tree
							id="SchedulePolicyAgents"
							name="SchedulePolicyAgents"
							placeholder='<cv:msg key="label.selectAgent" bundle="schedule" />'
							tree-container="aspCtrl.model.agentTypeTree"
							expand-to-depth="2"
							dropdown-width="350px"
							on-selection="aspCtrl.clearErrorMessage">
						</cv-agent-dropdown-tree>
					</div>
				</div>
		</div>
		<div class="margin-bottom-10">&nbsp;</div>
		<uib-accordion class="overflow-visible" close-others="true">
			<div uib-accordion-group is-open="aspCtrl.model.accordionStatus.schedulesTab" data-scroll-to-when-open>
				<uib-accordion-heading><cv:msg key="header.schedules" bundle="schedule" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': aspCtrl.model.accordionStatus.schedulesTab, 'glyphicon-chevron-right': !aspCtrl.model.accordionStatus.schedulesTab}"></i>
					<a class="pull-right accordion-heading-action-link margin-right-15" title="<cv:msg key="Add" bundle="messages" />" data-ng-click="aspCtrl.addSchedule()">
					<cv:msg key="Add" bundle="messages" />
				</a>
				</uib-accordion-heading>
				<div data-ng-if="aspCtrl.model.schedules.length == 0">
					<label class="inheritedSecurityAssociation "><cv:msg key="error.noScheduleAdded" bundle="schedule"/></label>
				</div>
				<div data-ng-if="aspCtrl.model.schedules.length != 0">
					<div data-ng-repeat="schedule in aspCtrl.model.schedules track by $index">
						<label><a data-ng-click="aspCtrl.editSchedule(schedule)" data-ng-bind="schedule | associatedScheduleName"></a></label>
						<span class="delete-row"><a data-ng-click="aspCtrl.deleteSchedulePattern($index)">&times;</a></span>
					</div>
				</div>
			</div>
			<div uib-accordion-group is-open="aspCtrl.model.accordionStatus.associationsTab" data-scroll-to-when-open>
				<uib-accordion-heading><cv:msg key="label.associations" bundle="users" /><i class="pull-right glyphicon"
					data-ng-class="{'glyphicon-chevron-down': aspCtrl.model.accordionStatus.associationsTab, 'glyphicon-chevron-right': !aspCtrl.model.accordionStatus.associationsTab}"></i>
				</uib-accordion-heading>
				<cv-entity-selection-tree-component
					id="DDBSchedulePolicyEntities"
					data-ng-if="aspCtrl.isDataVerificationSelected()"
					data-tree-options="aspCtrl.model.ddbAssociationsTreeParams">
				</cv-entity-selection-tree-component>
					<cv-entity-selection-tree-component
						id="SchedulePolicyEntities"
						data-ng-if="aspCtrl.isDataProtectionSelected()"
						data-tree-options="aspCtrl.model.associationsTreeParams">
					</cv-entity-selection-tree-component>
					<!-- Tree component for 'Aux copy'	-->
					<cv-storage-policy-selection-tree-component
							data-ng-if="aspCtrl.isAuxCopySelected()"
							data-tree-options="aspCtrl.model.associationsTreeParams">
					</cv-storage-policy-selection-tree-component>
					<!-- Tree component for 'Backup copy' and 'Offline Content Indexing'	-->
					<cv-storage-policy-selection-tree-component
							data-ng-if="aspCtrl.isStoragePolicySupported()"
							data-tree-options="aspCtrl.model.associationsTreeParams">
					</cv-storage-policy-selection-tree-component>
					<cv-entity-selection-tree-component
						id="SchedulePolicyEntities"
						data-ng-if="aspCtrl.isContentIndexingSelected()"
						data-tree-options="aspCtrl.model.associationsTreeParams">
					</cv-entity-selection-tree-component>
			</div>
			<div class="margin-bottom-10">&nbsp;</div>
		</uib-accordion>
		<div class="modal-footer">
			<button id="addSchedulePolicy_button_#4705" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="aspCtrl.close()"><cv:msg key="Cancel" bundle="messages" /></button>
			<button id="addSchedulePolicy_button_#7340" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" bundle="messages" /></button>
		</div>
		</div>
</form>
