import { policyModule } from 'common/js/modules';

policyModule.service('schedulePolicyService', [
	'$http',
	function($http) {
		this.loadSchedulePolicies = function() {
			return $http.get('loadSchedulePolicies.do');
		};

		this.loadAssociatedSchedules = function(taskId) {
			return $http.get('loadAssociatedSchedules.do?taskId=' + taskId);
		};

		this.deleteSchedulePolicy = function(taskId) {
			return $http.post('deleteSchedulePolicy.do', { taskId: taskId });
		};

		this.deleteAssociatedSchedule = function(taskId, subTaskId) {
			// To delete a schedule associated to a policy
			return $http.post('deleteAssociatedSchedule.do', { taskId: taskId, subTaskId: subTaskId });
		};

		this.addSchedulePolicy = function(params) {
			return $http.post('addSchedulePolicy.do', params);
		};

		this.updateAgentTypeForSchedulePolicy = function(params) {
			return $http.post('updateAgentTypeForSchedulePolicy.do', params);
		};

		this.toggleStatus = function(params) {
			return $http.post('toggleSchedulePolicyStatus.do', params);
		};

		this.addScheduleToPolicy = function(params) {
			return $http.post('addScheduleToPolicy.do', params);
		};

		this.editAssociatedSchedule = function(params) {
			return $http.post('editAssociatedSchedule.do', params);
		};

		this.runSchedule = function(subTaskId, subTaskName, taskId, taskName) {
			return $http.post('runSchedule.do', {
				subTaskId: subTaskId,
				subTaskName: subTaskName || '',
				taskId: taskId,
				taskName: taskName
			});
		};

		this.getStoragePoliciesList = function() {
			return $http({
				method: 'GET',
				url: 'getStoragePoliciesList.do',
				cache: true
			});
		};

		this.saveAssociations = function(taskInfo) {
			return $http.post('saveAssociations.do', { taskInfo: angular.toJson(taskInfo) });
		};

		this.getStoragePolicySelectionTree = function() {
			return $http.get('getStoragePolicySelectionTree.do');
		};

		this.populateStoragePolicyTree = function(inputParams) {
			var url = 'populateStoragePolicyTree.do?entityType=' + inputParams.entityTypeName;

			if (inputParams.storagePolicyId) {
				url += '&storagePolicyId=' + inputParams.storagePolicyId;
			}

			return $http({
				method: 'GET',
				url: url,
				cache: true
			});
		};

		this.saveSubClientAssociations = function(taskInfo) {
			return $http.post('saveSubClientAssociations.do', { taskInfo: angular.toJson(taskInfo) });
		};

		this.getDDBEngines = function(storagePolicyId, storagePolicyCopyId) {
			return $http.get(
				'getDeduplicationEngines.do?StoragePolicyId=' + storagePolicyId + '&StoragePolicyCopyId=' + storagePolicyCopyId
			);
		};

		this.performMultipleOperations = function(taskIds, opType) {
			return $http.post('performMultipleOperations.do', {
				taskIds: JSON.stringify(taskIds),
				opType: opType
			});
		};

		this.getTaskOperationTypes = function() {
			return $http({
				method: 'GET',
				url: 'getSubTaskTypes.do',
				cache: true
			});
		};

		this.loadScheduleDetails = function(taskId, subTaskId) {
			return $http({
				method: 'GET',
				url: 'loadScheduleDetails.do?taskId=' + taskId + '&subTaskId=' + subTaskId
			});
		};

		this.getMemberServers = function() {
			return $http.get('getMemberServers.do');
		};

		// To delete an individual schedule from 'Schedule details' page
		this.deleteSchedule = function(taskId) {
			return $http.post('deleteIndividualSchedule.do', { taskId: taskId });
		};
	}
]);

export default policyModule;
