import { policyModule } from 'common/js/modules';
var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('showScheduleOrPolicyName', [
	'cvLoc',
	function(cvLoc) {
		return function(taskDetail) {
			var name;
			if (taskDetail.task.taskType == 'SCHEDULE') {
				taskDetail.isIndividualSchedule = true;
				name = _.get(taskDetail, 'subTasks[0].subTask.subTaskName', '');
				if (!name) {
					name = '(' + cvLoc('label.unnamedSchedule') + ')';
				}
				return name;
			} else if (taskDetail.task.taskType == 'SCHEDULE_POLICY') {
				return taskDetail.task.taskName;
			} else {
				return '';
			}
		};
	}
]);

export default schedulePolicyMod;
