import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyType.factory.js';

import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('scheduleType', [
	'schedulePolicyType',
	'schedulePolicyFactory',
	function(schedulePolicyType, schedulePolicyFactory) {
		return function(taskDetail) {
			if (taskDetail.task.taskType == 'SCHEDULE') {
				if (angular.isDefined(schedulePolicyFactory.scheduleTypesMap)) {
					return schedulePolicyFactory.scheduleTypesMap[_.get(taskDetail, 'subTasks[0].subTask.operationType', '')];
				}
				return '';
			} else if (taskDetail.task.taskType == 'SCHEDULE_POLICY') {
				return schedulePolicyType[taskDetail.task.policyType];
			} else {
				return '';
			}
		};
	}
]);

export default schedulePolicyMod;
