import 'adminConsole/js/services/clientGroups.svc.js';
import 'adminConsole/js/services/clients.svc.js';

import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('associationsList', [
	'clientGroupService',
	'clientService',
	function(clientGroupService, clientService) {
		return function(schedulePolicyType, associations) {
			var associationsList = [];
			if (schedulePolicyType == 'DATA_PROTECTION') {
				var clientComputerGroupsList = [],
					clientComputersList = [];

				for (var i = 0; i < associations.length; i++) {
					if (associations[i].entityTypeName == 'ALL_CLIENT_GROUPS_ENTITY') {
						// In case of ALL_CLIENT_GROUPS_ENTITY is present, loading of client computer groups list is required
						var exclusionsList = []; // To handle exclusions
						for (var j = 0; j < associations.length; j++) {
							if (associations[j].entityTypeName == 'CLIENT_GROUP_ENTITY' && associations[j].flags.exclude == true) {
								exclusionsList.push(associations[j].clientGroupId);
							}
						}
						clientGroupService.getClientGroups().success(function(clientGroupsList) {
							for (var j = 0; j < clientGroupsList.length; j++) {
								if (!exclusionsList.includes(clientGroupsList[j].Id)) {
									clientComputerGroupsList.push(clientGroupsList[j].name);
								}
							}
						});
					} else if (associations[i].entityTypeName == 'ALL_CLIENTS') {
						// In case of ALL_CLIENTS is present, loading of client computers list is required
						var exclusionsList = []; // To handle exclusions
						for (var j = 0; j < associations.length; j++) {
							if (associations[j].entityTypeName == 'CLIENT_ENTITY' && associations[j].flags.exclude == true) {
								exclusionsList.push(associations[j].clientGroupId);
							}
						}
						clientService.getClientNames().success(function(clientsList) {
							for (var j = 0; j < clientsList.length; j++) {
								if (!exclusionsList.includes(clientsList[j].Id)) {
									clientComputerGroupsList.push(clientsList[j].name);
								}
							}
						});
					} else if (associations[i].entityTypeName == 'SUBCLIENT_ENTITY' && !associations[i].flags.exclude) {
						if (!associations[i].clientGroupName) {
							clientComputersList.push(
								associations[i].clientName +
									' > ' +
									associations[i].appName +
									' > ' +
									associations[i].instanceName +
									' > ' +
									associations[i].subclientName
							);
						} else {
							clientComputerGroupsList.push(
								associations[i].clientGroupName +
									' > ' +
									associations[i].clientName +
									' > ' +
									associations[i].appName +
									' > ' +
									associations[i].backupsetName +
									' > ' +
									associations[i].subclientName
							);
						}
					} else if (associations[i].entityTypeName == 'BACKUPSET_ENTITY' && !associations[i].flags.exclude) {
						if (!associations[i].clientGroupName) {
							clientComputersList.push(
								associations[i].clientGroupName +
									' > ' +
									associations[i].clientName +
									' > ' +
									associations[i].appName +
									' > ' +
									associations[i].backupsetName
							);
						} else {
							clientComputerGroupsList.push(
								associations[i].clientGroupName +
									' > ' +
									associations[i].clientName +
									' > ' +
									associations[i].appName +
									' > ' +
									associations[i].backupsetName
							);
						}
					} else if (associations[i].entityTypeName == 'INSTANCE_ENTITY' && !associations[i].flags.exclude) {
						if (!associations[i].clientGroupName) {
							clientComputersList.push(
								associations[i].clientName + ' > ' + associations[i].appName + ' > ' + associations[i].instanceName
							);
						} else {
							clientComputerGroupsList.push(
								associations[i].clientGroupName +
									' > ' +
									associations[i].clientName +
									' > ' +
									associations[i].appName +
									' > ' +
									associations[i].instanceName
							);
						}
					} else if (associations[i].entityTypeName == 'APPTYPE_ENTITY' && !associations[i].flags.exclude) {
						if (!associations[i].clientGroupName) {
							clientComputersList.push(associations[i].clientName + ' > ' + associations[i].appName);
						} else {
							clientComputerGroupsList.push(
								associations[i].clientGroupName + ' > ' + associations[i].clientName + ' > ' + associations[i].appName
							);
						}
					} else if (associations[i].entityTypeName == 'CLIENT_ENTITY' && !associations[i].flags.exclude) {
						if (!associations[i].clientGroupName) {
							clientComputersList.push(associations[i].clientName);
						} else {
							clientComputerGroupsList.push(associations[i].clientGroupName + ' > ' + associations[i].clientName);
						}
					} else if (associations[i].entityTypeName == 'CLIENT_GROUP_ENTITY' && !associations[i].flags.exclude) {
						clientComputerGroupsList.push(associations[i].clientGroupName);
					}
				}

				clientComputersList.sort();
				clientComputerGroupsList.sort();
				associationsList.push(clientComputerGroupsList);
				associationsList.push(clientComputersList);
			}

			//For schedule policy types Auxiliary copy,	Backup copy and Offline content indexing
			else if (
				schedulePolicyType == 'AUX_COPY' ||
				schedulePolicyType == 'SINGLE_INSTANCING' ||
				schedulePolicyType == 'CONTENT_INDEX'
			) {
				for (var i = 0; i < associations.length; i++) {
					associationsList.push(associations[i].storagePolicyName);
				}
				associationsList.sort();
			} else if (schedulePolicyType == 'DATA_VERIFICATION') {
				for (var i = 0; i < associations.length; i++) {
					//TODO : Load deduplication engines list
				}
			}
			return associationsList;
		};
	}
]);

export default schedulePolicyMod;
