import { policyModule } from 'common/js/modules';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyDetails.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyType.factory.js';
import 'adminConsole/js/controllers/clientGroups.ctrl.js';
import 'common/js/tableOptions.js';
import 'common/js/common.js';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('schedulePolicyAgentType', [
	'cvLoc',
	'smartClientGroupFactory',
	function(cvLoc, smartClientGroupFactory) {
		return function(taskDetail) {
			if (taskDetail.task.policyType === 'DATA_PROTECTION' && taskDetail.task.taskType == 'SCHEDULE_POLICY') {
				if (!taskDetail.appGroup.hasOwnProperty('appGroups') && !taskDetail.appGroup.hasOwnProperty('appTypes')) {
					return cvLoc('label.treenode.allAgents');
				} else {
					return smartClientGroupFactory.getReadableAgentNames(taskDetail.appGroup);
				}
			}
			return cvLoc('NOT_APPLICABLE');
		};
	}
]);

export default schedulePolicyMod;
