import { policyModule } from 'common/js/modules';

var app = policyModule;

app.filter('backupInterval', [
	'cvLoc',
	function(cvLoc) {
		return function(hours, minutes) {
			let timeString = '';
			if (hours > 0) {
				timeString += cvLoc('label.jobIntervalHours', hours) + ' ';
			}

			if (minutes > 0) {
				timeString += cvLoc('label.jobIntervalMinutes', minutes);
			}

			return timeString;
		};
	}
]);

export default app;
