import { policyModule } from 'common/js/modules';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyDetails.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyType.factory.js';
import 'adminConsole/js/controllers/clientGroups.ctrl.js';
import 'common/js/tableOptions.js';
import 'common/js/common.js';

var schedulePolicyMod = policyModule;

schedulePolicyMod.filter('associatedScheduleName', [
	'cvLoc',
	function(cvLoc) {
		return function(taskDetail) {
			var scheduleName = _.get(taskDetail, 'schedulePattern.name') || _.get(taskDetail, 'subTask.subTaskName');
			if (!scheduleName) {
				return '(' + cvLoc('label.unnamedSchedule') + ')';
			} else {
				return scheduleName;
			}
		};
	}
]);

export default schedulePolicyMod;
