import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.factory('schedulePolicyType', [
	'cvLoc',
	function(cvLoc) {
		return {
			DATA_PROTECTION: cvLoc('groupingOption.dataprotection'),
			AUX_COPY: cvLoc('Auxiliary_Copy'),
			SINGLE_INSTANCING: cvLoc('label.backupCopy'),
			CONTENT_INDEX: cvLoc('Offline_Content_Indexing'),
			CONTENT_INDEX_SUBCLIENT: cvLoc('label.contentIndexing'),
			DATA_VERIFICATION: cvLoc('data_verification'),

			getSchedulePolicyTypes: function() {
				return [
					{
						value: 'DATA_PROTECTION',
						label: cvLoc('groupingOption.dataprotection')
					},
					{
						value: 'AUX_COPY',
						label: cvLoc('Auxiliary_Copy')
					},
					{
						value: 'SINGLE_INSTANCING',
						label: cvLoc('label.backupCopy')
					},
					{
						value: 'CONTENT_INDEX',
						label: cvLoc('Offline_Content_Indexing')
					},
					{
						value: 'CONTENT_INDEX_SUBCLIENT',
						label: cvLoc('label.contentIndexing')
					},
					{
						value: 'DATA_VERIFICATION',
						label: cvLoc('data_verification')
					}
				];
			}
		};
	}
]);

export default schedulePolicyMod;
