import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'modules/policies/schedulePolicies/js/controllers/editAgentTypeForSchedulePolicy.ctrl.js';

import { policyModule } from 'common/js/modules';

var app = policyModule;

app.factory('schedulePolicyDetailsFactory', [
	'$uibModal',
	'schedulePolicyService',
	'cvLoc',
	function($modal, schedulePolicyService, cvLoc) {
		var factory = {};

		factory.getSchedulesGridColumnDefs = function(policyType) {
			var columns = [
				{
					field: 'subTask.subTaskName',
					displayName: cvLoc('header.name'),
					sort: {
						direction: 'asc',
						priority: 0
					},
					width: '25%',
					cellTemplate:
						'<span class="crop"><a data-ng-click="grid.appScope.editSchedule(row.entity)" title="{{row.entity.scheduleName}}" data-ng-bind="row.entity.scheduleName"></a></span>'
				},
				{
					field: 'pattern.description',
					displayName: cvLoc('label.pattern'),
					width: '40%',
					cellTemplate:
						'<span class="crop" title="{{row.entity.pattern.description}}" data-ng-bind="row.entity.pattern.description"></span>'
				},
				{
					field: 'Action',
					displayName: cvLoc('header.actions'),
					enableSorting: false,
					enableFiltering: false,
					enableHiding: false,
					width: '15%',
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' +
						'<li><a class="crop" data-ng-click="grid.appScope.runAssociatedSchedule(row.entity)">' +
						cvLoc('action.run') +
						'</a></li>' +
						'<li><a class="crop" data-ng-click="grid.appScope.deleteAssociatedSchedule(row.entity.subTask.subTaskId,row.entity.scheduleName)">' +
						cvLoc('label.delete') +
						'</a></li></ul></div>'
				}
			];

			if (policyType && policyType == 'DATA_PROTECTION') {
				columns.splice(1, 0, {
					field: 'options.backupOpts.backupLevel',
					displayName: cvLoc('label.jobType'),
					width: '15%',
					cellTemplate:
						'<span class="crop" title="{{row.entity.backupLevelName}}" data-ng-bind="row.entity.backupLevelName"></span>'
				});
			}

			return columns;
		};

		factory.extractSelectedAppGroups = function(agentsList) {
			var selectedAgents = [];
			if (agentsList.appGroups && agentsList.appGroups.length > 0) {
				agentsList.appGroups.forEach(function(appGroup) {
					selectedAgents.push({
						value: appGroup.appGroupId,
						isAppGroup: true
					});
				});
			}
			if (agentsList.appTypes && agentsList.appTypes.length > 0) {
				agentsList.appTypes.forEach(function(appType) {
					selectedAgents.push({
						value: appType.appTypeId,
						isAppGroup: false
					});
				});
			}
			return selectedAgents;
		};

		factory.getAppGroupIds = function(agentsList) {
			var agentIds = {
				appGroups: [],
				appTypes: []
			};
			if (agentsList && agentsList.length > 0) {
				agentsList.forEach(function(agent) {
					if (agent.isAppGroup) {
						agentIds.appGroups.push({
							appGroupId: agent.value
						});
					} else {
						agentIds.appTypes.push({
							appTypeId: agent.value
						});
					}
				});
			}
			return agentIds;
		};

		factory.modifyAgentType = function(taskInfo, appGroup) {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/editAgentTypeForSchedulePolicy.jsp',
				backdrop: 'static',
				controller: 'editAgentTypeForSchedulePolicyController as atCtrl',
				resolve: {
					inputParams: function() {
						return {
							taskInfo: taskInfo,
							appGroup: appGroup
						};
					}
				}
			});
		};

		factory.toggleSchedulePolicyStatus = function(taskId, disabled) {
			return schedulePolicyService.toggleStatus({
				taskId: taskId,
				opType: disabled ? 'DISABLE' : 'ENABLE'
			});
		};

		return factory;
	}
]);

export default app;
