import { policyModule } from 'common/js/modules';

var app = policyModule;

app.factory('cvScheduleSpecificOptions', [
	function() {
		var factory = {
			templateUrls: {
				DATA_PROTECTION: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/dataProtectionOptionsTile.jsp',
				AUX_COPY: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/auxCopyOptionsTile.jsp',
				SINGLE_INSTANCING: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/backupCopyOptionsTile.jsp',
				CONTENT_INDEX:
					appUtil.appRoot + 'modules/policies/schedulePolicies/partials/offlineContentIndexOptionsTile.jsp',
				DATA_VERIFICATION:
					appUtil.appRoot + 'modules/policies/schedulePolicies/partials/dataVerificationOptionsTile.jsp',
				WEB_REPORT: appUtil.appRoot + 'modules/policies/schedulePolicies/partials/reportOptionsTile.jsp',
				BLR_OPERATION:
					appUtil.appRoot + 'modules/policies/schedulePolicies/partials/blockLevelReplicationOptionsTile.jsp'
			}
		};

		factory.getTemplateUrl = getTemplateUrl;
		factory.isWebReportSchedule = isWebReportSchedule;

		function getTemplateUrl(taskInfo, subTask) {
			let taskType = _.get(taskInfo, 'task.taskType'),
				policyType = _.get(taskInfo, 'task.policyType'),
				subTaskOperationType = _.get(subTask, 'subTask.operationType');

			if (taskType === 'SCHEDULE') {
				if (policyType === 'DATA_PROTECTION' && subTaskOperationType === 'BACKUP') {
					return factory.templateUrls.DATA_PROTECTION;
				} else if (policyType === 'DATA_PROTECTION' && subTaskOperationType === 'BLR_OPERATION') {
					return factory.templateUrls.BLR_OPERATION;
				} else if (isWebReportSchedule(subTask)) {
					return factory.templateUrls.WEB_REPORT;
				}
				return '';
			}

			return factory.templateUrls[policyType];
		}

		function isWebReportSchedule(subTask) {
			let type = _.get(subTask, 'options.adminOpts.reportOption.commonOpt.reportType');
			return type === 'WEB_REPORT';
		}

		return factory;
	}
]);

export default app;
