import { policyModule } from 'common/js/modules';
import 'modules/policies/schedulePolicies/js/factory/cvScheduleSpecificOptions.factory.js';
import 'modules/policies/schedulePolicies/js/filters/backupInterval.filter.js';
import 'adminConsole/js/factories/reports.factory.js';
import 'factories/blockLevelReplication.factory.js';

var app = policyModule;

app.directive('cvScheduleSpecificOptions', [
	function() {
		return {
			restrict: 'E',
			template: '<data-ng-include src="ctrl.templateUrl"></data-ng-include>',
			scope: {
				taskInfo: '=',
				subTaskInfo: '='
			},
			controllerAs: 'ctrl',
			controller: [
				'$scope',
				'$log',
				'cvUtil',
				'cvToaster',
				'cvScheduleSpecificOptions',
				'schedulePolicyFactory',
				'schedulePolicyService',
				'customReportsFactory',
				'cvLoc',
				'blrUIFactory',
				function(
					$scope,
					$log,
					cvUtil,
					cvToaster,
					cvScheduleSpecificOptions,
					schedulePolicyFactory,
					schedulePolicyService,
					customReportsFactory,
					cvLoc,
					blrUIFactory
				) {
					var self = this;

					function initialize() {
						self.policyType = _.get($scope.taskInfo, 'task.policyType');
						self.scheduleModel = schedulePolicyFactory.initializeScheduleModel($scope.subTaskInfo, self.policyType);
						self.templateUrl = cvScheduleSpecificOptions.getTemplateUrl($scope.taskInfo, $scope.subTaskInfo);
						self.blrModel = schedulePolicyFactory.getBLRSpecificOptions($scope.subTaskInfo, self.policyType);
						self.testBootLabel = cvLoc('label.testBoot' + blrUIFactory.getFailoverEnabledLabelPostFix());
						self.permBootLabel = cvLoc('label.permBoot' + blrUIFactory.getFailoverEnabledLabelPostFix());
						self.reportSchedule = {}; //added to avoid undefined error in below code
						if (cvScheduleSpecificOptions.isWebReportSchedule($scope.subTaskInfo)) {
							self.reportSchedule = customReportsFactory.getScheduleDisplayDetails($scope.subTaskInfo);
							customReportsFactory.getReportInfoFromSchedule($scope.subTaskInfo).then(
								function success(data) {
									self.reportSchedule.reportDetails = data;
								},
								function error() {
									$log.error('Could not fetch report details');
								}
							);
							customReportsFactory.getScheduleUsersDataFromScheduleTask($scope.subTaskInfo).then(
								function success(data) {
									self.reportSchedule.usersToNotify = data;
								},
								function error() {
									$log.error('Could not load users details');
								}
							);
						}

						self.reportSchedule.isEnabled = !$scope.taskInfo.task.taskFlags.disabled;
						self.isTenantUserType = cv.isTenantAdmin || cv.isTenantOperator || cv.isTenantUser;

						$scope.$on('scheduleStatusChanged', function(event, status) {
							self.reportSchedule.isEnabled = status;
						});
					}

					function editScheduleSpecificOptions() {
						let callBackFunction = function(subTask) {
							return schedulePolicyService
								.editAssociatedSchedule({
									taskId: $scope.taskInfo.task.taskId,
									subTaskId: subTask.subTask.subTaskId,
									scheduleOptions: angular.toJson(subTask)
								})
								.success(function() {
									cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.scheduleUpdatedSuccess'));
									if (angular.isDefined(subTask.options)) {
										$scope.subTaskInfo.options = subTask.options;
									}
									self.scheduleModel = schedulePolicyFactory.initializeScheduleModel(subTask, self.policyType);
								}); //error callback is handled inside addScheduleToPolicyController
						};

						let inputParams = {
							task: $scope.taskInfo.task,
							scheduleToBeEdited: $scope.subTaskInfo,
							hideSchedulePattern: true,
							selectedAgents: $scope.taskInfo.appGroup,
							callBackFunction: callBackFunction
						};

						schedulePolicyFactory.addScheduleToPolicy(inputParams);
					}

					initialize();

					self.editScheduleSpecificOptions = editScheduleSpecificOptions;
				}
			]
		};
	}
]);

export default app;
