import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';

import { policyModule } from 'common/js/modules';

var schedulePolicyMod = policyModule;

schedulePolicyMod.controller('selectScheduleToRunController', [
	'$filter',
	'cvTableOptions',
	'$uibModalInstance',
	'cvLoc',
	'params',
	'schedulePolicyService',
	'cvToaster',
	'cvUtil',
	function($filter, cvTableOptions, $modal, cvLoc, params, schedulePolicyService, cvToaster, cvUtil) {
		var self = this;
		self.schedules = params.schedules;

		var taskId = params.taskId,
			taskName = params.taskName,
			policyType = params.policyType;

		self.schedules.forEach(function(schedule) {
			if (policyType == 'DATA_PROTECTION') {
				schedule.backupLevelName = $filter('backupLevelFilter')(schedule.options.backupOpts.backupLevel);
			}
			schedule.scheduleName = $filter('associatedScheduleName')(schedule);
		});

		var columns = [
			{
				field: 'Name',
				displayName: cvLoc('label.scheduleName'),
				width: '25%',
				cellTemplate: '<span class="crop" data-ng-bind="row.entity.scheduleName"></span>'
			},
			{
				field: 'pattern.description',
				displayName: cvLoc('label.pattern'),
				width: '40%',
				cellTemplate:
					'<span class="crop" title="{{row.entity.pattern.description}}" data-ng-bind="row.entity.pattern.description"></span>'
			}
		];
		if (policyType && policyType == 'DATA_PROTECTION') {
			columns.splice(1, 0, {
				field: 'options.backupOpts.backupLevel',
				displayName: cvLoc('label.jobType'),
				width: '15%',
				cellTemplate:
					'<span class="crop" title="{{row.entity.backupLevelName}}" data-ng-bind="row.entity.backupLevelName"></span>'
			});
		}

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: self.schedules,
			columnDefs: columns,
			enableColumnResize: true,
			selectWithCheckboxOnly: true,
			enableRowSelection: true,
			multiSelect: false,
			enableRowHeaderSelection: true,
			enableSelectAll: false,

			onRegisterApi: function(gridApi) {
				self.gridApi = gridApi;
				gridApi.selection.on.rowSelectionChanged(null, function() {
					self.gridSelected = gridApi.selection.getSelectedRows().length > 0;
					self.selectedRows = gridApi.selection.getSelectedRows();
					if (self.gridSelected) {
						self.serverMessage = cvUtil.emptyMsg();
					}
				});

				gridApi.selection.on.rowSelectionChangedBatch(null, function(row) {
					self.gridSelected = gridApi.selection.getSelectedRows().length > 0;
					self.selectedRows = gridApi.selection.getSelectedRows();
					if (self.gridSelected) {
						self.serverMessage = cvUtil.emptyMsg();
					}
				});
			}
		});

		self.gridOptions = {
			cvTableName: 'Schedules',
			cvHasColumnFilter: false,
			cvIsSearchable: false,
			cvHasViews: false,
			cvAppScope: self,
			cvGridCssClass: {
				'users-grid': true
			},
			gridOptions: globalGridOptions
		};

		self.runSchedule = function() {
			if (!self.gridSelected) {
				self.serverMessage = cvUtil.errMsgLoc('error.selectSchedule');
				return;
			}

			var schedule = self.selectedRows[0],
				subTaskId = schedule.subTask.subTaskId,
				subTaskName = schedule.subTask.subTaskName;

			schedulePolicyService
				.runSchedule(subTaskId, subTaskName, taskId, taskName)
				.success(function(jobIdList) {
					if (jobIdList) {
						$modal.dismiss();
						var responseContent;
						if (jobIdList.length == 1) {
							var jobId = jobIdList[0];
							responseContent =
								cvLoc('label.jobStarted', jobId) +
								'  <a target="_blank" href="' +
								'#/jobs/' +
								jobId +
								'">' +
								cvLoc('notification.viewJobs') +
								'</a>';
						} else if (jobIdList.length > 1) {
							responseContent =
								cvLoc('label.jobsStarted') +
								'. ' +
								'<a target="_blank" href="#/activeJobs" >' +
								cvLoc('notification.viewJobs') +
								'</a>';
						}
						cvToaster.showSuccessMessage({
							ttl: '10000', //10 sec
							message: responseContent
						});
					}
				})
				.error(function(error) {
					$modal.dismiss();
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};

		self.cancel = function() {
			$modal.dismiss();
		};
	}
]);

export default schedulePolicyMod;
