import 'modules/policies/schedulePolicies/js/services/schedulePolicy.svc.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePolicyDetails.factory.js';

import { policyModule } from 'common/js/modules';

var app = policyModule;

app.controller('editAgentTypeForSchedulePolicyController', [
	'$uibModalInstance',
	'schedulePolicyDetailsFactory',
	'inputParams',
	'schedulePolicyService',
	'cvToaster',
	'cvUtil',
	'$state',
	function(
		$modalInstance,
		schedulePolicyDetailsFactory,
		inputParams,
		schedulePolicyService,
		cvToaster,
		cvUtil,
		$state
	) {
		var self = this;
		self.model = {
			agentSelectionTree: {},
			initialSelection: [],
			selectAllNodes: false,
			serverMessage: cvUtil.emptyMsg(),
			taskInfo: inputParams.taskInfo
		};

		self.close = function() {
			$modalInstance.dismiss();
		};

		self.saveAgents = function() {
			var agentNodes = self.model.agentSelectionTree.getSelectedNodes(),
				agents;
			if (angular.isArray(agentNodes) && agentNodes.length == 0) {
				self.model.serverMessage = cvUtil.errMsgLoc('error.selectEntity');
				return;
			}

			if (
				self.model.agentSelectionTree.tree[0].selected == true &&
				self.model.agentSelectionTree.tree[0].__ivhTreeviewIndeterminate == false
			) {
				agents = {};
			} else {
				agents = schedulePolicyDetailsFactory.getAppGroupIds(agentNodes);
			}

			self.model.taskInfo.appGroup = agents;
			schedulePolicyService
				.updateAgentTypeForSchedulePolicy({
					taskDetailJson: angular.toJson(inputParams.taskInfo)
				})
				.success(function() {
					$modalInstance.close();
					$state.forceReload();
					cvToaster.showSuccessMessage(cvUtil.infoMsgLoc('label.agentTypeUpdatedSuccess'));
				})
				.error(showErrorMessage);
		};

		if (inputParams && inputParams.appGroup) {
			self.model.initialSelection = schedulePolicyDetailsFactory.extractSelectedAppGroups(inputParams.appGroup);
			self.model.selectAllNodes = self.model.initialSelection.length == 0;
		}

		function showErrorMessage(errorMessage) {
			if (errorMessage && angular.isString(errorMessage)) {
				self.model.serverMessage = cvUtil.errMsg(errorMessage);
			} else if (errorMessage && angular.isString(errorMessage.data)) {
				self.model.serverMessage = cvUtil.errMsg(errorMessage.data);
			} else {
				self.model.serverMessage = cvUtil.errMsgLoc('generic_error');
			}
		}
	}
]);

export default app;
