import 'modules/policies/schedulePolicies/js/factory/schedulePolicy.factory.js';
import 'modules/policies/schedulePolicies/js/constants/backupLevel.constants.js';
import 'modules/policies/schedulePolicies/js/constants/ddbverification.constants.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'storage/js/services/storage.svc.js';
import 'modules/policies/schedulePolicies/js/factory/backupOptionsMap.factory.js';
import 'modules/policies/schedulePolicies/js/factory/schedulePattern.factory.js';

import { policyModule } from 'common/js/modules';

var app = policyModule;

app.controller('addScheduleToPolicyController', [
	'$scope',
	'$rootScope',
	'$uibModalInstance',
	'scheduleUIFactory',
	'schedulePatternFactory',
	'cvLoc',
	'cvUtil',
	'schedulePolicyFactory',
	'BACKUP_TYPES',
	'backupOptionsMap',
	'inputParams',
	'storageService',
	'DDBVERIFICATION_LEVEL',
	'clientGroupService',
	'schedulePolicyService',
	'$q',
	function(
		$scope,
		$rootScope,
		$modalInstance,
		scheduleUIFactory,
		schedulePatternFactory,
		cvLoc,
		cvUtil,
		schedulePolicyFactory,
		BACKUP_TYPES,
		backupOptionsMap,
		inputParams,
		storageService,
		DDBVERIFICATION_LEVEL,
		clientGroupService,
		schedulePolicyService,
		$q
	) {
		var self = this,
			addPatternListener,
			editPatternListener,
			policyType,
			taskType,
			isSystemCreated;
		self.BACKUP_TYPES = BACKUP_TYPES;
		self.model = {
			schedulePolicyOptionsTemplate: '',
			serverMessage: cvUtil.emptyMsg(),
			existingSchedules: [],
			editMode: angular.isDefined(inputParams.subTask),
			mediaAgentList: []
		};

		self.close = function() {
			$modalInstance.dismiss();
		};

		if (inputParams && inputParams.task.policyType) {
			policyType = inputParams.task.policyType;
			taskType = inputParams.task.taskType;
			isSystemCreated = inputParams.task.isSystemCreated;
			self.model.hideSchedulePattern = inputParams.hideSchedulePattern || false;
			self.model.schedulePolicyOptionsTemplate = schedulePolicyFactory.getScheduleOptionsTemplate(
				policyType,
				_.get(inputParams, 'subTask.subTask')
			);
			self.scheduleModel = schedulePolicyFactory.initializeScheduleModel(inputParams.subTask, policyType);
			self.model.existingSchedules = inputParams.existingSchedules;

			if (policyType == 'DATA_VERIFICATION') {
				storageService
					.getMediaAgentList('NONE')
					.success(function(data) {
						self.model.mediaAgentList = data;
					})
					.error(showErrorMessage);
			} else if (policyType == 'DATA_PROTECTION') {
				initOptionsForDataProtection(inputParams.selectedAgents);
			} else if (policyType == 'CONTENT_INDEX_SUBCLIENT') {
				initOptionsForContentIndexing();
			}
		}

		self.addSchedulePattern = function(isEdit) {
			var attributes = {
				hideBackupLevelOptions: true,
				operationType: schedulePolicyFactory.getTaskOperationType(policyType, self.scheduleModel.subTask),
				subTaskType: schedulePolicyFactory.getSubTaskType(policyType, self.scheduleModel.subTask),
				customTitle: cvLoc(isEdit ? 'label.editSchedulePattern' : 'label.addSchedulePattern'),
				hideAutomaticSchedules: schedulePatternFactory.isAutomaticScheduleSupported(taskType, policyType),
				existingSchedules: self.model.existingSchedules,
				scheduleNameNotRequired: true,
				isSystemCreated: isSystemCreated,
				context: 'SCHEDULE_POLICY',
				hideTimeInCommServeTimezone: true
			};

			var scheduleObj = {};

			if (isEdit && self.scheduleModel.schedulePattern) {
				self.scheduleModel.schedulePattern.opType = 'EDIT';
				scheduleObj.model = self.scheduleModel.schedulePattern;
				scheduleObj.model.hideDelete = true;
				initDefaultOptionsForAutomaticSchedules();
			}

			scheduleUIFactory.addSchedule(
				scheduleObj,
				isEdit,
				'Server',
				false,
				undefined,
				undefined,
				attributes,
				undefined,
				'associatedScheduleModified'
			);

			addPatternListener = $rootScope.$on('associatedScheduleModified', function(evt, addedSchedule) {
				clearServerMessage();
				schedulePatternFactory.formatRepeatSettingsObject(addedSchedule);
				self.scheduleModel.schedulePattern = addedSchedule;
			});
		};

		self.editSchedulePattern = function() {
			self.addSchedulePattern(true);
		};

		self.isSchedulePatternEditable = function() {
			var freqType = _.get(self, 'scheduleModel.schedulePattern.freqType', 'DAILY');
			return (
				freqType == 'AUTOMATIC_SCHEDULE' ||
				freqType == 'DAILY' ||
				freqType == 'WEEKLY' ||
				freqType == 'MONTHLY' ||
				freqType == 'MONTHLY_RELATIVE' ||
				freqType == 'ONE_TIME' ||
				freqType == 'AFTER_JOB_COMPLETES'
			);
		};

		self.saveSchedule = function() {
			if (self.scheduleModel.schedulePattern)
				schedulePatternFactory.formatRepeatSettingsObject(self.scheduleModel.schedulePattern);
			var subTask = schedulePolicyFactory.convertScheduleModelToSubtask(self.scheduleModel, policyType);
			if (isValid(subTask)) {
				var callBackFunction = inputParams.callBackFunction;
				if (angular.isFunction(callBackFunction)) {
					callBackFunction(subTask).then(function() {
						$modalInstance.dismiss();
					}, showErrorMessage);
				} else {
					$modalInstance.close(subTask);
				}
			}
		};

		/* used only in dataProtectionOptions.jsp */
		self.isIncrementalSelected = function() {
			return self.scheduleModel.backupLevel == BACKUP_TYPES.INCREMENTAL;
		};

		function isValid(subTask) {
			var defragmentationPercentage = _.get(subTask, 'options.adminOpts.archiveCheckOption.defragmentationPercentage');
			if (
				_.get(subTask, 'options.adminOpts.archiveCheckOption.ddbVerificationLevel') ==
					DDBVERIFICATION_LEVEL.DDB_DEFRAGMENTATION &&
				(isNaN(defragmentationPercentage) || defragmentationPercentage < 20 || defragmentationPercentage > 80)
			) {
				self.model.serverMessage = cvUtil.errMsgLoc('error.invalidReclamationLevel');
				return false;
			} else if (
				_.get(subTask, 'options.backupOpts.mediaOpt.auxcopyJobOption.useMaximumStreams') == false &&
				_.get(subTask, 'options.backupOpts.mediaOpt.auxcopyJobOption.maxNumberOfStreams') == undefined
			) {
				self.model.serverMessage = cvUtil.errMsgLoc('error.invalidNoOfStreams');
				return false;
			} else if (angular.isUndefined(subTask.schedulePattern)) {
				self.model.serverMessage = cvUtil.errMsgLoc('error.addSchedulePattern');
				return false;
			}
			return true;
		}

		function clearServerMessage() {
			self.model.serverMessage = cvUtil.emptyMsg();
		}

		function initDefaultOptionsForAutomaticSchedules() {
			var freqType = _.get(self, 'scheduleModel.schedulePattern.freqType', 'DAILY');
			if (freqType == 'AUTOMATIC_SCHEDULE') {
				return;
			}
			angular.extend(
				self.scheduleModel.schedulePattern,
				schedulePatternFactory.getDefaultOptionsForAutomaticSchedules()
			);
		}

		function initOptionsForDataProtection(selectedAgents) {
			if (taskType === 'SCHEDULE') {
				self.supportedBackupOptions = backupOptionsMap.getDefaultBackupOptionsForSchedules();
			}
			self.supportedBackupOptions = backupOptionsMap.getSupportedBackupOptions(selectedAgents);
		}

		function initOptionsForContentIndexing() {
			var servers = [],
				clientsList = [],
				clientGroupsList = [],
				promises = [];

			promises.push(clientGroupService.getClientGroups()); // Loading client groups
			promises.push(schedulePolicyService.getMemberServers()); // Loading clients for CI access nodes
			var selectedClientsList = [];
			if (self.model.editMode && _.get(self, 'scheduleModel.proxies.memberServers')) {
				var initialSelection = _.get(self, 'scheduleModel.proxies.memberServers');
				for (var i = 0; i < initialSelection.length; i++) {
					selectedClientsList.push(initialSelection[i].client.clientGroupId);
				}
			}

			$q.all(promises).then(function(responses) {
				// Client computer groups
				if (responses[0].data.length) {
					clientGroupsList = responses[0].data.map(function(obj) {
						var node = {
							clientGroupId: obj.Id,
							clientGroupName: obj.name,
							name: obj.name
						};
						if (selectedClientsList.includes(obj.Id)) {
							node['checked'] = true;
						}
						return node;
					});
					cvUtil.sortAscending(clientGroupsList, 'name');
					servers = servers.concat(clientGroupsList);
				}

				// Client computers
				if (responses[1].data.length) {
					clientsList = responses[1].data; //memberServers
					clientsList = clientsList.map(function(obj) {
						return {
							clientId: obj.client.clientId,
							clientName: obj.client.clientName,
							name: obj.client.clientName
						};
					});
					cvUtil.sortAscending(clientsList, 'name');
					servers = servers.concat(clientsList);
				}
				self.model.serversList = servers;
			});
		}

		function showErrorMessage(errorMsg) {
			self.model.serverMessage = cvUtil.errMsgWrapper(errorMsg);
		}

		$scope.$on('$destroy', function cleanUp() {
			if (editPatternListener) {
				editPatternListener();
			}

			if (addPatternListener) {
				addPatternListener();
			}
		});
	}
]);

export default app;
