import { policyModule } from 'common/js/modules';

var app = policyModule;
/*
 * These constants defined specific for schedule policies; Schedule policy of type: "Data Protection" can
 * support multiple agents.
 *
 * Based on the agents selected for a schedule policy, we have to determine what backup-options should be
 * visible in the UI. These constants are used for this purpose. refer to backupOptionsMap.factory.js for more
 * details.
 */
app.constant('SUPPORTED_BACKUP_OPTIONS', {
	FULL: 1,
	INCREMENTAL: 2,
	DIFFERENTIAL: 4,
	SYNTHETIC_FULL: 8,
	CLEANUP: 16,
	PRE_SELECT: 32,
	TRANSACTION_LOG: 64,
	LOG: 128,
	DATA: 256,
	CUMULATIVE: 512,
	CUMULATIVE_INCREMENTAL: 1024
});

export default app;
