<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvEnum name="Ida.ContentIndexOpType"></cv:cvEnum>
</script>
<div class="row">
	<div class="col-md-12">
			<span data-ng-if="showEdit"><cv-changename obj='changeNameObj' service-method="renamePlan.do" class="float-left"></cv-changename></span>
			<h1 class='page-title' data-ng-if="!showEdit">{{profileName}}</h1>
			<!-- <span><a class="page-action-item" href=""><cv:msg key="action.asignToUsers" bundle="profiles" /></a></span> -->
			<span data-ng-if="showDelete"><a class="page-action-item" href="" data-ng-click="deleteProfile(profileId, profileName, true)"><cv:msg key="action.delete" bundle="profiles" /></a></span>
	</div>
</div>
<cv-tab-nav data-ng-if="enableDCPlanSchedule"></cv-tab-nav>
<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
<div class="row">
	<div class="col-md-6">
		<div>
			<cv-tile-component data-ac-id="label_analyticsEngine-ediscovery" title='<cv:msg key="label.general" bundle="profiles"/>' loader="localContentTemplate">
				<cv-plan-dcpolicy-general plan-options="profileDetails.options" ediscovery-info="ediscoveryInfo" read-only="true"></cv-plan-dcpolicy-general>
			</cv-tile-component>
		</div>
		<cv-security-component entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded="associationsLoaded">
		</cv-security-component>
	</div>
	<div class="col-md-6">
		<div data-ng-if="ediscoveryInfo.targetAppType !== '8'">
			<cv-tile-component data-ac-id="label_configuration-ediscovery" title='<cv:msg key="label.entityDetection" bundle="ediscovery"/>' loader="localContentTemplate">
				<cv-plan-ee-policy ee-policy="ediscoveryInfo.eePolicy" ediscovery-info="ediscoveryInfo" ci-policy="ediscoveryInfo.ciPolicy" read-only="true"></cv-plan-ee-policy>
				<div class="page-details-box-links" data-ng-if="ediscoveryInfo.allowEEEdit">
					<a href="" data-ng-click="modifyEdiscoveryConfig('eePolicy')"><cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
		</div>
		<div>
			<cv-tile-component data-ac-id="ciPolicyDetails" data-title='<cv:msg key="label.contentIndexing" bundle="ediscovery"/>'>
				<cv-plan-ci-policy ci-policy="ediscoveryInfo.ciPolicy" read-only="true" target-app="ediscoveryInfo.targetAppType" schedule="dcPlanSchedule" update-schedule="addEdiscoverySchedule(schedule, successCallback, errorCallback)"
					generic-entity="{ 'entityId': profileId, 'entityName': profileName }"></cv-plan-ci-policy>
	     	  	<div class="page-details-box-links" data-ng-if="ediscoveryInfo.allowCIEdit">
					<a href="" data-ng-click="modifyEdiscoveryConfig('ciPolicy')"><cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
	        </cv-tile-component>
		</div>
		<div>
			<cv-tile-component data-ac-id="ciPolicyFilters" data-title='<cv:msg key="label.dcPlanFilters" bundle="profiles"/>'>
				<cv-plan-dcpolicy-filefilters ci-policy="ediscoveryInfo.ciPolicy" read-only="true" target-app="ediscoveryInfo.targetAppType"></cv-plan-dcpolicy-filefilters>
				<div class="page-details-box-links" data-ng-if="ediscoveryInfo.allowOptionsEdit">
					<a href="" data-ng-click="modifyEdiscoveryConfig('policyFilters')"><cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
		</div>
	</div>
</div>