<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>;
</script>
<span class="backup-content margin-top-10">
	<uib-tabset justified="true" active="defaultTab">
		<!-- // folder filter starts // -->
		<uib-tab heading="Folder filters">
			<fieldset class="toggle-inner-links">
				<div id="backup-content-wrapper">
					<div class="content-checkboxes">
						<div id="backup-content-folders" data-ng-if="exchangeEditModalController.enableOneDriveIncludeFolder">
							<div class="content-header clearfix">
								<h4>
									<cv:msg key="label.include.folder" bundle="office365" />
									<cv-help-component
										help-text='<cv:msg key="label.includeFolderFilterHelpText" bundle="profiles"/>'
									></cv-help-component>
								</h4>
								<div class="content-header-actions">
									<span
										class="page-action-item"
										data-ng-if="exchangeEditModalController.oneDriveDetails.includeFolderFilters.folderPatternsSelected.length > 0"
									>
										<a
											href=""
											data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.includeFolderFilters'], 'includeFolderFiltersName', true)"
										>
											<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
										</a>
									</span>
								</div>
							</div>

							<div class="peopleInfos ownerInfo content-to-backup">
								<div class="cv-modal-wrapper O365-modal select-mode interactive-install-link no-margin">
									<label class="cv-label filter-label" for="includefolderName"
										><cv:msg key="label.customFolderName" bundle="profiles"
									/></label>
									<div class="cv-inline-wrapper filter-name-input-wrapper">
										<input class="display-inline filter-input" type="text" name="includefolderName" 
										ng-blur="exchangeEditModalController.addFilterValues(['oneDriveDetails.includeFolderFilters'], 'includeFolderFiltersName')"
										id="includefolderName" data-ng-model="exchangeEditModalController.includeFolderFiltersName"
										placeholder="<cv:msg key="label.enterFolderName" bundle="profiles" />">
										<i
											class="k-icon k-i-plus cursor-pointer"
											id="filter-buttons"
											title="Add"
											ng-click="exchangeEditModalController.addFilterValues(['oneDriveDetails.includeFolderFilters'], 'includeFolderFiltersName')"
										></i>
										<i
											class="k-icon k-i-close cursor-pointer"
											id="filter-buttons"
											title="Remove"
											ng-click="exchangeEditModalController.includeFolderFiltersName = ''"
										></i>
									</div>
								</div>
								<ul
									class="users-list limit-modal-height"
									data-ng-if="exchangeEditModalController.oneDriveDetails.includeFolderFilters.folderPatternsSelected.length > 0"
								>
									<li
										data-ng-repeat="includeFolder in exchangeEditModalController.oneDriveDetails.includeFolderFilters.folderPatternsSelected | orderBy track by $index"
										title="{{ includeFolder }}"
									>
										<span class="content-library-folder content-library-folder">
											<label
												for="windows-{{ includeFolder }}"
												class="ellipsis-parent ellipsis-content"
												data-ng-if="includeFolder === '*'"
											>
												<span data-ng-if="includeFolder === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
											</label>
											<span data-ng-if="includeFolder !== '*'">
												<span>
													<label
														for="windows-{{ includeFolder }}"
														class="ellipsis-parent ellipsis-content name-break-all"
													>
														<span ng-bind="includeFolder"></span>
													</label>
												</span>
												<span class="delete-row"
													><a
														href=""
														data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.includeFolderFilters'], 'includeFolderFiltersName', false)"
														title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ includeFolder }}"
														><span class="k-icon k-i-close"></span></a
												></span>
											</span>
										</span>
									</li>
								</ul>
								<label
									class="users-list limit-modal-height"
									data-ng-if="exchangeEditModalController.oneDriveDetails.includeFolderFilters.folderPatternsSelected.length === 0"
								>
									<span class="content-library-folder content-library-folder">
										<label for="windows-{{ includeFolder }}" class="ellipsis-parent ellipsis-content">
											<span><cv:msg key="label.all" bundle="exchange"/></span>
										</label>
									</span>
								</label>
							</div>
						</div>
						<div id="exclude-folders">
							<div class="content-header clearfix">
								<h4><cv:msg key="label.exclude.folder" bundle="office365" /></h4>
								<div class="content-header-actions">
									<span
										class="page-action-item"
										data-ng-if="exchangeEditModalController.oneDriveDetails.excludeFolderFilters.folderPatternsSelected.length > 0"
									>
										<a
											href=""
											data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.excludeFolderFilters'], 'excludeFolderFiltersName', true)"
										>
											<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
										</a>
									</span>
								</div>
							</div>
							<div class="peopleInfos ownerInfo content-to-backup">
								<div class="cv-modal-wrapper O365-modal select-mode interactive-install-link no-margin">
									<label class="cv-label filter-label" for="excludefolderName"
										><cv:msg key="label.customFolderName" bundle="profiles"
									/></label>
									<div class="cv-inline-wrapper filter-name-input-wrapper">
										<input class="display-inline filter-input" type="text" name="excludefolderName"
										id="excludefolderName" data-ng-model="exchangeEditModalController.excludeFolderFiltersName"
										ng-blur="exchangeEditModalController.addFilterValues(['oneDriveDetails.excludeFolderFilters'], 'excludeFolderFiltersName')"
										placeholder="<cv:msg key="label.enterFolderName" bundle="profiles" />">
										<i
											class="k-icon k-i-plus cursor-pointer"
											id="filter-buttons"
											title="Add"
											ng-click="exchangeEditModalController.addFilterValues(['oneDriveDetails.excludeFolderFilters'], 'excludeFolderFiltersName')"
										></i>
										<i
											class="k-icon k-i-close cursor-pointer"
											id="filter-buttons"
											title="Remove"
											ng-click="exchangeEditModalController.excludeFolderFiltersName = ''"
										></i>
									</div>
								</div>
								<ul
									class="users-list limit-modal-height"
									ng-if="exchangeEditModalController.oneDriveDetails.excludeFolderFilters.folderPatternsSelected.length > 0"
								>
									<li
										data-ng-repeat="excludeFolder in exchangeEditModalController.oneDriveDetails.excludeFolderFilters.folderPatternsSelected | orderBy track by $index"
										title="{{ includeFolder }}"
									>
										<span class="content-library-folder">
											<label
												for="windows-{{ excludeFolder }}"
												class="ellipsis-parent ellipsis-content"
												data-ng-if="excludeFolder === '*'"
											>
												<span data-ng-if="excludeFolder === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
											</label>
											<span data-ng-if="excludeFolder !== '*'">
												<span>
													<label
														for="windows-{{ excludeFolder }}"
														class="ellipsis-parent ellipsis-content name-break-all"
													>
														<span ng-bind="excludeFolder"></span>
													</label>
												</span>
												<span class="delete-row"
													><a
														href=""
														data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.excludeFolderFilters'], 'excludeFolderFiltersName', false)"
														title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ excludeFolder }}"
														><span class="k-icon k-i-close"></span></a
												></span>
											</span>
										</span>
									</li>
								</ul>
								<label
									data-ng-if="exchangeEditModalController.oneDriveDetails.excludeFolderFilters.folderPatternsSelected.length === 0"
									class="users-list limit-modal-height"
								>
									<span class="k-icon k-i-cancel-outline error"></span>
									<span><cv:msg key="label.none" bundle="profiles"/></span>
								</label>
							</div>
						</div>
					</div>
				</div>
			</fieldset>
		</uib-tab>
		<!-- // folder filter ends // -->
		<!-- // file filter starts // -->
		<uib-tab heading="File filters">
			<fieldset class="toggle-inner-links">
				<div id="backup-content-wrapper">
					<div class="content-checkboxes">
						<div id="backup-content-folders">
							<div class="content-header clearfix">
								<h4>
									<cv:msg key="label.include.file" bundle="office365" />
									<cv-help-component
										help-text='<cv:msg key="label.includeFileFilterHelpText" bundle="profiles"/>'
									></cv-help-component>
								</h4>
								<div class="content-header-actions">
									<span
										class="page-action-item"
										data-ng-if="exchangeEditModalController.oneDriveDetails.includeFileFilters.folderPatternsSelected.length > 0"
									>
										<a
											href=""
											data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.includeFileFilters'], 'includeFileFiltersName', true)"
										>
											<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
										</a>
									</span>
								</div>
							</div>
							<div class="peopleInfos ownerInfo content-to-backup">
								<div class="cv-modal-wrapper O365-modal select-mode interactive-install-link no-margin">
									<label class="cv-label filter-label" for="includefileName"
										><cv:msg key="label.fileName" bundle="profiles"
									/></label>
									<div class="cv-inline-wrapper filter-name-input-wrapper">
										<input class="display-inline filter-input" type="text" name="includefileName" id="includefileName"
										ng-blur="exchangeEditModalController.addFilterValues(['oneDriveDetails.includeFileFilters'], 'includeFileFiltersName')"
										data-ng-model="exchangeEditModalController.includeFileFiltersName" placeholder="<cv:msg
											key="label.enterFileName"
											bundle="profiles"
										/>">
										<i
											class="k-icon k-i-plus cursor-pointer"
											id="filter-buttons"
											title="Add"
											ng-click="exchangeEditModalController.addFilterValues(['oneDriveDetails.includeFileFilters'], 'includeFileFiltersName')"
										></i>
										<i
											class="k-icon k-i-close cursor-pointer"
											id="filter-buttons"
											title="Remove"
											ng-click="exchangeEditModalController.includeFileFiltersName = ''"
										></i>
									</div>
								</div>
								<ul
									class="users-list limit-modal-height"
									data-ng-if="exchangeEditModalController.oneDriveDetails.includeFileFilters.folderPatternsSelected.length > 0"
								>
									<li
										data-ng-repeat="includeFile in exchangeEditModalController.oneDriveDetails.includeFileFilters.folderPatternsSelected | orderBy track by $index"
										title="{{ includeFile }}"
									>
										<span class="content-library-folder content-library-file">
											<label
												for="windows-{{ includeFile }}"
												class="ellipsis-parent ellipsis-content"
												data-ng-if="includeFile === '*'"
											>
												<span data-ng-if="includeFile === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
											</label>
											<span data-ng-if="includeFile !== '*'">
												<span>
													<label
														for="windows-{{ includeFile }}"
														class="ellipsis-parent ellipsis-content name-break-all"
													>
														<span ng-bind="includeFile"></span>
													</label>
												</span>
												<span class="delete-row"
													><a
														href=""
														data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.includeFileFilters'], 'includeFileFiltersName', false)"
														title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ includeFile }}"
														><span class="k-icon k-i-close"></span></a
												></span>
											</span>
										</span>
									</li>
								</ul>
								<label
									class="users-list limit-modal-height"
									data-ng-if="exchangeEditModalController.oneDriveDetails.includeFileFilters.folderPatternsSelected.length === 0"
								>
									<span class="content-library-folder content-library-folder">
										<label for="windows-{{ includeFile }}" class="ellipsis-parent ellipsis-content">
											<span><cv:msg key="label.all" bundle="exchange"/></span>
										</label>
									</span>
								</label>
							</div>
						</div>
						<div id="exclude-folders">
							<div class="content-header clearfix">
								<h4><cv:msg key="label.exclude.file" bundle="office365" /></h4>
								<div class="content-header-actions">
									<span
										class="page-action-item"
										data-ng-if="exchangeEditModalController.oneDriveDetails.excludeFileFilters.folderPatternsSelected.length > 0"
									>
										<a
											href=""
											data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.excludeFileFilters'], 'excludeFileFiltersName', true)"
										>
											<span><cv:msg key="label.removeAll" bundle="profiles"/></span>
										</a>
									</span>
								</div>
							</div>
							<div class="peopleInfos ownerInfo content-to-backup">
								<div class="cv-modal-wrapper O365-modal  select-mode interactive-install-link no-margin">
									<label class="cv-label filter-label" for="includefolderName"
										><cv:msg key="label.fileName" bundle="profiles"
									/></label>
									<div class="cv-inline-wrapper filter-name-input-wrapper">
										<input class="display-inline filter-input" type="text" name="includefolderName"
										id="includefolderName" data-ng-model="exchangeEditModalController.excludeFileFiltersName"
										ng-blur="exchangeEditModalController.addFilterValues(['oneDriveDetails.excludeFileFilters'], 'excludeFileFiltersName')"
										placeholder="<cv:msg key="label.enterFileName" bundle="profiles" />">
										<i
											class="k-icon k-i-plus cursor-pointer"
											id="filter-buttons"
											title="Add"
											ng-click="exchangeEditModalController.addFilterValues(['oneDriveDetails.excludeFileFilters'], 'excludeFileFiltersName')"
										></i>
										<i
											class="k-icon k-i-close cursor-pointer"
											id="filter-buttons"
											title="Remove"
											ng-click="exchangeEditModalController.excludeFileFiltersName = ''"
										></i>
									</div>
								</div>
								<ul
									class="users-list limit-modal-height"
									ng-if="exchangeEditModalController.oneDriveDetails.excludeFileFilters.folderPatternsSelected.length > 0"
								>
									<li
										data-ng-repeat="excludeFile in exchangeEditModalController.oneDriveDetails.excludeFileFilters.folderPatternsSelected | orderBy track by $index"
										title="{{ excludeFile }}"
									>
										<span class="content-library-folder content-library-file">
											<label
												for="windows-{{ excludeFile }}"
												class="ellipsis-parent ellipsis-content"
												data-ng-if="excludeFile === '*'"
											>
												<span data-ng-if="excludeFile === '*'"><cv:msg key="label.all" bundle="exchange"/></span>
											</label>
											<span data-ng-if="excludeFile !== '*'">
												<span>
													<label
														for="windows-{{ excludeFile }}"
														class="ellipsis-parent ellipsis-content name-break-all"
													>
														<span ng-bind="excludeFile"></span>
													</label>
												</span>
												<span class="delete-row"
													><a
														href=""
														data-ng-click="exchangeEditModalController.removeFilterValues(['oneDriveDetails.excludeFileFilters'], 'excludeFileFiltersName', false)"
														title="<cv:msg key='label.removeContent' bundle='collectionsJs'/> {{ excludeFolder }}"
														><span class="k-icon k-i-close"></span></a
												></span>
											</span>
										</span>
									</li>
								</ul>
								<label
									data-ng-if="exchangeEditModalController.oneDriveDetails.excludeFileFilters.folderPatternsSelected.length === 0"
									class="users-list limit-modal-height"
								>
									<span class="k-icon k-i-cancel-outline error"></span>
									<span><cv:msg key="label.none" bundle="profiles"/></span>
								</label>
							</div>
						</div>
					</div>
				</div>
			</fieldset>
		</uib-tab>
		<!-- // file filter ends // -->
	</uib-tabset>
	<!-- // entire tab set ends // -->
</span>
