<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div data-ng-if="!office365PlanDetailsController.planLoaded"
	class="ajax-loader-container">
	<span data-cv-loading-spinner data-ng-model="loader"></span>
</div>
<div data-ng-if="office365PlanDetailsController.planLoaded">
	<div class="row">
		<div class="col-md-12">
			<cv-changename class="float-left" data-obj="office365PlanDetailsController.changeNameObj" data-ng-if="office365PlanDetailsController.canEdit == true" data-service-method="renamePlan.do"></cv-changename>
			<h1 class='page-title' data-ng-if="office365PlanDetailsController.canEdit == false">{{office365PlanDetailsController.plan.originalPlanInfo.summary.plan.planName}}</h1>
			<a	class="page-action-item pull-right" href="" data-ng-if="office365PlanDetailsController.canDelete === true" data-ng-click="office365PlanDetailsController.deletePlan()">
				<cv:msg key="action.delete" bundle="profiles" />
			</a>
		</div>
	</div>
	<cv-tab-nav ng-if="office365PlanDetailsController.hasTabs"></cv-tab-nav>
	<div class="row">
		<div class="col-md-6">
			<!-- Security tile Start -->
			<cv-security-component entity-type='office365PlanDetailsController.entityType'
				generic-entity='office365PlanDetailsController.genericEntity'
				associations='office365PlanDetailsController.formattedSecurityAssociations'
				associations-loaded='office365PlanDetailsController.associationsLoaded' show-edit='office365PlanDetailsController.canEdit' hide-inherited-associations='office365PlanDetailsController.isTenantAdmin'></cv-security-component>
			<!-- Security tile End -->
			<!-- Search Tile -->
			<cv-tile-component data-ng-if="office365PlanDetailsController.getAppBasedModes.showSearch" data-help-text="<cv:msg key="label.applicableOnlyForExchange" bundle="profiles" />" data-title=" <cv:msg key="label.search" bundle="profiles" />" >
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn">{{'label.contentIndexing' | cvLoc}}</span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="office365PlanDetailsController.canEdit" value="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex"
								on-click="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration = false;	office365PlanDetailsController.openEditSearchSettingsModal(data, 'enableContentIndex')"></cv-toggle>
								<span data-ng-if="!office365PlanDetailsController.canEdit">{{::office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
						</li>
						<li class="group"  ng-if="office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex && office365PlanDetailsController.showExactSearch">
						<span class="pageDetailColumn"><cv:msg key="label.enableExactSearch" bundle="exchange"></cv:msg></span>
							<span class="pageDetailColumn">
							<cv-toggle data-ng-if="office365PlanDetailsController.canEdit == true" value="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch"
								toggle-model="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch"
								on-click="office365PlanDetailsController.openEditSearchSettingsModal(data, 'enableExactSearch')"></cv-toggle>
								<span data-ng-if="office365PlanDetailsController.canEdit == false">{{::office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableExactSearch? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<li class="group"  ng-if="office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableContentIndex">
						<span class="pageDetailColumn">{{'label.enablePreviewGeneration' | cvLoc}}</span>
							<span class="pageDetailColumn">
							<cv-toggle data-ng-if="office365PlanDetailsController.canEdit == true" value="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration"
								toggle-model="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration"
								on-click="office365PlanDetailsController.openEditSearchSettingsModal(data, 'enablePreviewGeneration')"></cv-toggle>
								<span data-ng-if="office365PlanDetailsController.canEdit == false">{{::office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
						</li>
						<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.entitySearch" bundle="exchange"></cv:msg></span>
						<span class="pageDetailColumn">
							<cv-toggle data-ng-if="office365PlanDetailsController.canEdit == true" value="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch"
								toggle-model="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch"
								on-click="office365PlanDetailsController.openEditSearchSettingsModal(data, 'enableEntitySearch')"></cv-toggle>
								<span data-ng-if="office365PlanDetailsController.canEdit == false">{{::office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="office365PlanDetailsController.canEdit == true && (office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enableEntitySearch == true || office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps.enablePreviewGeneration == true)"
					data-ng-click="office365PlanDetailsController.plan.openEditSearchSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- Archive Mailbox Types Tile -->
			<cv-tile-component data-ac-id="office365MailboxPlanDetails-label_archiveMailboxTypes-exchange" data-ng-if="office365PlanDetailsController.getAppBasedModes.showExchangeTile" data-title="<cv:msg key="label.clientType.exchange" bundle="exchange" />">
				<ul class="list-style-secondary">
					<li class="group" data-ng-repeat="type in office365PlanDetailsController.mailboxTypes track by type.key">
						<span class="pageDetailColumn" data-ng-bind="type.displayName"></span>
						<span class="pageDetailColumn">
	 						<cv-toggle data-ng-if="office365PlanDetailsController.canEdit" value="office365PlanDetailsController.plan.planInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy[type.key]"
							on-click="office365PlanDetailsController.saveArchiveData(data, type.key)"></cv-toggle>
							<span data-ng-if="!office365PlanDetailsController.canEdit">{{::office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365Exchange.mbArchiving.detail.emailPolicy.archivePolicy[type.key] ? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="office365PlanDetailsController.canEdit" data-ng-click="office365PlanDetailsController.plan.openEditArchiveSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>
			<!-- End - Archive Mailbox Types Tile -->
		</div>
		<div class="col-md-6">
			<!--  Start Retention Tile -->
			<cv-tile-component data-title="{{'label.retention' | cvLoc}}">
				<ul class="list-style-secondary">
					<li class="group"
						data-ng-if="office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365CloudOffice.caRetention.detail.cloudAppPolicy.retentionPolicy.numOfDaysForDeletedMediaPruning < 0 ">
						<span class="pageDetailColumn"><cv:msg key="label.retentionDays" bundle="collections"/></span>
						<span class="pageDetailColumn"><cv:msg key="label.infinite" bundle="collections"/></span>
					</li>
					<li class="group"
						data-ng-if="(office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365CloudOffice.caRetention.detail.cloudAppPolicy.retentionPolicy.numOfDaysForDeletedMediaPruning > 0 && office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365CloudOffice.caRetention.detail.cloudAppPolicy.retentionPolicy.type == 'SOURCE_DELETION_TIME')"><span
						class="pageDetailColumn"><cv:msg key="label.retainBasedOnDeletedItems" bundle="office365"/></span>
						<span class="pageDetailColumn"> <span ng-bind="office365PlanDetailsController.plan.originalPlanInfo.office365Info.o365CloudOffice.caRetention.detail.cloudAppPolicy.retentionPolicy.numOfDaysForDeletedMediaPruning"></span> <span><cv:msg key="label.days" bundle="exchange"/></span> </span>
					</li>
				</ul>
				<div class="page-details-box-links" data-ng-if="office365PlanDetailsController.canEdit">
					<a href="" data-ng-click="office365PlanDetailsController.plan.openEditRetentionRulesModal(office365PlanDetailsController.isArchiveMailbox)"><cv:msg key="action.edit" bundle="exchange"/></a>
				</div>
			</cv-tile-component>
			<!-- End Retention Tile -->
			<cv-tile-component data-ac-id="office365MailboxPlanDetails-label_archiveMailboxTypes-exchange"  data-ng-if="office365PlanDetailsController.getAppBasedModes.showOneDriveTile" data-title="<cv:msg key="label.oneDrive" bundle="profiles" />">
				<ul class="list-style-secondary">
					<li class="group" data-ng-if="office365PlanDetailsController.enableOneDriveBackupVersions">
						<span class="pageDetailColumn"> <cv:msg key="label.backupFileVersion" bundle="office365"/> </span>
						<span class="pageDetailColumn">
	 						<cv-toggle data-ng-if="office365PlanDetailsController.canEdit" value="office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupVersions"
							on-click="office365PlanDetailsController.oneDrivePropUpdate(data, 'backupVersions')"></cv-toggle>
							<span data-ng-if="!office365PlanDetailsController.canEdit">{{::office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupVersions ? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<li class="group" data-ng-if="office365PlanDetailsController.enableOneNoteBackup">
						<span class="pageDetailColumn"> <cv:msg key="label.backupOneNote" bundle="office365"/> </span>
						<span class="pageDetailColumn">
	 						<cv-toggle data-ng-if="office365PlanDetailsController.canEdit" value="office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupOneNote"
							on-click="office365PlanDetailsController.oneDrivePropUpdate(data, 'backupOneNote')"></cv-toggle>
							<span data-ng-if="!office365PlanDetailsController.canEdit">{{::office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.onedrivebackupPolicy.backupOneNote ? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<li data-ng-repeat="filter in office365PlanDetailsController.plan.planInfo.oneDriveFilterDetails.filters">
						<span>
							<ul>
								<li class="group" data-ng-if="filter.includeFilter">
									<span class="pageDetailColumn" >{{filter.includeFilter.displayName}}</span></span>
									<span class="pageDetailColumn" ng-if="filter.includeFilter.patternsSelected.length > 0">
										<span data-ng-repeat="pattern in filter.includeFilter.patternsSelected">
											<span data-uib-tooltip="{{pattern}}" data-tooltip-placement="bottom left" data-ng-bind="pattern" ng-if ="pattern != '*'">
											</span>
											<span data-tooltip-placement="bottom left" ng-if ="pattern == '*'">
												<cv:msg key='label.allContents' bundle='profiles'/>
											</span>
											<span data-ng-if="!$last">,</span>
										</span>
									</span>
									<span class="pageDetailColumn" ng-if="filter.includeFilter.patternsSelected.length === 0">
										<span><cv:msg key='label.allContents' bundle='profiles'/></span>
									</span>
								</li>
								<li class="group">
									<span class="pageDetailColumn" >{{filter.excludeFilter.displayName}}</span></span>
									<span class="pageDetailColumn" ng-if="filter.excludeFilter.patternsSelected.length > 0">
										<span data-ng-repeat="pattern in filter.excludeFilter.patternsSelected">
											<span data-uib-tooltip="{{pattern}}" data-tooltip-placement="bottom left" data-ng-bind="pattern">
											</span>
											<span data-ng-if="!$last">,</span>
										</span>
									</span>
									<span class="pageDetailColumn" ng-if="filter.excludeFilter.patternsSelected.length === 0">
										<span><cv:msg key='label.none' bundle='profiles'/></span>
									</span>
								</li>
							</ul>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
					<a href="" data-ng-if="office365PlanDetailsController.canEdit == true"
					data-ng-click="office365PlanDetailsController.plan.openEditOneDriveBackupSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div>
			</cv-tile-component>

			<!-- Sharepoint Tile -->
			<cv-tile-component data-ac-id="office365MailboxPlanDetails-label_archiveMailboxTypes-exchange"  data-ng-if="office365PlanDetailsController.getAppBasedModes.showSharepointTile" data-title="<cv:msg key="label.sharepoint" bundle="profiles" />">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"> <cv:msg key="label.backupFileVersion" bundle="office365"/> </span>
						<span class="pageDetailColumn">
	 						<cv-toggle data-ng-if="office365PlanDetailsController.canEdit" value="office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.spbackupPolicy.backupVersions"
							on-click="office365PlanDetailsController.sharepointPropUpdate(data, 'backupVersions')"></cv-toggle>
							<span data-ng-if="!office365PlanDetailsController.canEdit">{{::office365PlanDetailsController.plan.planInfo.office365Info.o365CloudOffice.caBackup.detail.cloudAppPolicy.backupPolicy.spbackupPolicy.backupVersions ? 'label.enabled' : 'label.disabled' | cvLoc}}</span>
						</span>
					</li>
					<!-- <li data-ng-repeat="filter in office365PlanDetailsController.plan.planInfo.sharepointFilterDetails.filters">
						<span>
							<ul>
								<li class="group">
									<span class="pageDetailColumn" ><cv:msg key="label.include" bundle="profiles"/> <span ng-bind="filter.displayName"> </span></span>
									<span class="pageDetailColumn" ng-if="filter.includeFilter.patternsSelected.length > 0">
										<span data-ng-repeat="pattern in filter.includeFilter.patternsSelected">
											<span data-uib-tooltip="{{pattern}}" data-tooltip-placement="bottom left" data-ng-bind="pattern" ng-if ="pattern != '*'">
											</span>
											<span data-tooltip-placement="bottom left" ng-if ="pattern == '*'">
												<cv:msg key='label.allContents' bundle='profiles'/>
											</span>
											<span data-ng-if="!$last">,</span>
										</span>
									</span>
									<span class="pageDetailColumn" ng-if="filter.includeFilter.patternsSelected.length === 0">
										<span><cv:msg key='label.allContents' bundle='profiles'/></span>
									</span>
								</li>
								<li class="group">
									<span class="pageDetailColumn" ><cv:msg key="label.exclude" bundle="profiles"/> <span ng-bind="filter.displayName"> </span></span>
									<span class="pageDetailColumn" ng-if="filter.excludeFilter.patternsSelected.length > 0">
										<span data-ng-repeat="pattern in filter.excludeFilter.patternsSelected">
											<span data-uib-tooltip="{{pattern}}" data-tooltip-placement="bottom left" data-ng-bind="pattern">
											</span>
											<span data-ng-if="!$last">,</span>
										</span>
									</span>
									<span class="pageDetailColumn" ng-if="filter.excludeFilter.patternsSelected.length === 0">
										<span><cv:msg key='label.none' bundle='profiles'/></span>
									</span>
								</li>
							</ul>
						</span>
					</li> -->
				</ul>
				<!-- <div class="page-details-box-links">
					<a href="" data-ng-if="office365PlanDetailsController.canEdit == true"
					data-ng-click="office365PlanDetailsController.plan.openEditSharepointBackupSettingsModal()">
						<cv:msg key="action.edit" bundle="profiles" />
					</a>
				</div> -->
			</cv-tile-component>
		</div>
	</div>
	<!-- End Content Indexing Tile -->
</div>
