<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div data-ng-if="model.readOnly">
    <ul class="list-style-secondary">
        <li class="group" data-ng-if="model.targetApp !== model.ServiceTypes.FileSystem">
            <span class="pageDetailColumn">{{'label.dcPlanFilters' | cvLoc }}</span>
            <span class="pageDetailColumn" data-ng-if="model.enableContentFilter">{{'label.enabled' | cvLoc}}</span>
            <span class="pageDetailColumn" data-ng-if="!model.enableContentFilter">{{'label.disabled' | cvLoc}}</span>
        </li>
        <li class="group" data-ng-if="model.enableContentFilter">
            <span class="pageDetailColumn">
                <cv:msg key="label.includeFileTypes" bundle="profiles" />
            </span>
            <span class="pageDetailColumn">
                {{model.includeDocTypes | arrayToString }}
                <span data-ng-if="model.includeDocTypes.length == 0">
                    <cv:msg key='label.none' bundle='ediscovery' />
                </span>
            </span>
        </li>
        <li class="group" data-ng-if="model.enableContentFilter">
            <span class="pageDetailColumn">
                <cv:msg key="label.excludePaths" bundle="profiles" />
            </span>
            <span class="pageDetailColumn">
                {{model.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths | arrayToString }}
                <span data-ng-if="!model.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths">
                    <cv:msg key='label.none' bundle='ediscovery' />
                </span>
            </span>
        </li>
        <li class="group" data-ng-if="model.enableContentFilter">
            <span class="pageDetailColumn">
                <cv:msg key="label.minimumDocumentSize" bundle="profiles" />
            </span>
            <span class="pageDetailColumn">{{model.ciPolicy.detail.ciPolicy.filters.fileFilters.minDocSize }}<span> MB</span></span>
        </li>
        <li class="group" data-ng-if="model.enableContentFilter">
            <span class="pageDetailColumn">
                <cv:msg key="label.maximumDocumentSize" bundle="profiles" />
            </span>
            <span class="pageDetailColumn">{{model.ciPolicy.detail.ciPolicy.filters.fileFilters.maxDocSize }}<span> MB</span></span>
        </li>
        <li class="group" data-ng-if="model.enableContentFilter && model.showCopyPrecedence">
            <span class="pageDetailColumn">{{'label.copyPrecedence' | cvLoc }}</span>
            <span class="pageDetailColumn">{{ model.ciPolicy.detail.ciPolicy.copyPrecedence }}</span>
        </li>
    </ul>
</div>
<div data-ng-if="!model.readOnly">
    <div class="file-filter-heading col-lg-12" data-ng-if="!model.enableContentFilter">
        <div class="col-xs-12" >
            <input id="enableCIPolicy" type="checkbox" data-ng-disabled="!model.ciPolicy.detail.ciPolicy.opType"
                data-ng-model="model.enableContentFilter"/> <label
                for="enableCIPolicy">{{'label.enableContentIndexing'
            | cvLoc}}</label>
            <cv-help-component data-ng-if="!model.ciPolicy.detail.ciPolicy.opType"
                help-text='<cv:msg key="error.contentIndexingMandatory" bundle="profiles" />'></cv-help-component>
        </div>
    </div>
    <div data-ng-if="model.enableContentFilter && model.planConfiguration[model.targetApp].advancedOptions.display">
        <div class="file-filter-heading col-lg-12">
            <h4>
                <cv:msg key="label.includeFileTypes" bundle="profiles" />
                <cv-help-component data-ng-if="model.targetApp !== model.ServiceTypes.FileSystem" help-text='<cv:msg key="label.includeFileTypesDescription" bundle="profiles" />' help-placement="right"></cv-help-component>
                <cv-help-component data-ng-if="model.targetApp === model.ServiceTypes.FileSystem" help-text='<cv:msg key="label.includeFileTypesDescriptionNoEE" bundle="profiles" />' help-placement="right"></cv-help-component>
            </h4>
        </div>
        <div class="col-lg-11 col-lg-offset-1">
            <div class="row form-group">
                <label class="col-lg-10" for="includeFolderName">
                <input type="text" name="includeFolderName" id="includeFolderName" data-ng-model="model.includeItemName"  placeholder="<cv:msg key="label.enterFileExtension" bundle="profiles" />" autofocus data-ng-click="model.includePathNotValid=false"/>
                <span class="error" data-ng-show="model.includePathNotValid">{{model.includeErrorMessage}}</span>
                </label>
                <div class="col-lg-1 file-add-item">
                    <a href="" data-ng-click="model.addItem('includes')">
                        <cv:msg key="action.add" bundle="profiles" />
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="filters-list-wrapper col-md-11">
                    <ul
                        data-ng-repeat="folder in model.includeDocTypes | orderBy track by $index">
                        <li title="{{folder | trimFolderName}}">
                            <span
                                class="content-library-file">
                                <label for="windows-{{folder}}"
                                    class="ellipsis-parent ellipsis-content">
                                    {{folder |
                                    trimFolderName}} 
                                    <span data-ng-if="folder == '\\'" class='laptop-content-help-text'>
                                        <cv:msg key='label.allContents' bundle='profiles' />
                                    </span>
                                </label>
                                <span class="delete-row"><a
                                    data-ng-click="model.removeItem(folder,'includes')"
                                    title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{folder | trimFolderName}}"><span class="k-icon k-i-close"></span></a></span>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div data-ng-if="model.planConfiguration[model.targetApp].advancedOptions.display">
        <div class="file-filter-heading col-lg-12">
            <h4>
                <cv:msg key="label.excludePaths" bundle="profiles" />
                <cv-help-component
                    help-text='<cv:msg key="label.excludePathsDescription" bundle="profiles" />' help-placement="right"></cv-help-component>
            </h4>
        </div>
    <div class="col-lg-11 col-lg-offset-1">
                <div class="row form-group">
                    <label class="col-md-10" for="excludeFolderName">
                    <input type="text" name="excludeFolderName" id="excludeFolderName" data-ng-model="model.excludeItemName"  placeholder="<cv:msg key="label.enterPath" bundle="profiles" />" data-ng-click="model.excludePathNotValid=false"/>
                    <span class="error" data-ng-show="model.excludePathNotValid">{{model.excludeErrorMessage}}</span>
                    </label>
                    <div class="col-md-1 file-add-item">
                        <a href=""
                            data-ng-click="model.addItem('excludes')">
                            <cv:msg key="action.add" bundle="profiles" />
                        </a>
                    </div>
                </div>
                <div class="row">
                    <div class="filters-list-wrapper col-md-11">
                        <ul data-ng-repeat="exclude in model.ciPolicy.detail.ciPolicy.filters.fileFilters.excludePaths | orderBy track by $index">
                            <li title="{{exclude}}">
                                <span class="content-library-folder" >
                                <label for="windows-{{exclude}}"
                                    class="ellipsis-parent ellipsis-content">{{exclude |
                                trimFolderName}} </label> <span class="delete-row"><a
                                    data-ng-click="model.removeItem(exclude,'excludes')"
                                    title="<cv:msg key='label.removeContent' bundle='collectionsJs' /> {{exclude | trimFolderName}}"><span class="k-icon k-i-close"></span></a></span>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
    </div>
    <div>
        <div class="col-lg-12" data-ng-class="{'file-filter-heading': model.planConfiguration[model.targetApp].advancedOptions.display}">
            <h4>
                <cv:msg key="label.documentSize" bundle="profiles" />
                <cv-help-component
                    help-text='<cv:msg key="label.fileSizeDescription" bundle="profiles" />' help-placement="right"></cv-help-component>
            </h4>
        </div>
        <div class="col-lg-11 col-lg-offset-1">
            <div class="form-group row">
                <label class="col-xs-12 col-lg-3" for="minimumDocumentSize">
                    <cv:msg key="label.minimum" bundle="profiles" />
                </label>
                <div class="col-xs-12 col-lg-9">
                    <input type="number" name="minimumDocumentSize"
                        min="0" step="1" max="{{(model.ciPolicy.detail.ciPolicy.filters.fileFilters.maxDocSize || model.maxDocSize) - 1}}"
                        data-ng-model="model.ciPolicy.detail.ciPolicy.filters.fileFilters.minDocSize"
                        id="minimumDocumentSize" />
                    <span>MB</span>
                    <span class="help-block" data-ng-show="formCtrl.minimumDocumentSize.$invalid">
                        <cv:msg key='error.cannotExceed' bundle='profiles' />
                        {{model.ciPolicy.detail.ciPolicy.filters.fileFilters.maxDocSize}}MB
                    </span>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-xs-12 col-lg-3" for="maximumDocumentSize">
                    <cv:msg key="label.maximum" bundle="profiles" />
                </label>
                <div class="col-xs-12 col-lg-9">
                    <input type="number" name="maximumDocumentSize"
                        min="0" step="1" max="{{model.maxDocSize}}"
                        data-ng-model="model.ciPolicy.detail.ciPolicy.filters.fileFilters.maxDocSize"
                        id="maximumDocumentSize" />
                    <span>MB</span>
                    <span class="help-block" data-ng-show="formCtrl.maximumDocumentSize.$invalid">
                        <cv:msg key='error.cannotExceed' bundle='profiles' />
                        {{model.maxDocSize}}MB
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row margin-top-30" data-ng-if="model.showCopyPrecedence">
        <label for="enableCopyPrecedence" class="col-lg-3" >{{'label.copyPrecedence' | cvLoc}}</label>
        <div class="col-xs-12 col-lg-9">
            <input id="enableCopyPrecedence" type="number" data-ng-disabled="!model.ciPolicy.detail.ciPolicy.opType" min="0" max="9" placeholder="0"
                data-ng-model="model.copyPrecedence" data-ng-change="model.copyPrecedenceChanged()" />
            <cv-help-component data-ng-if="!model.ciPolicy.detail.ciPolicy.opType"
                help-text='<cv:msg key="error.contentIndexingMandatory" bundle="profiles" />'></cv-help-component>
        </div>
    </div>
</div>