<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>

<div class="setup-title" >
	<h1>
		<span ng-if="createExchArchivingPlanCtrl.isOffice365SaaSTenant">
			<cv-help-text id="exchangePlan" help-label="label.createExchangePlan" help-text="info.createUserMailboxPlan" use-icon="true" />
		</span>
		<span ng-if="!createExchArchivingPlanCtrl.isOffice365SaaSTenant">
			<cv-help-text id="exchangeArchivingPlan" help-label="label.createExchangeArchivingPlan" help-text="info.createUserMailboxPlan" use-icon="true" />
		</span>
	</h1>
</div>
<div class="setup-content">
	<div class="bootstrap-wrapper">
		<form name="addExchangeArchivingPlanForm" novalidate data-cv-submit="createExchArchivingPlanCtrl.create()" autocomplete="off">
			<div class="padding-left-15 padding-right-15" data-ng-if="!createExchArchivingPlanCtrl.isOffice365SaaSTenant">
				<div class="form-group row">
					<label class="col-xs-12 col-md-5" for="planName"><cv:msg
							key="label.profileName" bundle="profiles" /></label>
					<div class="col-xs-12 col-md-7">
						<input type="text" name="planName"
							autofocus required
							data-ng-class="{'has-error': cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)}"
							data-ng-model="createExchArchivingPlanCtrl.plan.planInfo.summary.plan.planName"
							id="planName" />
						<div class="help-block"
							data-ng-show="cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.noProfileName" bundle="profiles" />
						</div>
					</div>
				</div>
				<div class="form-group text-left">
					<cv-toggle toggle-label="{{'label.enableArchivingonArchiveMailbox' | cvLoc}}" value="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox"
						toggle-model="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox"></cv-toggle>
				</div>
			</div>
			<div class="padding-left-15 padding-right-15" data-ng-if="createExchArchivingPlanCtrl.isOffice365SaaSTenant">
				<div class="form-group row">
					<label class="col-xs-12 col-md-5" for="planName"><cv:msg
							key="label.profileName" bundle="profiles" /></label>
					<div class="col-xs-12 col-md-7">
						<div class="input-group">
							<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
								data-ng-bind="createExchArchivingPlanCtrl.exchangePlanPrefix"></span>
							<input type="text" name="planName"
								autofocus required
								placeholder='&nbsp;&nbsp;<cv:msg key="placeholder.planName" bundle="office365"/>'
								data-ng-class="{'has-error': cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)}"
								data-ng-model="createExchArchivingPlanCtrl.saas_planName"
								id="planName" />
						</div>
						<div class="help-block"
							data-ng-show="cv.addExchangeArchivingPlanForm.needsAttention(addExchangeArchivingPlanForm.planName)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.noProfileName" bundle="profiles" />
						</div>
					</div>
				</div>		
			</div>		
		<div data-ng-if="!createExchArchivingPlanCtrl.isOffice365SaaSTenant">
			<div class="panel panel-default">
				<div class="padding-left-15 padding-right-15">
					<h4><cv:msg key="label.retentionSettings" bundle="profiles" /></h4>
					<cv-exchange-plan-retention data-retention-policy="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbRetention.detail.emailPolicy.retentionPolicy" data-is-archiving-mailbox="true" data-is-office365-plan="false"></cv-exchange-plan-retention>
				</div>
			</div>
			<cv-plain-accordion accordion-label="label.cleanupSettings">
				<div class="panel panel-default">
					<div class="padding-left-15 padding-right-15">
						<cv-exchange-plan-cleanup-messages data-cleanup-policy="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbCleanup.detail.emailPolicy.cleanupPolicy"
							data-archive-policy="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.archiveMailbox"
							data-is-edit="false"></cv-exchange-plan-cleanup-messages>
					</div>
				</div>
			</cv-plain-accordion>
  			<cv-plain-accordion accordion-label="label.searchSettings">
				<div class="panel panel-default">
					<div class="padding-left-15 padding-right-15">
						<cv-exchange-plan-content-indexing
							data-content-index-props="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbArchiving.detail.emailPolicy.archivePolicy.contentIndexProps"
							data-ee-policy="createExchArchivingPlanCtrl.plan.planInfo.eePolicy" data-is-edit="false" data-show-data="createExchArchivingPlanCtrl.showData"></cv-exchange-plan-content-indexing>
					</div>
				</div>
			</cv-plain-accordion>
		</div>
		<!--Plan for SaaS config-->
		<div class="panel panel-default" data-ng-if="createExchArchivingPlanCtrl.isOffice365SaaSTenant">
			<div class="padding-left-15 padding-right-15">
				<h4 class="margin-left-10"><cv:msg key="label.retentionSettings" bundle="profiles"/></h4>
				<cv-exchange-plan-retention data-retention-policy="createExchArchivingPlanCtrl.plan.planInfo.exchange.mbRetention.detail.emailPolicy.retentionPolicy" data-is-archiving-mailbox="true"></cv-exchange-plan-retention>
			</div>
		</div>
		<!--Plan for SaaS config-->
			<div class="button-container">
				<button id="createUserMailboxPlan_button_#8731" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="createExchArchivingPlanCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button>
				<button id="createUserMailboxPlan_button_#1945" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button>
			</div>
		</form>
	</div>
</div>