<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div data-ng-if="model.readOnly">
	<ul class="list-style-secondary">
		<li class="group">
			<span class="pageDetailColumn">{{'label.entityDetection' | cvLoc }}</span>
			<span class="pageDetailColumn" data-ng-if="model.enableEEPolicy">{{'label.enabled' | cvLoc}}</span>
			<span class="pageDetailColumn" data-ng-if="!model.enableEEPolicy">{{'label.disabled' | cvLoc}}</span>
		</li>
		<li class="group" data-ng-if="model.enableEEPolicy"><span class="pageDetailColumn"><cv:msg key="label.contentAnalyzer" bundle="ediscovery" /></span>
						 <span class="pageDetailColumn">{{model.selectedContentAnalyzer[0].cloudName}}<span data-ng-if="!model.selectedContentAnalyzer[0]" class='laptop-content-help-text less-padding'>{{'label.none' | cvLoc }}</span></span></li>
		<li class="group" data-ng-if="model.enableEEPolicy">
			 <cv-plan-dcpolicy-entities read-only="true" label-position="col-xs-12 col-md-6 col-lg-6 no-left-padding pageDetailColumn" control-position="col-xs-12 col-md-6 col-lg-6 no-left-padding"
					dc-policy="model.eePolicy"></cv-plan-dcpolicy-entities>
		</li>
	</ul>
</div>
<div data-ng-if="!model.readOnly">
	<div class="form-group">
		<div class="col-xs-12" data-ng-if="!model.hideEECheckBox">
			<input id="enableEEPolicy" type="checkbox" data-ng-model="model.enableEEPolicy" data-ng-change="enablePolicyChanged()" />
			<label for="enableEEPolicy">{{'label.entityDetection' | cvLoc}}</label>
		</div>
	</div>
<div data-ng-if="model.enableEEPolicy">
	<div class="form-group" data-ng-if="model.errorMsg">
		{{errorMsg}}
	</div>
	<div class="form-group">
		<label class="col-xs-12 col-lg-3 col-md-3"><cv:msg key="label.contentAnalyzer" bundle="ediscovery" /></label>
		<div class="col-xs-12 col-lg-9 col-md-9">
			<isteven-multi-select
			input-model="model.contentAnalyzers"
			output-model="model.selectedContentAnalyzer"
			button-label="cloudName"
			item-label="cloudName"
			tick-property="selected"
			directive-id="contentAnalyzer"
			translation="model.localLang"
			selection-mode="single"
			helper-elements="filter"
			is-required="true">
			</isteven-multi-select>
			<input type="text" ng-model="model.selectedContentAnalyzer" name="selectedContentAnalyzer" style="display:none" required />

			<div class="help-block" data-ng-if="submitCtrl.needsAttention(formCtrl.selectedContentAnalyzer) && formCtrl.selectedContentAnalyzer.$error.required">
				<i class="ion-alert-circled"></i>
				<cv:msg key="error.noContentAnalyzerSelected" bundle="ediscovery" />
			</div>
		</div>
	</div>
	<div class="form-group">
		<cv-plan-dcpolicy-entities label-position="col-xs-12 col-lg-3 col-md-3"
								control-position="col-xs-12 col-lg-9 col-md-9" dc-policy="model.eePolicy">
		</cv-plan-dcpolicy-entities>
	</div>
</div>
</div>