<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="Ida.ContentIndexOpType"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1>
		<span data-ng-if="configType === 'eePolicy'"><cv:msg key="label.entityDetection" bundle="ediscovery"/></span>
		<span data-ng-if="configType === 'ciPolicy'"><cv:msg key="label.contentIndexing" bundle="ediscovery"/></span>
		<span data-ng-if="configType === 'policyFilters'"><cv:msg key="label.assets.database.advancedOptions" bundle="ediscovery"/></span>
	</h1>
</div>
<div class="row bootstrap-wrapper">
	<form name="editDCPlan" cv-hide-api data-cv-submit="saveEdiscoveryConfig()" >
	<div class="panel panel-default">
		<div class="panel-body">
			<div class="{{generalSetupMessage.type}} serverMessage margin-left-10">{{generalSetupMessage.message}}</div>
			<div class="margin-left-10" data-ng-if="configType === 'eePolicy'" >
				<cv-plan-ee-policy
				ee-policy="eePolicy"
				ediscovery-info="ediscoveryInfoCopy"
				ci-policy="ciPolicy"
				hide-e-e-check-box="ediscoveryInfo.hideEECheckBox">
				</cv-plan-ee-policy>
			</div>
			<cv-plan-ci-policy
			data-ng-if="configType === 'ciPolicy'"
			ci-policy="ciPolicy"
			plan-configuration="ediscoveryInfo.planConfiguration"
			target-app="ediscoveryInfo.targetAppType">
			</cv-plan-ci-policy>
			<div class="margin-left-10" data-ng-if="configType === 'policyFilters'" >
				<cv-plan-dcpolicy-filefilters
					ci-policy="ciPolicy"
					target-app="ediscoveryInfo.targetAppType"
					plan-configuration="ediscoveryInfo.planConfiguration">
				</cv-plan-dcpolicy-filefilters>
			</div>
	     </div>
     </div>
	<div class="button-container">
		<button id="editDCPlan_button_#5450" type="button"
			class="btn btn-default cvBusyOnAjax setup-btn--hidden"
			data-ng-click="cancel()">
			<cv:msg key="action.cancel" bundle="profiles" />
		</button>
		<button id="editDCPlan_button_#9986" type="submit" class="btn btn-primary cvBusyOnAjax"
			data-ng-disabled="disableNext">
			<cv:msg key="action.save" bundle="profiles" />
		</button>
	</div>
	</form>
</div>