<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sendLogs"></cv:cvMessages>
</script>
<div class="setup-content database-plan-content" data-ng-controller="createDatabasePlanController as planCtrl" data-ng-class="model.currentRoute === '/createDCPlan' ? 'medium-width' : 'setup-content database-plan-content'">
	<div>
		<h1 class="margin-bottom-20">
			<cv:msg key="label.addDatabasePlan" bundle="profiles" />
			<cv-help-component help-text="<cv:msg key="label.addDatabasePlanHelpText" bundle="profiles" />"></cv-help-component>
		</h1>
	</div>
	<div class="{{planCtrl.generalMessage.type}} serverMessage">
		{{planCtrl.generalMessage.message}}
	</div>
	<form data-ng-hide="hideAddDomainForm" name="addPlan" data-cv-submit="planCtrl.createPlan()" autocomplete="off">
		<!-- // name // -->
		<div class="plan-wrapper">
			<div class="cc-row row">
				<div class="cc-wrapper col-md-6 margin-left-15">
					<label for="planName" class="cc-label">
						<span class="cc-label-span">
							<cv:msg key="label.profileName" bundle="profiles" />
						</span>
					</label>
					<input class="cc-input-text" type="text" id="planName" name="planName" data-ng-model="planCtrl.planInfo.summary.plan.planName"
						  data-autoselect="{{planCtrl.autoSelect}}" autofocus />
					<span class="help-block" data-ng-show="planCtrl.showNameExistsError">
						<cv:msg key="error.nameExisted" bundle="profiles" />
					</span>
				</div>
			</div>
		</div>
		<!-- // data storage configuration start // -->
		<div class="plan-wrapper" >
			<uib-accordion close-others="true" class="text-left">
			    <div uib-accordion-group is-open="planCtrl.dataModel.openState">
				   	 <uib-accordion-heading>
				        <cv:msg key="label.dataStorageConfig" bundle="profiles" /><i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': planCtrl.dataModel.openState, 'glyphicon-chevron-right': !planCtrl.dataModel.openState}"></i>
				      </uib-accordion-heading>
					<cv-storage-schedule-component
						title='<cv:msg key="label.dataStorageConfig" bundle="profiles" />'
						model = 'planCtrl.dataModel' >
					</cv-storage-schedule-component>
			</div>
			</uib-accordion>
		</div>
		<!-- // data storage configuration ends // -->
		<!-- // log storage configuration start // -->
		<div class="plan-wrapper" >
			<uib-accordion class="text-left">
			    <div uib-accordion-group is-open="planCtrl.logModel.openState" >
			   	 <uib-accordion-heading>
			        <cv:msg key="label.logStorageConfig" bundle="profiles" /><i class="pull-right glyphicon" data-ng-class="{'glyphicon-chevron-down': planCtrl.logModel.openState, 'glyphicon-chevron-right': !planCtrl.logModel.openState}"></i>
			      </uib-accordion-heading>
					<cv-storage-schedule-component
						title='<cv:msg key="label.logStorageConfig" bundle="profiles" />'
						model = 'planCtrl.logModel' >
					</cv-storage-schedule-component>
				</div>
			</uib-accordion>
		</div>
		<!-- // log storage configuration ends // -->
		<div class="bottom-button-container">
			<button id="createDatabasePlan_button_#7185" data-ng-disabled="planCtrl.disableButtons" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<span><cv:msg key="Save" bundle="messages" /></span>
			</button>
		</div>
	</form>
	<div data-ng-show="hideAddDomainForm" class="centered button-container">
		<p class="serverMessage">{{plansPresentMessage.message}}</p>
		<p class="serverMessage"><cv:msg key="info.addPlanTodbServers" bundle="dbs" /></p>
		<a type="button" class="extra-spacing" data-ng-click="changeToAddDBPlan()"><cv:msg key="label.addMore" bundle="servers" /></a>
		<button id="createDatabasePlan_button_#4287" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skipStep()"><cv:msg key="label.continue" bundle="profiles" /></button> 
	</div>
</div>
