<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div data-ng-if="model.readOnly">
		<ul class="list-style-secondary">			
			<li class="group">
				<span class="pageDetailColumn"><cv:msg key="label.search" bundle="profiles" /></span>
				<span class="pageDetailColumn" data-ng-if="model.ciPolicy.detail.ciPolicy.opType == 'METADATA'">{{'label.metadataonly' | cvLoc}}</span>
				<span class="pageDetailColumn" data-ng-if="model.ciPolicy.detail.ciPolicy.opType != 'METADATA'">{{'label.metadataandcontent' | cvLoc}}</span>
			</li>			
			<li class="group" data-ng-if="model.ciPolicy.detail.ciPolicy.opType === 'METADATA_CONTENT_PREVIEW'">
				<span class="pageDetailColumn">{{'label.uncPath' | cvLoc}}</span>
				<span class="pageDetailColumn">{{model.ciPolicy.detail.ciPolicy.previewPath.path}}</span>
			</li>
			<li class="group" data-ng-if="model.ciPolicy.detail.ciPolicy.opType === 'METADATA_CONTENT_PREVIEW'">
				<span class="pageDetailColumn"><cv:msg key="label.userName" bundle="ediscovery" /></span>
				<span class="pageDetailColumn">{{model.ciPolicy.detail.ciPolicy.previewPath.userAccount.domainName}}\{{model.ciPolicy.detail.ciPolicy.previewPath.userAccount.userName}}</span>
			</li>
			<li class="group" data-ng-if="model.targetApp === model.ServiceTypes.CaseManager  && model.showExactSearch">
				<span class="pageDetailColumn"><span>
						<cv:msg key="label.exactSearch" bundle="exchange" /></span></span>
				<span class="pageDetailColumn"
					data-ng-if="model.ciPolicy.detail.ciPolicy.enableExactSearch">{{'label.enabled' | cvLoc}}</span>
				<span class="pageDetailColumn"
					data-ng-if="!model.ciPolicy.detail.ciPolicy.enableExactSearch">{{'label.disabled' | cvLoc}}</span>
			</li>
			<li class="group" data-ng-if="model.targetApp !== model.ServiceTypes.FileSystem">
				<span class="pageDetailColumn"><span>{{'label.enableOCR' | cvLoc }}</span></span>
				<span class="pageDetailColumn" data-ng-if="model.ciPolicy.detail.ciPolicy.enableImageExtraction">{{'label.enabled' | cvLoc}}</span>
				<span class="pageDetailColumn" data-ng-if="!model.ciPolicy.detail.ciPolicy.enableImageExtraction">{{'label.disabled' | cvLoc}}</span>
			</li>
			<li class="group" data-ng-if="model.ciPolicy.detail.ciPolicy.enableImageExtraction && model.targetApp !== model.ServiceTypes.FileSystem">
				<span class="pageDetailColumn"><span>{{'label.ocrLanguage' | cvLoc }}</span></span>
				<span class="pageDetailColumn">{{getLanguage()}}</span>
			</li>
			<li class="group" data-ng-if="model.enableDCPlanSchedule">
				<span class="pageDetailColumn"><cv:msg key="label.schedule" bundle="ediscovery" /></span>
				<span class="pageDetailColumn">
					<schedule entity-id="model.genericEntity.entityId" entity-name="model.genericEntity.entityName" entity-type="'PLAN_ENTITY'" schedule-obj="model.schedule" on-save="updateSchedule(schedule, successCallback, errorCallback)"></schedule>
				</span>
			</li>
		</ul>
</div>
<div data-ng-if="!model.readOnly">	
			<div class="form-group">
				<div class="col-xs-12 padding-top-20 padding-bottom-30" data-ng-if="model.enableDCPlanSchedule">
					<label class="col-xs-12 col-lg-3 col-md-3 padding-left-0 no-margin"><cv:msg key="label.schedule" bundle="ediscovery" /></label>
					<div class="col-xs-12 col-lg-7 col-md-7 padding-left-10">
						<schedule entity-type="'PLAN_ENTITY'" on-save="updateSchedule(schedule, successCallback, errorCallback)"></schedule>
					</div>
				</div>

				<div class="col-xs-12" data-ng-if="model.planConfiguration[model.targetApp].contentIndexing.display">
					<input
						id="contentIndexing"
						type="checkbox"
						data-ng-click="toggleOpType()"
						data-ng-checked="model.ciPolicy.detail.ciPolicy.opType.includes('METADATA_CONTENT')"
						/>
					<label for="contentIndexing">
						<cv:msg key="label.indexFileContent" bundle="ediscovery" />
					</label>
					<cv-help-component	help-text='<cv:msg key="label.metadataandcontentDescription" bundle="profiles" />' help-placement="right"></cv-help-component>
				</div>

				<div class="col-xs-12" data-ng-if="model.targetApp === model.ServiceTypes.CaseManager && model.showExactSearch">
					<cv-toggle toggle-name="exactSearch" toggle-label="label.exactSearch"
						value="model.ciPolicy.detail.ciPolicy.enableExactSearch"></cv-toggle>
				</div>
										
				<div class="col-xs-12" data-ng-if="model.planConfiguration[model.targetApp].OCR.display">
					<cv-toggle
						toggle-name="OCR"
						toggle-label="label.enableOCR"
						help-text="'helpText.ocr.supportedFiles'"
						value="model.ciPolicy.detail.ciPolicy.enableImageExtraction"
						help-direction="right"
						on-click="languageValidity(data)"></cv-toggle>
				</div>
				<div class="col-xs-12" data-ng-if="model.ciPolicy.detail.ciPolicy.enableImageExtraction">
					<div class="form-group">
					<label class="col-xs-12 col-md-3"><cv:msg key="label.ocrLanguage" bundle="exchange" /></label>
					<div class="col-xs-12 col-md-7">
						<isteven-multi-select
						input-model="model.inputLanguages"
						output-model="model.selectedLanguages"
						button-label="name"
						item-label="name"
						tick-property="selected"
						directive-id="ocrLanguage"
						translation="localLang"
						selection-mode="single"
						on-item-click="setLanguage(data)"
						is-required="true">
						</isteven-multi-select>
					</div>
				</div>

			</div>
</div>
