<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title" >
	<h1><cv:msg key="label.addDatabasePlan" bundle="profiles"/></h1>
</div>
<div data-ng-controller="createPlanController as outerCtrl" data-ng-init="outerCtrl.init(planModelCtrl)" class="setup-content server-plan" >
 <div data-ng-controller="createDbPlanController as innerCtrl " data-ng-init="innerCtrl.init(outerCtrl)">
	<div class="{{outerCtrl.generalSetupMessage.type}} serverMessage">{{outerCtrl.generalSetupMessage.message}}</div>
	<p  class="{{innerCtrl.plansPresentMessage.type}} serverMessage">{{innerCtrl.plansPresentMessage.message}}</p>
	<p class="serverMessage">{{plansPresentMessage.message}}</p>
	<form data-ng-show="innerCtrl.showAddDomainForm" name="addServerPLanForm" data-cv-submit="outerCtrl.createPlan(innerCtrl)" novalidate autocomplete="off">
		
		<!-- // name // -->
		
			<div class="global-options remove-border-padding">	
			
				<label for="planName"><cv:msg key="label.profileName" bundle="profiles" />
					<input type="text" name="planName" data-ng-model="outerCtrl.globalTemplate.name" id="planName" data-ng-blur="outerCtrl.checkPlaneName(outerCtrl.globalTemplate.name)"  autofocus /> 
 				</label>
			
			</div>
		
	<h4><cv:msg key="label.storages" bundle="profiles"/></h4>	
		
		<!-- // primary storage // -->
		
		<div class="global-options remove-border-padding">
	
		<label for="primaryStorage" class="select-label"><cv:msg key="label.dataStorage" bundle="profiles"/>
				 	<select id="primaryStorage" name="primaryStorage" data-ng-model="outerCtrl.globalTemplate.storageInfo.storagePool"
						data-ng-options="sPool.storagePoolEntity as sPool.storagePoolEntity.storagePoolName for sPool in storagePools"  
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.primaryStorage)}">
						<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles"/></option>
					</select>
		</label>
		
		<label for="primaryStorage" class="select-label"><cv:msg key="label.logStorage" bundle="profiles"/>
				 	<select id="primaryStorage" name="primaryStorage" data-ng-model="outerCtrl.globalTemplate.storageInfo.logStoragePool"
						data-ng-options="sPool.storagePoolEntity as sPool.storagePoolEntity.storagePoolName for sPool in storagePools"  
							data-ng-class="{'has-error': cv.addServerPLanForm.needsAttention(addServerPLanForm.primaryStorage)}">
						<option value=""><cv:msg key="placeholder.selectStorage" bundle="profiles"/></option>
					</select>
		</label>
		</div>
		
		<!-- // retention period // -->
		
		<div class="global-options remove-border-padding collections-global-options add-server-plan">
		
 
			<label for="retention" class="infinite-retention-label"><cv:msg key="label.retentionDays" bundle="collections"/></label>
		
		<span><input id="retention" name="retention" type="number" min="0" data-ng-model="outerCtrl.globalTemplate.storageInfo.retentionInDays" class="storage-retention-input" /><cv:msg key="label.days" bundle="collectionsJs"/></span>
		<span class="help-block-top" data-ng-show="!showPlanSkip && cv.addServerPLanForm.needsAttention(addServerPLanForm.retention)"><cv:msg key="error.retentionPeriod" bundle="collections"/></span>
		 
		</div>
	
		
		<h4>
			<cv:msg key="label.schedule" bundle="schedule"/>
		
			 <a href="" data-ng-click="innerCtrl.addSchedule({},false)">
			 	<cv:msg key="label.addLogSchedule" bundle="profiles"/>
			 </a>
			 <a href="" data-ng-click="outerCtrl.addSchedule()">
			 	<cv:msg key="label.addSchedule" bundle="profiles"/>
			 </a>
		 </h4>
	
		 <div class="schedule-list">
			<ul class="add-schedule__List group" data-ng-repeat="schedule in outerCtrl.addedSchedules track by $index ">
				<li class="ellipsis-parent ellipsis-content "><a data-ng-click="outerCtrl.editSchedule(schedule)">{{schedule.name}}</a>
					<span class='parenthetical-text'>- <cv:msg key="label.dataSchedule" bundle="profiles"/>
					</span>
				</li>
			</ul>
			<ul class="add-schedule__List group" data-ng-repeat="schedule in innerCtrl.addedLogSchedules track by $index ">
				<li class="ellipsis-parent ellipsis-content "><a data-ng-click="innerCtrl.editSchedule(schedule)">{{schedule.name}}</a>
					<span class='parenthetical-text'>- <cv:msg key="label.logSchedule" bundle="profiles"/>
					</span>
				</li>
			</ul>
			
			<ul class="add-schedule__List group" data-ng-if="addedSchedules.length==0">
				<li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule"/> </li>
			</ul>
		</div>
		
		<div class="button-container">
			<button id="addDatabasePlan_button_#2675" type="button" data-ng-if="!planModelCtrl.isSetup" class="btn btn-default setup-btn--hidden" data-ng-click="planModelCtrl.cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			
			<button id="addDatabasePlan_button_#7150" type="button" data-ng-if="planModelCtrl.isSetup && planModelCtrl.showDoItLater" class="btn btn-default cvBusyOnAjax" data-ng-click="planModelCtrl.skip()"> 
					<cv:msg key="action.skip" bundle="profiles" />
			</button>
			
			<button id="addDatabasePlan_button_#2102" data-ng-disabled="outerCtrl.disableButtons" type="submit" class="btn btn-primary cvBusyOnAjax"> 
				<span ><cv:msg key="Save" bundle="messages" /> </span>
			</button>
		</div>
		
	</form>
	<div data-ng-hide="innerCtrl.showAddDomainForm" class="button-container centered">
		<a type="button" class="extra-spacing" data-ng-click="innerCtrl.changeToAddDBPlan()"><cv:msg key="label.addMore" bundle="servers"/></a>
		<button id="addDatabasePlan_button_#1488" type="button" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="planModelCtrl.skip()"><cv:msg key="label.continue" bundle="profiles"/></button> 
	</div>
</div>
</div>
