import { commonPlanModule } from 'common/js/modules';

var app = commonPlanModule;

// Input time in seconds and function returns output in the form HH:MM AM/PM

app.filter('toMeridianTime', function() {
	return function(seconds) {
		var meridian = 'AM';
		var time = moment().set({
			hours: 0,
			minutes: 0,
			seconds: seconds
		});
		var hours = time.hours();
		var minutes = time.minutes().toString();
		if (hours > 12) {
			hours = hours - 12;
			meridian = 'PM';
		} else if (hours == 12) {
			meridian = 'PM';
		} else if (hours == 0) {
			hours = 12;
		}

		if (time.minutes() < 10) {
			minutes = `0${time.minutes()}`;
		}
		var meridianTime = `${hours}:${minutes} ${meridian}`;
		return meridianTime;
	};
});

export default app;
