import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.factory('storageRuleModel', [
	'cvLoc',
	function(cvLoc) {
		/**
		 * Constructor
		 */
		function StorageRuleModel(model, firstTimeRun) {
			// Public properties, assigned to the instance ('self')
			var self = this;
			self.storageRules = {
				rules: []
			};
			self.summary = model.summary ? model.summary : {};
			for (let i = 0; i < model.rules.length; i++) {
				let rule = model.rules[i];
				let ruleObj = {
					retentionDays: rule.retentionDays ? rule.retentionDays : 30,
					rank: rule.rank ? rule.rank : 1,
					regions: rule.regions.region ? rule.regions : { region: [{ regionId: 0 }] },
					clientGroup: { clientGroupId: 0 },
					agents: {
						agent: [{ applicationId: 0 }]
					},
					rule: { ruleName: model.summary.plan.planName + '_Rule_' + rule.rank },
					storage: {
						copy: [],
						storagePool: {
							storagePoolId: rule.storagePool.storagePoolId,
							storagePoolName: rule.storagePool.storagePoolName
						},
						storagePolicy: {
							storagePolicyName: rule.regions.region ? rule.regions.region[0].regionName : ''
						}
					}
				};
				if (rule.rule && rule.rule.ruleId) {
					ruleObj.rule.ruleId = rule.rule.ruleId;
				}
				if (rule.copies) {
					for (let j = 0; j < rule.copies.length; j++) {
						let copyObj = {
							active: rule.copies[j].isActive,
							isDefault: rule.copies[j].isDefault,
							dedupeFlags: {},
							retentionRules: rule.copies[j].retentionRules
								? rule.copies[j].retentionRules
								: {
										retainBackupDataForDays: rule.copies[j].retentionDays ? rule.copies[j].retentionDays : 30
								  },
							StoragePolicyCopy: rule.copies[j].StoragePolicyCopy
								? rule.copies[j].StoragePolicyCopy
								: {
										copyName: rule.copies[j].name ? rule.copies[j].name : 'Primary'
								  },
							useGlobalPolicy: rule.copies[j].useGlobalPolicy
								? rule.copies[j].useGlobalPolicy
								: {
										storagePolicyId: rule.copies[j].storagePool.storagePoolId,
										storagePolicyName: rule.copies[j].storagePool.storagePoolName
								  },
							extendedFlags: {}
						};

						if (rule.copies[j].storagePoolType && rule.copies[j].storagePoolType === 'SECONDARY_COPY') {
							if (!rule.copies[j].isSnapCopy || rule.copies[j].isSnapCopy !== 'SET_TRUE') {
								if (!rule.copies[j].isDefault) {
									copyObj.globalAuxCopy = {
										storagePolicyId: rule.copies[j].storagePool.storagePoolId,
										storagePolicyName: rule.copies[j].storagePool.storagePoolName
									};
									copyObj.extendedFlags.useGlobalAuxCopyPolicy = 1;
									delete copyObj.useGlobalPolicy;
								} else {
									copyObj.extendedFlags.useGlobalStoragePolicy = 1;
								}
							}
						}

						copyObj.startTime = rule.copies[j].startTime;

						if (rule.copies[j].copyType && rule.copies[j].copyType === 2) {
							copyObj.copyType = 2;
							copyObj.selectiveCopyRules = rule.copies[j].selectiveCopyRules;
						}
						//send dedup properties only in case of primary storage with dedup pool type and for hyperscale storage
						if (rule.copies[j].storagePoolType === 'DEDUPLICATION' || rule.copies[j].storagePoolType === 'SCALE_OUT') {
							if (rule.copies[j].isDefault) {
								copyObj.dedupeFlags = {
									enableClientSideDedup: 1
								};
							}
							copyObj.storagePolicyFlags = {
								blockLevelDedup: 1
							};
							copyObj.dedupeFlags.useGlobalDedupStore = 1;
							copyObj.dedupeFlags.enableDeduplication = 1;
						} else if (
							(rule.copies[j].isSnapCopy && rule.copies[j].isSnapCopy === 'SET_TRUE') ||
							rule.copies[j].storagePoolType !== 'SECONDARY_COPY'
						) {
							copyObj.extendedFlags = { ...copyObj.extendedFlags, useGlobalStoragePolicy: 1 };
						}

						if (rule.copies[j].extendedFlags) {
							angular.merge(copyObj.extendedFlags, rule.copies[j].extendedFlags);
						}

						if (rule.copies[j].isSnapCopy && rule.copies[j].isSnapCopy === 'SET_TRUE') {
							copyObj.replPairList = rule.copies[j].replPairList;
							copyObj.regionMap = rule.copies[j].regionMap;
							copyObj.isSnapCopy = rule.copies[j].isSnapCopy;
							copyObj.isMirrorCopy = rule.copies[j].isMirrorCopy;

							if (rule.copies[j].sourceCopy) {
								copyObj.sourceCopy = rule.copies[j].sourceCopy;
							}
						}

						if (rule.copies[j].copyId) {
							copyObj.StoragePolicyCopy.copyId = rule.copies[j].copyId;
							copyObj.StoragePolicyCopy.storagePolicyId = rule.storagePolicy.storagePolicyId;
						}
						if (rule.storagePolicy) {
							copyObj.StoragePolicyCopy.storagePolicyId = rule.storagePolicy.storagePolicyId;
							copyObj.StoragePolicyCopy.storagePolicyName = rule.storagePolicy.storagePolicyName;
						}
						if (rule.copies[j].isDefault == 0) {
							if (!rule.rule) {
								copyObj.retentionRules.retainArchiverDataForDays = -1;
								copyObj.active = 1;
							}
							copyObj.copyType = rule.copies[j].copyType;
							delete copyObj.dedupeFlags.enableClientSideDedup;
						}
						copyObj.dedupeFlags.enableDASHFull = 1;
						ruleObj.storage.copy.push(copyObj);
					}
				}
				if (firstTimeRun.isFirstTime) {
					ruleObj.storage.storagePolicy.storagePolicyId = firstTimeRun.policyId;
				}
				self.storageRules.rules.push(ruleObj);
			}
		}

		/**
		 * Static method, assigned to class Instance ('self') is not available in static context
		 */
		StorageRuleModel.build = function(data, firstTimeRun) {
			return new StorageRuleModel(data, firstTimeRun);
		};
		/** TODO: needs to integrate to response , not using it right now ** */
		StorageRuleModel.apiRequestTransformer = function(requestData, firstTimeRun) {
			if (angular.isArray(requestData)) {
				return requestData.map(StorageRuleModel.build).filter(Boolean);
			}
			return StorageRuleModel.build(requestData, firstTimeRun);
		};
		/**
		 * Return the constructor function
		 */
		return StorageRuleModel;
	}
]);
export default planModule;
