import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.factory('storageCopyFactory', [
	'cvToaster',
	'cvLoc',
	'$log',
	'$state',
	'cvUtil',
	'storageService',
	'$uibModal',
	'storagePolicyService',
	'TapeConstants',
	'credentialManagerFactory',
	'CREDENTIAL_TYPE',
	'planRuleFactory',
	function storageFactory(
		cvToaster,
		cvLoc,
		$log,
		$state,
		cvUtil,
		storageService,
		$modal,
		storagePolicyService,
		TapeConstants,
		credentialManagerFactory,
		CREDENTIAL_TYPE,
		planRuleFactory
	) {
		var storageCopyFactory = {};

		storageCopyFactory.isExtendedRetentionValid = model => {
			let pass = true;

			if (model.enableExtendedRetention) {
				let infinite = false;
				const arrayToValidate = model.extendedRetention.filter(elem => !elem.isHide);
				arrayToValidate.forEach((elem, index) => {
					if (infinite) {
						model.extendedRetention[index].isEnabled = 0;
						return;
					}
					if (elem.isInfinite) {
						infinite = true;
					}
					if (elem.selected === '') {
						if (elem.isInfinite) {
							infinite = true;
							pass = false;
							model.extendedErrors.emptyError[index] = cvLoc('error.noRetention');
							return;
						} else {
							if (infinite) {
								model.extendedRetention[index].isEnabled = 0;
								return;
							} else {
								pass = false;
								model.extendedErrors.emptyError[index] = cvLoc('error.noRetention');
								return;
							}
						}
					}
				});
			}

			if (
				model.extendedErrors.hasRetError ||
				model.extendedErrors.hasTypError ||
				model.extendedErrors.hasMainRetError ||
				model.extendedErrors.hasMaxRetentionError
			) {
				pass = false;
			}
			return pass;
		};

		storageCopyFactory.getRetentionPeriodInDays = (type, retention) => {
			switch (type) {
				case 'YEARS':
					return retention * 365;
				case 'MONTHS':
					return parseInt(retention * 30.41); //one month was caculated as 30.41 days, eg. 3 months is 91 days, 5 months is 152 days. Will send 91 to backend if user selected 3 months
				case 'WEEKS':
					return retention * 7;
				case 'DAYS':
					return retention;
			}
		};

		storageCopyFactory.getVendorLabelMap = () => {
			return {
				NETAPP: cvLoc('label.vendor.netapp'),
				AMAZON: cvLoc('label.vendor.amazon'),
				MIXED: cvLoc('label.vendor.mixed'),
				NONE: cvLoc('label.vendor.generic')
			};
		};

		storageCopyFactory.getExtendedRetentionRules = model => {
			var extendedRetentionRules = {};

			if (!model.enableExtendedRetention) {
				model.extendedRetention.forEach(elem => {
					elem.isHide = true;
				});
			}

			let newExtendedRetention = model.extendedRetention.filter(elem => !elem.isHide);
			let isValid = true;
			let index = 0;
			if (!model.infiniteSelected || model.initialRetention > 0) {
				newExtendedRetention.forEach(elem => {
					const keyLabelIndex = index === 0 ? 'One' : index === 1 ? 'Two' : 'Three';
					const realKey = 'extendedRetentionRule' + keyLabelIndex;
					if (elem.selected !== '' && (isValid || model.initialRetention > index)) {
						extendedRetentionRules[realKey] = {
							isEnabled: model.infiniteSelected ? 0 : !isValid ? 0 : 1,
							rule: elem.result.rule,
							endDays: elem.isInfinite
								? -1
								: storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.result.endDays)
						};
					}
					isValid = isValid ? !elem.isInfinite : false;
					index += 1;
				});
				if (newExtendedRetention.length < model.initialRetention) {
					const emptyArray = model.extendedRetention.filter(elem => elem.isHide);

					while (index < model.initialRetention) {
						const elem = emptyArray.pop();
						const keyLabelIndex = index === 0 ? 'One' : index === 1 ? 'Two' : 'Three';
						const realKey = 'extendedRetentionRule' + keyLabelIndex;
						if (elem && elem.selected !== '') {
							extendedRetentionRules[realKey] = {
								isEnabled: 0,
								rule: elem.result.rule,
								endDays: elem.isInfinite
									? -1
									: storageCopyFactory.getRetentionPeriodInDays(elem.unitType, elem.result.endDays)
							};
						} else {
							extendedRetentionRules[realKey] = {
								isEnabled: 0
							};
						}
						index += 1;
					}
				}
			}

			return extendedRetentionRules;
		};

		storageCopyFactory.getSelectiveType = (type, ext = 'SELECTIVE') => {
			switch (type) {
				case 2:
					return { value: ext + '_ALLFULL', label: cvLoc('label.allFull') };
				case ext + '_ALLFULL':
					return { value: ext + '_ALLFULL', label: cvLoc('label.allFull') };
				case 4:
					return { value: ext + '_WEEK', label: cvLoc('label.weeklyFull') };
				case ext + '_WEEK':
					return { value: ext + '_WEEK', label: cvLoc('label.weeklyFull') };
				case 8:
					return { value: ext + '_MONTH', label: cvLoc('label.monthlyFull') };
				case ext + '_MONTH':
					return { value: ext + '_MONTH', label: cvLoc('label.monthlyFull') };
				case 16:
					return { value: ext + '_QUARTER', label: cvLoc('label.quarterlyFull') };
				case ext + '_QUARTER':
					return { value: ext + '_QUARTER', label: cvLoc('label.quarterlyFull') };
				case 32:
					return { value: ext + '_HALFYEAR', label: cvLoc('label.halfYearlyFull') };
				case ext + '_HALFYEAR':
					return { value: ext + '_HALFYEAR', label: cvLoc('label.halfYearlyFull') };
				case 64:
					return { value: ext + '_YEAR', label: cvLoc('label.yearlyFull') };
				case ext + '_YEAR':
					return { value: ext + '_YEAR', label: cvLoc('label.yearlyFull') };
				case 262144:
					return { value: ext + '_HOUR', label: cvLoc('label.hourlyFull') };
				case ext + '_HOUR':
					return { value: ext + '_HOUR', label: cvLoc('label.hourlyFull') };
				case 524288:
					return { value: ext + '_DAY', label: cvLoc('label.dailyFull') };
				case ext + '_DAY':
					return { value: ext + '_DAY', label: cvLoc('label.dailyFull') };
			}
		};

		storageCopyFactory.getRetentionRule = (retentionRule, originalRetentionRule) => {
			let selectiveType = storageCopyFactory.getSelectiveType(retentionRule.rule, 'EXTENDED');
			let isInfinite = originalRetentionRule.endDays === -1 ? true : false;
			retentionRule.rule = selectiveType.value;
			let unitInfo = storageCopyFactory.getAppropriateUnitType(
				originalRetentionRule.endDays === -1 ? 90 : retentionRule.endDays,
				isInfinite
			);
			retentionRule.endDays = unitInfo.qty;
			const obj = {
				isInfinite: isInfinite,
				selected: retentionRule.rule,
				retention: unitInfo.qty,
				isEnabled: retentionRule.isEnabled === 1 ? true : false,
				result: retentionRule,
				isHide: false,
				label: cvLoc('label.days') + ' ' + selectiveType.label,
				unitType: unitInfo.type
			};
			return obj;
		};

		storageCopyFactory.getAppropriateUnitType = (retentionDays, isInfinite) => {
			const unitsArr = storageCopyFactory.getUnitsArr(true);
			var unitInfo = angular.copy(unitsArr[0]);

			if (retentionDays === 0) {
				unitInfo = angular.copy(unitsArr[unitsArr.length - 1]);
				unitInfo.qty = 0;
				return unitInfo;
			}

			if (retentionDays > 0) {
				unitsArr.every(function(unit) {
					if (unit.type === 'MONTHS') {
						if (storageCopyFactory.convertDaysToMonth(retentionDays) != 0) {
							unitInfo = angular.copy(unit);
							unitInfo.qty = storageCopyFactory.convertDaysToMonth(retentionDays);
							if (unitInfo.qty <= 1) {
								unitInfo.label = unitInfo.label.substring(0, unitInfo.label.length - 1);
							}
							return false;
						}
					} else {
						if (retentionDays % unit.value === 0) {
							unitInfo = angular.copy(unit);
							unitInfo.qty = retentionDays / unit.value;
							if (unitInfo.qty <= 1) {
								unitInfo.label = unitInfo.label.substring(0, unitInfo.label.length - 1);
							}
							return false;
						}
					}

					return true;
				});
			}

			if (isInfinite) {
				unitInfo.type = 'INFINITE';
			}

			return unitInfo;
		};

		storageCopyFactory.generalFreqs = identifier => {
			const result = [
				{ value: `${identifier}_ALLFULL`, label: cvLoc('label.allFull') },
				{ value: `${identifier}_HOUR`, label: cvLoc('label.hourlyFull') },
				{ value: `${identifier}_DAY`, label: cvLoc('label.dailyFull') },
				{ value: `${identifier}_WEEK`, label: cvLoc('label.weeklyFull') },
				{ value: `${identifier}_MONTH`, label: cvLoc('label.monthlyFull') },
				{ value: `${identifier}_QUARTER`, label: cvLoc('label.quarterlyFull') },
				{ value: `${identifier}_HALFYEAR`, label: cvLoc('label.halfYearlyFull') },
				{ value: `${identifier}_YEAR`, label: cvLoc('label.yearlyFull') }
			];
			return result;
		};

		storageCopyFactory.updateSelectiveCopyInfo = (model, modelToBeUpdated) => {
			if (model.selectiveCopy && (!model.isSnapshotCopy || model.snapCopyType !== 1)) {
				modelToBeUpdated.copyType = 'SELECTIVE';
				modelToBeUpdated.selectiveCopyRules = {
					selectiveRule: model.selectedSelectiveFreq,
					dayStartsAt: {
						dayStartsHoursMinutes: {
							hours: 12,
							minutes: 0,
							seconds: 0
						},
						amOrPm: 1
					},
					weekDayStartsOn: 5,
					monthStartsOn: 1
				};
				if (model.datepicker && model.datepicker.value) {
					modelToBeUpdated.startTime = { time: model.datepicker.value / 1000 };
				}
			} else {
				if (model.enableBackupsOnAndAfter === false) {
					modelToBeUpdated.startTime = { time: -1 };
				} else {
					if (model.datepicker && model.datepicker.value) {
						modelToBeUpdated.startTime = { time: model.datepicker.value / 1000 };
					}
				}
			}
		};

		storageCopyFactory.getInputStoragePoolModel = (storagePools, model) => {
			let inputStoragePoolsModel = [];
			let pools = [];
			let selected = false;
			let storagePoolMap = {
				DEDUPLICATION: {
					label: cvLoc('label.storagePool.deDuplication'),
					pools: []
				},
				NON_DEDUPLICATION: {
					label: cvLoc('label.storagePool.nonDeDuplication'),
					pools: []
				},
				SECONDARY_COPY: {
					label: cvLoc('label.storagePool.secondaryCopy'),
					pools: []
				},
				SCALE_OUT: {
					label: cvLoc('label.storagePool.scaleOut'),
					pools: []
				},
				IBMi_VTL: {
					label: cvLoc('label.storagePool.IBMiVTL'),
					pools: []
				}
			};

			storagePools.forEach((item, index) => {
				item.name = item.storagePoolEntity.storagePoolName;
				if (item.storagePoolType) {
					if (item.storageSubType === 'IBMi_VTL') {
						storagePoolMap['IBMi_VTL'].pools.push(item);
					} else {
						storagePoolMap[item.storagePoolType].pools.push(item);
					}
				}
			});

			Object.keys(storagePoolMap).forEach(function(key) {
				selected = false;
				pools = storagePoolMap[key].pools;

				if (pools.length) {
					inputStoragePoolsModel.push({
						name: storagePoolMap[key].label,
						msGroup: true
					});

					if (
						model.storagePool &&
						model.storagePool.storagePoolEntity &&
						model.storagePool.storagePoolEntity.storagePoolId
					) {
						pools.forEach(item => {
							selected =
								item.storagePoolEntity.storagePoolId === model.storagePool.storagePoolEntity.storagePoolId
									? true
									: false;
							inputStoragePoolsModel.push({ ...item, selected: selected });
						});
					} else {
						pools.forEach(item => {
							inputStoragePoolsModel.push({ ...item, selected: selected });
						});
					}

					inputStoragePoolsModel.push({
						msGroup: false
					});
				}
			});
			return inputStoragePoolsModel;
		};

		storageCopyFactory.getUnitTypes = labelWithoutBrackets => {
			return labelWithoutBrackets
				? [
						{
							type: 'DAYS',
							label: cvLoc('label.retentionUnit.days'),
							value: 1,
							qty: 1
						},
						{
							type: 'WEEKS',
							label: cvLoc('label.retentionUnit.weeks'),
							value: 7,
							qty: 1
						},
						{
							type: 'MONTHS',
							label: cvLoc('label.retentionUnit.months'),
							value: 30,
							qty: 1
						},
						{
							type: 'YEARS',
							label: cvLoc('label.retentionUnit.years'),
							value: 365,
							qty: 1
						},
						{
							type: 'INFINITE',
							label: cvLoc('label.retentionUnit.infinite'),
							value: -1,
							qty: 1
						}
				  ]
				: [
						{
							type: 'DAYS',
							label: cvLoc('label.retentionUnit.daysWithBracket'),
							value: 1,
							qty: 1
						},
						{
							type: 'WEEKS',
							label: cvLoc('label.retentionUnit.weeksWithBracket'),
							value: 7,
							qty: 1
						},
						{
							type: 'MONTHS',
							label: cvLoc('label.retentionUnit.monthsWithBracket'),
							value: 30,
							qty: 1
						},
						{
							type: 'YEARS',
							label: cvLoc('label.retentionUnit.yearsWithBracket'),
							value: 365,
							qty: 1
						},
						{
							type: 'INFINITE',
							label: cvLoc('label.retentionUnit.infinite'),
							value: -1,
							qty: 1
						}
				  ];
		};

		storageCopyFactory.retentionPeriodOptions = [
			{
				label: 'Days',
				value: 'DAYS'
			},
			{
				label: 'Weeks',
				value: 'WEEKS'
			},
			{
				label: 'Months',
				value: 'MONTHS'
			},
			{
				label: 'Years',
				value: 'YEARS'
			},
			{
				label: 'Infinite',
				value: 'INFINITE'
			}
		];

		storageCopyFactory.getUnitsArr = labelWithoutBrackets => {
			const unitTypes = storageCopyFactory.getUnitTypes(labelWithoutBrackets);
			const unitsArr = angular
				.copy(unitTypes)
				.filter(unit => {
					return unit.type != 'INFINITE';
				})
				.reverse();
			return unitsArr;
		};

		storageCopyFactory.convertDaysToMonth = days => {
			//This is used to convert days to months in UI and is hard coded now
			//eg. We received 91 days or 152 days from backend response, need to convert it to 3 Months or 5 Months and display in UI
			const monthInDays = [
				30,
				60,
				91,
				121,
				152,
				182,
				212,
				243,
				273,
				304,
				334,
				364,
				395,
				425,
				456,
				486,
				516,
				547,
				577,
				608,
				638,
				669,
				699,
				729,
				760,
				790,
				821,
				851,
				881,
				912,
				942,
				973,
				1003,
				1033,
				1064
			];
			if (monthInDays.includes(days)) {
				return monthInDays.indexOf(days) + 1;
			}
			return 0;
		};

		storageCopyFactory.getNetAppVendor = () => {
			return {
				name: 'NetApp',
				id: 3
			};
		};

		storageCopyFactory.getAmazonVendor = () => {
			return {
				name: 'Amazon',
				id: 28
			};
		};

		storageCopyFactory.getNoVendor = () => {
			return {
				name: 'None',
				id: 0
			};
		};

		storageCopyFactory.isAmazonVendor = vendorInfo => {
			return vendorInfo === 28;
		};

		storageCopyFactory.isSVMValid = (model, storageList, scope) => {
			let snapCopyType = model.snapCopyType == undefined ? 0 : model.snapCopyType;
			let svmMappingExists = _.get(model, 'svmMapping', []).length > 0 ? true : false;
			if (snapCopyType === 0) {
				let copyInfo = storageList.find(storage => storage.StoragePolicyCopy.copyId === model.copyId);
				if (
					(!copyInfo || !planRuleFactory.isSnapPrimaryStorage(copyInfo)) &&
					planRuleFactory.isDefaultVaultReplicaCopyExists(storageList)
				) {
					if (copyInfo && planRuleFactory.isDefaultVaultReplica(copyInfo)) {
						return true;
					}

					if (svmMappingExists) {
						return true;
					}

					scope.serverMessage = cvUtil.errMsg(cvLoc('error.vaultcopy.noSVMMapping', model.storageName));
					return false;
				} else {
					return true;
				}
			} else if (snapCopyType === 1) {
				if (svmMappingExists) {
					return true;
				}

				scope.serverMessage = cvUtil.errMsg(cvLoc('error.mirror.noSVMMapping', model.storageName));
				return false;
			}
		};

		storageCopyFactory.updateSnapCopySVM = (model, modelToBeUpdated, storageList) => {
			let regionMaps = [];
			let repList = [];
			let isDefaultVaultCopy = storageList.filter(
				storage =>
					storage.isSnapCopy &&
					_.get(storage, 'extendedFlags.defaultReplicaCopy', false) &&
					storage.isMirrorCopy !== 'SET_TRUE'
			);

			//default vault replica
			if (
				model.snapCopyType === 0 &&
				(!isDefaultVaultCopy ||
					!isDefaultVaultCopy.length ||
					isDefaultVaultCopy[0].StoragePolicyCopy.copyId === model.copyId)
			) {
				_.forEach(model.svmMapping, function(elem) {
					if (elem.vendorType === 'Amazon') {
						regionMaps.push({
							sourceRegion: elem.srcArray.name,
							destinationRegion: elem.tgtArray.name
						});
					} else {
						repList.push({
							srcArray: elem.srcArray,
							tgtArray: elem.tgtArray
						});
					}
				});
				modelToBeUpdated.replPairList = repList;

				if (model.deletedRegions && model.deletedRegions.length) {
					_.forEach(model.deletedRegions, function(elem) {
						regionMaps.push({
							sourceRegion: elem.srcArray.name,
							destinationRegion: ''
						});
					});
				}

				modelToBeUpdated.regionMap = regionMaps;
			} else {
				if (storageCopyFactory.isAmazonVendor(model.selectedVendor)) {
					_.forEach(model.svmMapping, function(elem) {
						regionMaps.push({
							sourceRegion: elem.srcArray.name,
							destinationRegion: elem.tgtArray.name
						});
					});
				} else {
					modelToBeUpdated.replPairList = model.svmMapping;
				}

				if (model.deletedRegions && model.deletedRegions.length) {
					_.forEach(model.deletedRegions, function(elem) {
						regionMaps.push({
							sourceRegion: elem.srcArray.name,
							destinationRegion: ''
						});
					});
				}
				modelToBeUpdated.regionMap = regionMaps;
			}
		};

		storageCopyFactory.updateSnapCopyDetails = (isSnapPrimary, model, modelToBeUpdated, storageList) => {
			modelToBeUpdated.isSnapCopy = 'SET_TRUE';
			if (!isSnapPrimary) {
				modelToBeUpdated.extendedFlags = modelToBeUpdated.extendedFlags || {};
				delete modelToBeUpdated.extendedFlags.overRideGACPRetention;
				modelToBeUpdated.extendedFlags.useGlobalStoragePolicy = 'SET_TRUE';
				modelToBeUpdated.extendedFlags.useOfflineArrayReplication = 'SET_TRUE';
				modelToBeUpdated.sourceCopy = {
					copyId: _.get(model, 'snapSourceCopy.StoragePolicyCopy.copyId'),
					copyName: _.get(model, 'snapSourceCopy.StoragePolicyCopy.copyName')
				};
				if (model.snapCopyType === 0) {
					// Vault/replica
					modelToBeUpdated.extendedFlags.arrayReplicaCopy = 'SET_TRUE';
					let isDefaultVaultCopy = storageList.filter(
						storage => storage.isSnapCopy && _.get(storage, 'extendedFlags.defaultReplicaCopy', false)
					);

					if (isDefaultVaultCopy.length > 0) {
						let copyInfo = storageList.find(storage => storage.StoragePolicyCopy.copyId === model.copyId);

						if (copyInfo && planRuleFactory.isDefaultVaultReplica(copyInfo)) {
							modelToBeUpdated.extendedFlags.defaultReplicaCopy = 'SET_TRUE';
						} else {
							modelToBeUpdated.extendedFlags.defaultReplicaCopy = 'SET_FALSE';
						}
					} else {
						modelToBeUpdated.extendedFlags.defaultReplicaCopy = 'SET_TRUE';
					}
				} else if (model.snapCopyType === 1) {
					// Mirror
					modelToBeUpdated.isMirrorCopy = 'SET_TRUE';
					modelToBeUpdated.extendedFlags.arrayReplicaCopy = 'SET_TRUE';
					let isDefaultMirrorCopy = storageList.filter(
						storage => storage.isMirrorCopy && _.get(storage, 'extendedFlags.defaultReplicaCopy', false)
					);
					modelToBeUpdated.extendedFlags.defaultReplicaCopy = isDefaultMirrorCopy.length > 0 ? 'SET_FALSE' : 'SET_TRUE';
					modelToBeUpdated.retentionRules = {};
				}

				if (modelToBeUpdated.retentionRules.retainBackupDataForDays === 0) {
					//spool copy
					modelToBeUpdated.retentionRules.retainBackupDataForCycles = 0;
					modelToBeUpdated.retentionRules.retainArchiverDataForDays = 0;
				}
			}

			if (model.retentionMode === 'JOBS') {
				if (!modelToBeUpdated.retentionRules) {
					modelToBeUpdated.retentionRules = {};
				}

				if (!modelToBeUpdated.retentionRules.retentionFlags) {
					modelToBeUpdated.retentionRules.retentionFlags = {};
				}

				modelToBeUpdated.retentionRules.retentionFlags.jobBasedRetention = 'SET_TRUE';
				modelToBeUpdated.retentionRules.retainBackupDataForCycles = 1;
				modelToBeUpdated.retentionRules.retentionFlags.ignoreJobDependencyCheck = 'SET_FALSE';
				modelToBeUpdated.retentionRules.jobs = model.noOfSnapRecoveryPoints;
			} else {
				if (!modelToBeUpdated.retentionRules) {
					modelToBeUpdated.retentionRules = {};
				}

				if (!modelToBeUpdated.retentionRules.retentionFlags) {
					modelToBeUpdated.retentionRules.retentionFlags = {};
				}

				let copyInfo = storageList.find(storage => storage.StoragePolicyCopy.copyId === model.copyId);
				if (copyInfo) {
					if (copyInfo.retentionRules.retainBackupDataForCycles) {
						//if retention mode is changed from jobs to non jobs, reset the backupdataforcycles to 0 for snap copy.
						let retentionMode =
							copyInfo.retentionRules &&
							copyInfo.retentionRules.retentionFlags &&
							copyInfo.retentionRules.retentionFlags.jobBasedRetention
								? copyInfo.retentionRules.retentionFlags.jobBasedRetention == 'SET_FALSE'
									? 'NON_JOBS'
									: 'JOBS'
								: undefined;
						if (retentionMode && retentionMode !== model.retentionMode) {
							copyInfo.retentionRules.retainBackupDataForCycles = 0;
						}

						modelToBeUpdated.retentionRules.retentionFlags.ignoreJobDependencyCheck = 'SET_FALSE';
						if (copyInfo.retentionRules.retainBackupDataForCycles == 0) {
							modelToBeUpdated.retentionRules.retentionFlags.ignoreJobDependencyCheck = 'SET_TRUE';
						}
						modelToBeUpdated.retentionRules.retainBackupDataForCycles =
							copyInfo.retentionRules.retainBackupDataForCycles;
					} else {
						modelToBeUpdated.retentionRules.retainBackupDataForCycles = 0;
						modelToBeUpdated.retentionRules.retentionFlags.ignoreJobDependencyCheck = 'SET_TRUE';
					}
				} else {
					modelToBeUpdated.retentionRules.retainBackupDataForCycles = 0;
					modelToBeUpdated.retentionRules.retentionFlags.ignoreJobDependencyCheck = 'SET_TRUE';
				}
				modelToBeUpdated.retentionRules.retentionFlags.jobBasedRetention = 'SET_FALSE';
			}
		};

		storageCopyFactory.updateSecondaryCopyCycles = function(model, storageList, modelToBeUpdated) {
			if (model.isSnapshotCopy === false) {
				if (model.copyId) {
					if (!modelToBeUpdated.retentionRules) {
						modelToBeUpdated.retentionRules = {};
					}

					let copyInfo = storageList.find(storage => storage.StoragePolicyCopy.copyId === model.copyId);

					if (copyInfo) {
						if (copyInfo.retentionRules.retainBackupDataForCycles != undefined) {
							modelToBeUpdated.retentionRules.retainBackupDataForCycles =
								copyInfo.retentionRules.retainBackupDataForCycles;
						}
					}
				}
			}
		};

		storageCopyFactory.getCopyTypeName = function(storage) {
			if (isDefaultMirror(storage)) {
				return cvLoc('label.defaultMirrorCopy');
			} else if (isDefaultVaultReplica(storage)) {
				return cvLoc('label.defaultVaultCopy');
			} else if (factory.isMirror(storage)) {
				return cvLoc('label.mirrorCopy');
			} else if (isSelectiveVaultReplica(storage)) {
				return cvLoc('label.selectiveVaultCopy');
			} else if (isSnapPrimary(storage)) {
				return cvLoc('label.snapPrimary');
			} else if (isSynchronous(storage)) {
				return cvLoc('label.synchronous');
			} else if (factory.isPrimary(storage)) {
				return cvLoc('label.primary');
			}
		};

		storageCopyFactory._setupMappingGridOptions = function({
			vendorInfo,
			scope,
			currentCopyDefaultVaultReplica,
			deleteClass,
			fetchMappings,
			tableName,
			gridDataBound
		}) {
			let gridTitle = '';
			let gridEmptyMsg = cvLoc('svm.table.noEmptyMsg');
			let columns = {};

			if (currentCopyDefaultVaultReplica) {
				columns = {
					vendorType: {
						title: cvLoc('svm.col.vendor'),
						type: 'string',
						template: `<span cv-toggle="tooltip" cv-toggle-content="#:vendorType#">#:vendorType#</span>`
					},
					sourceSVM: {
						title: cvLoc('svm.col.sourceEntity'),
						type: 'string',
						template: `<span cv-toggle="tooltip" cv-toggle-content="#:srcArray.name#">#:srcArray.name#</span>`
					},
					targetSVM: {
						title: cvLoc('svm.col.targetEntity'),
						type: 'string',
						template: `<span cv-toggle="tooltip" cv-toggle-content="#:tgtArray.name#">#:tgtArray.name#</span>`
					},
					actionCol: {
						title: '',
						type: 'string',
						width: '5%',
						template: `<a class="k-icon k-i-delete k-i-trash ` + deleteClass + `"/>`
					}
				};
				gridTitle = cvLoc('svm.table.title');
			} else {
				if (vendorInfo) {
					gridTitle = vendorInfo.mapHeadingLabel;
					columns = {
						sourceSVM: {
							title: vendorInfo.sourceLabel,
							type: 'string',
							template: `<span cv-toggle="tooltip" cv-toggle-content="#:srcArray.name#">#:srcArray.name#</span>`
						},
						targetSVM: {
							title: vendorInfo.destLabel,
							type: 'string',
							template: `<span cv-toggle="tooltip" cv-toggle-content="#:tgtArray.name#">#:tgtArray.name#</span>`
						},
						actionCol: {
							title: '',
							type: 'string',
							width: '5%',
							template: `<a class="k-icon k-i-delete k-i-trash ` + deleteClass + `"/>`
						}
					};
				}
			}

			return {
				columns: columns,
				tableName: tableName,
				gridTitle: gridTitle,
				beforeGridInitialize: ({ grid }) => {
					scope.svmGrid = grid;
				},
				onGridDataBound: gridDataBound,
				url: fetchMappings,
				enableColumnMenu: false,
				enableFiltering: false,
				enableVirtualization: true,
				hasViews: false,
				gridEmptyMessage: gridEmptyMsg
			};
		};

		return storageCopyFactory;
	}
]);

export default planModule;
