import { commonPlanModule } from 'common/js/modules';

var planMod = commonPlanModule;

planMod.factory('planRuleFactory', [
	'cvLoc',
	'cvUtil',
	'$log',
	'profileService',
	'regionsService',
	'clientGroupService',
	function(cvLoc, cvUtil, $log, profileService, regionsService, clientGroupService) {
		var factory = {};
		factory.agents = [
			{ id: 0, name: 'ANY' },
			{ id: 1, name: 'Databases' },
			{ id: 2, name: 'File System' },
			{ id: 3, name: 'Virtualization' },
			{ id: 4, name: 'Cloud Apps' }
		];
		let allAgents = [];
		let allRegions = [];
		let allServerGroups = [];

		factory.getRuleTableArray = function(ruleList, resolve) {
			var selectedRuleItemObj = [];
			let promiseArray = new Array();
			promiseArray[0] = new Promise(function(resolve, reject) {
				factory.getAllRegions(resolve);
			});
			promiseArray[1] = new Promise(function(resolve, reject) {
				factory.getAllAgents(resolve);
			});
			promiseArray[2] = new Promise(function(resolve, reject) {
				factory.getAllServerGroups(resolve);
			});

			return Promise.all(promiseArray).then(function(values) {
				selectedRuleItemObj = ruleList.map((rule, index) => {
					var selectedRuleObj = {
						regionList: factory.getSelectedRegions(rule.regions.region),
						// "agentList":factory.getSelectedAgents(rule.agents.agent),
						// "serverGroup":rule.clientGroup.clientGroupName,
						Rank: rule.rank,
						id: index,
						PrimaryStoragePool: rule.storagePool.storagePoolName,
						retentionDays: rule.retentionDays
					};
					return selectedRuleObj;
				});
				resolve(selectedRuleItemObj);
			});
		};

		factory.getAllRegions = function(callback) {
			regionsService.getRegionList().success(function(data) {
				let regionList = data.regions.map(region => {
					var reg = { id: region.entity.regionId, name: region.entity.regionName };
					return reg;
				});
				allRegions = regionList;
				callback();
			});
		};
		factory.getAllAgents = function(callback) {
			//no mapping for now
			// let agentList = factory.agents.map((agent)=>{
			// 	var agentModel = {'id':agent.applicationId,'name':agent.name}
			// });
			allAgents = factory.agents;
			callback();
		};
		factory.getAllServerGroups = function(callback) {
			clientGroupService.getSCGEnumValues('CLIENT_GROUP').success(function(groupList) {
				allServerGroups = groupList;
				callback();
			});
		};

		factory.getSelectedRegions = function(selectedRegions) {
			return filterSelectedOption(allRegions, selectedRegions, 'regionId');
		};
		factory.getSelectedAgents = function(selectedAgents) {
			return filterSelectedOption(allAgents, selectedAgents, 'applicationId');
		};
		factory.getSelectedServerGroups = function(selectedServerGroup) {
			return allServerGroups.filter(serverGroup => serverGroup.value == selectedServerGroup.value);
		};

		/*
		 * Rules for setting the copy type name:
		 * <ul>
		 * 	<li>isMirrorCopy && extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy -> Default Mirror</li>
		 * 	<li>isSnapCopy && extendedFlags.arrayReplicaCopy && extendedFlags.defaultReplicaCopy -> Default selective Vault/Repica</li>
		 *  <li>isMirrorCopy && extendedFlags.arrayReplicaCopy -> Mirror</li>
		 *  <li>isSnapCopy && extendedFlags.arrayReplicaCopy -> Selective vault/replica</li>
		 * 	<li>isSnap -> Snap Primary</li>
		 * 	<li>!isDefault -> Synchronous</li>
		 * 	<li>isDefault -> Primary</li>
		 * </ul>
		 *
		 * NOTE: Both the Vault/Replica and Mirror copies will have isSnapCopy set to true. Mirror copies will have additionally isMirrorCopy set to true.
		 */
		factory.getCopyTypeName = function(storage) {
			if (isDefaultMirror(storage)) {
				return cvLoc('label.defaultMirrorCopy');
			} else if (factory.isDefaultVaultReplica(storage)) {
				return cvLoc('label.defaultVaultCopy');
			} else if (factory.isMirror(storage)) {
				return cvLoc('label.mirrorCopy');
			} else if (isVaultReplica(storage)) {
				return cvLoc('label.vaultCopy');
			} else if (isSnapPrimary(storage)) {
				return cvLoc('label.snapPrimary');
			}
		};

		factory.getPrimaryCopy = function(copies) {
			return copies.find(copy => factory.isPrimary(copy));
		};

		factory.getPrimarySnapCopy = function(copies) {
			return copies.find(copy => factory.isSnapPrimaryStorage(copy));
		};

		factory.isDefaultVaultReplicaCopyExists = function(copies) {
			return copies.findIndex(copy => !factory.isMirror(copy) && factory.isDefaultVaultReplica(copy)) !== -1;
		};

		factory.isJobBasedCopy = function(copy) {
			return (
				copy.retentionRules &&
				copy.retentionRules.retentionFlags &&
				copy.retentionRules.retentionFlags.jobBasedRetention &&
				copy.retentionRules.retentionFlags.jobBasedRetention === 'SET_TRUE'
			);
		};

		factory.showSnapRecovery = function(copies) {
			let snapPrimaryCopy = factory.getPrimarySnapCopy(copies);
			if (snapPrimaryCopy) {
				return factory.isJobBasedCopy(snapPrimaryCopy);
			}
			return false;
		};

		factory.isSnapPrimaryStorage = function(storage) {
			return (
				!isDefaultMirror(storage) &&
				!factory.isDefaultVaultReplica(storage) &&
				!factory.isMirror(storage) &&
				!isVaultReplica(storage) &&
				isSnapPrimary(storage)
			);
		};

		function isDefaultMirror(storage) {
			return factory.isMirror(storage) && booleanOf(storage.extendedFlags.defaultReplicaCopy);
		}

		factory.isDefaultVaultReplica = function(storage) {
			return isVaultReplica(storage) && booleanOf(storage.extendedFlags.defaultReplicaCopy);
		};

		factory.isMirror = function(storage) {
			return booleanOf(storage.isMirrorCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy);
		};

		function isSelectiveVaultReplica(storage) {
			return booleanOf(storage.isSnapCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy);
		}

		function isVaultReplica(storage) {
			return booleanOf(storage.isSnapCopy) && booleanOf(storage.extendedFlags.arrayReplicaCopy);
		}

		function isSnapPrimary(storage) {
			return booleanOf(storage.isSnapCopy);
		}

		function isSynchronous(storage) {
			return !booleanOf(storage.isDefault);
		}

		factory.isPrimary = function(storage) {
			return booleanOf(storage.isDefault);
		};

		/* returns the boolean value of the FlagEnum property */
		function booleanOf(prop) {
			return !!(prop === 'SET_TRUE') || prop === 1;
		}

		function filterSelectedOption(list, model, key) {
			var result = list.filter(o => model.some(modelObj => o.id === modelObj[key]));
			console.log(result);
			result = result.map(o => o.name);
			let selectedList = result.join(',');
			return selectedList;
		}

		return factory;
	}
]);

export default planMod;
