import { acAppExchangeModule } from 'common/js/modules';

var module = acAppExchangeModule;
/**
 * A directive used for editing the Cleanup Quota rules for the Cleanup policy.
 */
module.directive('cvExchangePlanCleanupQuota', [
	function() {
		return {
			restrict: 'E',
			require: ['^^cvSubmit', '^^form'],
			scope: {
				cleanupPolicy: '=',
				usedDiskSpace: '='
			},
			templateUrl: appUtil.appRoot + 'modules/plan/partials/exchange/cleanupQuotaForm.jsp',
			link: function(scope, elem, attr, controllers) {
				scope.submitController = controllers[0];
				scope.formController = controllers[1];

				if (elem.parents('.modal-content').length > 0) {
					scope.inModal = true;
				}
			}
		};
	}
]);

export default module;
