import 'ediscovery/common/js/services/ediscovery.svc.js';

import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.directive('cvPlanEePolicy', [
	function() {
		// Runs during compile
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/eePolicy.jsp',
			scope: {},
			bindToController: {
				eePolicy: '=',
				ediscoveryInfo: '=',
				readOnly: '@',
				ciPolicy: '=',
				hideEECheckBox: '=?'
			},
			require: ['?^^cvSubmit', '?^^form'],
			controllerAs: 'model',
			link: function(scope, elem, attr, controllers) {
				scope.submitCtrl = controllers[0];
				scope.formCtrl = controllers[1];
			},
			controller: [
				'$scope',
				'cvUtil',
				'cvLoc',
				'REGEX',
				'ediscoveryService',
				function($scope, cvUtil, cvLoc, REGEX, ediscoveryService) {
					const self = this;
					self.localLang = cvUtil.getIStevenLocLabels();
					self.contentAnalyzers = [];
					self.selectedContentAnalyzer = [];
					this.$onInit = function() {
						if (!self.hideEECheckBox) {
							self.hideEECheckBox = false;
						}
						$scope.enablePolicyChanged = function() {
							if (!self.enableEEPolicy) {
								if (!angular.isDefined(self.eePolicy)) self.eePolicy = {};

								self.eePolicy.detail = {};
							}
							//					self.eePolicy = undefined;
							//					self.eePolicy.detail.eePolicy = {};
							// There's no need to null this variable, because it's never set. This is creating an issue when entities checkbox is enabled while creation with CACloud and without
							// entities selected.
							if (angular.isUndefined(self.ediscoveryInfo.contentAnalyzerCloud)) {
								self.ediscoveryInfo.contentAnalyzerCloud = undefined;
							}
						};

						function initialize() {
							if (
								angular.isDefined(self.eePolicy) &&
								angular.isDefined(self.eePolicy.detail) &&
								angular.isDefined(self.eePolicy.detail.eePolicy) &&
								angular.isDefined(self.eePolicy.policyType)
							) {
								self.enableEEPolicy = true;
							}
							if (self.hideEECheckBox) {
								self.enableEEPolicy = true;
							}
							ediscoveryService
								.getContentAnalyzer()
								.success(function(data) {
									if (angular.isDefined(data)) {
										self.contentAnalyzers = cvUtil.sortAscending(data, 'cloudName');
										if (self.contentAnalyzers.length === 0) {
											self.errorMsg = {
												message: cvLoc('error.noContentAnalyzer') + error,
												type: 'error'
											};
										} else {
											const existingCloudId = _.get(self.ediscoveryInfo, 'contentAnalyzerCloud.cloudId', 0);
											if (existingCloudId !== 0) {
												_.forEach(self.contentAnalyzers, ca => {
													if (ca.cloudId === existingCloudId) {
														ca.selected = true;
														self.selectedContentAnalyzer = [ca];
													}
												});
											} else {
												self.contentAnalyzers[0].selected = true;
											}
										}
									}
								})
								.error(error => {
									self.errorMsg = {
										message: cvLoc('error.unableToFetchCA') + error,
										type: 'error'
									};
								});
						}

						$scope.$watch('model.eePolicy.policyType', function(newValue, oldValue) {
							if (newValue !== oldValue) {
								self.enableEEPolicy = angular.isDefined(newValue);
							}
						});

						$scope.$watch('model.selectedContentAnalyzer', function(newValue, oldValue) {
							if (newValue[0] && newValue[0].cloudId) {
								self.ediscoveryInfo.contentAnalyzerCloud = {};
								self.ediscoveryInfo.contentAnalyzerCloud.cloudId = newValue[0].cloudId;
								// self.ediscoveryInfo.contentAnalyzerCloud = self.ediscoveryInfo.contentAnalyzerCloud;
							}
						});

						//				// initialization
						initialize();
					};
				}
			]
		};
	}
]);

export default planModule;
