import 'ediscovery/common/js/services/ediscovery.svc.js';
import 'exchange/js/services/exchange.svc.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import {
	CONTENT_INDEXING_TARGET_APP as APP,
	CITargetApp,
	ACTIVATE,
	ACTIVATE_CI,
	ServiceTypes
} from 'ediscovery/common/js/constants.js';
import { office365AppsFactory } from 'office365/js/factory/office365Apps.factory.js';
import { utilsConstants } from 'office365/js/constants/utilsConstants.js';
import { commonPlanModule } from 'common/js/modules';

var planModule = commonPlanModule;

planModule.directive('cvPlanDcpolicyGeneral', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/plan/partials/dcPolicyGeneralConfigTemplate.jsp',
			controllerAs: 'model',
			require: ['?^^cvSubmit', '?^^form'],
			scope: {
				ediscoveryInfo: '=',
				planOptions: '=',
				targetApplication: '@',
				readOnly: '@',
				labelPosition: '@', // css class for position of label
				controlPosition: '@' // css class for position of multiselect
			},
			link: function(scope, elem, attr, controllers) {
				scope.submitCtrl = controllers[0];
				scope.formCtrl = controllers[1];
			},
			controller: [
				'$scope',
				'$uibModal',
				'cvUtil',
				'ediscoveryService',
				'exchangeService',
				'cvLoc',
				function($scope, $uibModal, cvUtil, ediscoveryService, exchangeService, cvLoc) {
					let self = this;
					self.localLang = cvUtil.getIStevenLocLabels();
					self.office365AppsFactory = new office365AppsFactory($uibModal);
					$scope.ediscoveryInfo = angular.isUndefined($scope.ediscoveryInfo) ? {} : $scope.ediscoveryInfo;
					self.ediscoveryInfo = $scope.ediscoveryInfo;
					$scope.planOptions = angular.isUndefined($scope.planOptions) ? {} : $scope.planOptions;
					$scope.planOptions.targetApps = angular.isUndefined($scope.planOptions.targetApps)
						? []
						: $scope.planOptions.targetApps;
					self.planOptions = $scope.planOptions;
					self.readOnly = angular.isUndefined($scope.readOnly) ? false : $scope.readOnly === 'true';
					self.labelPosition = angular.isUndefined($scope.labelPosition)
						? 'col-xs-12 col-lg-4 col-md-4 col-md-offset-1 col-lg-offset-1'
						: $scope.labelPosition;
					self.controlPosition = angular.isUndefined($scope.controlPosition)
						? 'col-xs-12 col-md-6 col-lg-6'
						: $scope.controlPosition;
					self.pathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
					self.indexServerOption = 'createNew';
					$scope.$watch('ediscoveryInfo', function(newValue, oldValue) {
						self.ediscoveryInfo = newValue;
					});

					self.initializeTargetApps = function() {
						if (self.readOnly) {
							const targetApp = self.planOptions.targetApps[0];
							switch (targetApp) {
								case CITargetApp.FSO:
									self.selectedTargetApp = cvLoc('label.analytics');
									break;
								case CITargetApp.SDG:
									self.selectedTargetApp = cvLoc('label.gdpr');
									break;
								case CITargetApp.CM:
									self.selectedTargetApp = cvLoc('label.casemanager');
									break;
								case CITargetApp.FS:
									self.selectedTargetApp = cvLoc('label.contentIndexing');
									break;
							}
						}
					};

					self.initialize = function() {
						if (!self.readOnly) {
							self.getIndexServers();
						}
						self.initializeTargetApps();
					};

					self.isCaseManager = function() {
						return self.planOptions.targetApps[0] === APP.CASE_MANAGER;
					};

					self.getIndexServers = function() {
						self.indexServers = [];
						ediscoveryService.getIndexServers(!self.isCaseManager()).then(resp => {
							let temp_indexServers = resp.data.indexServers;
							_.each(temp_indexServers, idx => {
								let indexServer = {
									indexServerClientName: _.get(idx, 'clients.clientName'),
									indexServerClientId: _.get(idx, 'clients.clientId')
								};
								self.indexServers.push(indexServer);
							});

							self.indexServers = cvUtil.sortAscending(self.indexServers, 'indexServerClientName');
							if (self.indexServers.length > 0) {
								self.indexServers[0].selected = true;
							}

							if (_.has(self, 'ediscoveryInfo.analyticsIndexServer.clientId')) {
								for (let idx of self.indexServers) {
									if (idx.indexServerClientId === self.ediscoveryInfo.analyticsIndexServer.clientId) {
										idx.selected = true;
										break;
									}
								}
							}
						});
					};

					self.addIndexServer = () => {
						let appType = ACTIVATE;
						if ($scope.targetApplication == ServiceTypes.FileSystem) {
							appType = ACTIVATE_CI;
						}

						const configOptions = {
							appType: appType,
							indexServerType: utilsConstants.indexServerType.STANDALONE,
							windowClass: ' '
						};

						self.office365AppsFactory.addIndexServer(configOptions).result.then(() => {
							self.ediscoveryInfo.analyticsIndexServer = {};
							self.getIndexServers();
						});
					};

					$scope.$watch('model.selectedIndexServers', function(newValue, oldValue) {
						const indexServerClientId = _.get(newValue, '[0].indexServerClientId', 0);
						if (indexServerClientId !== 0) {
							self.ediscoveryInfo.analyticsIndexServer = {};
							self.ediscoveryInfo.analyticsIndexServer.clientId = indexServerClientId;
							$scope.ediscoveryInfo.analyticsIndexServer = self.ediscoveryInfo.analyticsIndexServer;
						}
					});

					self.initialize();
				}
			]
		};
	}
]);

export default planModule;
